/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.service.cdi.event.AuthConfigurationEvent;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.Scheduled;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class LocalResponseCache {
    public static final int DEFAULT_DISCOVERY_LIFETIME = 60;
    public static final int DEFAULT_SECTOR_IDENTIFIER_LIFETIME = 1440;
    private static final String DISCOVERY_CACHE_KEY = "DISCOVERY_CACHE_KEY";
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Logger log;
    private final AtomicBoolean rebuilding = new AtomicBoolean(false);
    private Cache<String, JSONObject> discoveryCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    private Cache<String, List<String>> sectorIdentifierCache = CacheBuilder.newBuilder().expireAfterWrite(1440L, TimeUnit.MINUTES).build();
    private int currentDiscoveryLifetime = 60;
    private int currentSectorIdentifierLifetime = 1440;

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled AuthConfigurationEvent authConfigurationEvent) {
        try {
            if (this.rebuilding.get()) {
                return;
            }
            this.rebuilding.set(true);
            if (this.currentDiscoveryLifetime != this.appConfiguration.getDiscoveryCacheLifetimeInMinutes()) {
                this.currentDiscoveryLifetime = this.appConfiguration.getDiscoveryCacheLifetimeInMinutes();
                this.discoveryCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.appConfiguration.getDiscoveryCacheLifetimeInMinutes(), TimeUnit.MINUTES).build();
                this.log.trace("Re-created discovery cache with lifetime: " + this.appConfiguration.getDiscoveryCacheLifetimeInMinutes());
            }
            if (this.currentSectorIdentifierLifetime != this.appConfiguration.getSectorIdentifierCacheLifetimeInMinutes()) {
                this.currentSectorIdentifierLifetime = this.appConfiguration.getSectorIdentifierCacheLifetimeInMinutes();
                this.sectorIdentifierCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.appConfiguration.getSectorIdentifierCacheLifetimeInMinutes(), TimeUnit.MINUTES).build();
                this.log.trace("Re-created sector identifier cache with lifetime: " + this.appConfiguration.getSectorIdentifierCacheLifetimeInMinutes());
            }
        }
        finally {
            this.rebuilding.set(false);
        }
    }

    public List<String> getSectorRedirectUris(String sectorIdentifierUri) {
        if (this.sectorIdentifierCache == null || this.rebuilding.get()) {
            return null;
        }
        return (List)this.sectorIdentifierCache.getIfPresent((Object)sectorIdentifierUri);
    }

    public void putSectorRedirectUris(String sectorIdentifierUri, List<String> redirectUris) {
        if (this.sectorIdentifierCache == null || this.rebuilding.get()) {
            return;
        }
        this.sectorIdentifierCache.put((Object)sectorIdentifierUri, redirectUris);
    }

    public JSONObject getDiscoveryResponse() {
        if (this.discoveryCache == null || this.rebuilding.get()) {
            return null;
        }
        return (JSONObject)this.discoveryCache.getIfPresent((Object)DISCOVERY_CACHE_KEY);
    }

    public void putDiscoveryResponse(JSONObject response) {
        if (this.discoveryCache == null || this.rebuilding.get()) {
            return;
        }
        this.discoveryCache.put((Object)DISCOVERY_CACHE_KEY, (Object)response);
    }
}

