/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.configuration.AuthenticationProtectionConfiguration;
import org.gluu.service.cdi.event.ConfigurationUpdate;

@ApplicationScoped
@Named
public class AuthenticationProtectionService
extends org.gluu.service.security.protect.AuthenticationProtectionService {
    private static final int DEFAULT_ATTEMPT_EXPIRATION = 15;
    private static final int DEFAULT_MAXIMUM_ALLOWED_ATTEMPTS_WITHOUT_DELAY = 4;
    private static final int DEFAULT_DELAY_TIME = 2;
    private static final String DEFAULT_KEY_PREFIX = "user";
    @Inject
    private AppConfiguration appConfiguration;

    protected void init() {
        this.updateConfiguration(this.appConfiguration);
    }

    public void updateConfiguration(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        AuthenticationProtectionConfiguration authenticationProtectionConfiguration = appConfiguration.getAuthenticationProtectionConfiguration();
        if (authenticationProtectionConfiguration == null) {
            this.attemptExpiration = 15;
            this.maximumAllowedAttemptsWithoutDelay = 4;
            this.delayTime = 2;
        } else {
            this.attemptExpiration = authenticationProtectionConfiguration.getAttemptExpiration();
            this.maximumAllowedAttemptsWithoutDelay = authenticationProtectionConfiguration.getMaximumAllowedAttemptsWithoutDelay();
            this.delayTime = authenticationProtectionConfiguration.getDelayTime();
        }
    }

    protected String getKeyPrefix() {
        return DEFAULT_KEY_PREFIX;
    }

    public boolean isEnabled() {
        AuthenticationProtectionConfiguration authenticationProtectionConfiguration = this.appConfiguration.getAuthenticationProtectionConfiguration();
        return authenticationProtectionConfiguration != null && authenticationProtectionConfiguration.getBruteForceProtectionEnabled() != false;
    }
}

