/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.model.GluuAttribute;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.service.BaseCacheService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class AttributeService
extends org.gluu.service.AttributeService {
    private static final long serialVersionUID = -990409035168814270L;
    @Inject
    private Logger log;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    public GluuAttribute getAttributeByDn(String dn) {
        BaseCacheService usedCacheService = this.getCacheService();
        return (GluuAttribute)usedCacheService.getWithPut(dn, () -> (GluuAttribute)this.persistenceEntryManager.find(GluuAttribute.class, (Object)dn), 60);
    }

    public GluuAttribute getByLdapName(String name) {
        List gluuAttributes = this.getAttributesByAttribute("gluuAttributeName", name, this.staticConfiguration.getBaseDn().getAttributes());
        if (gluuAttributes.size() > 0) {
            for (GluuAttribute gluuAttribute : gluuAttributes) {
                if (gluuAttribute.getName() == null || !gluuAttribute.getName().equals(name)) continue;
                return gluuAttribute;
            }
        }
        return null;
    }

    public GluuAttribute getByClaimName(String name) {
        List gluuAttributes = this.getAttributesByAttribute("oxAuthClaimName", name, this.staticConfiguration.getBaseDn().getAttributes());
        if (gluuAttributes.size() > 0) {
            for (GluuAttribute gluuAttribute : gluuAttributes) {
                if (gluuAttribute.getOxAuthClaimName() == null || !gluuAttribute.getOxAuthClaimName().equals(name)) continue;
                return gluuAttribute;
            }
        }
        return null;
    }

    public List<GluuAttribute> getAllAttributes() {
        return this.getAllAttributes(this.staticConfiguration.getBaseDn().getAttributes());
    }

    public String getDnForAttribute(String inum) {
        String attributesDn = this.staticConfiguration.getBaseDn().getAttributes();
        if (StringHelper.isEmpty((String)inum)) {
            return attributesDn;
        }
        return String.format("inum=%s,%s", inum, attributesDn);
    }

    public List<String> getAttributesDn(List<String> claimNames) {
        ArrayList<String> claims = new ArrayList<String>();
        for (String claimName : claimNames) {
            GluuAttribute gluuAttribute = this.getByClaimName(claimName);
            if (gluuAttribute == null) continue;
            claims.add(gluuAttribute.getDn());
        }
        return claims;
    }

    protected BaseCacheService getCacheService() {
        if (this.appConfiguration.getUseLocalCache().booleanValue()) {
            return this.localCacheService;
        }
        return this.cacheService;
    }
}

