/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.revoke;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.ArrayUtils;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.session.EndSessionErrorResponseType;
import org.gluu.oxauth.model.session.SessionClient;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.slf4j.Logger;

@Path(value="/")
public class RevokeSessionRestWebService {
    @Inject
    private Logger log;
    @Inject
    private UserService userService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private Identity identity;
    @Inject
    private ScopeService scopeService;

    @POST
    @Path(value="/revoke_session")
    @Produces(value={"application/json"})
    public Response requestRevokeSession(@FormParam(value="user_criterion_key") String userCriterionKey, @FormParam(value="user_criterion_value") String userCriterionValue, @Context HttpServletRequest request, @Context HttpServletResponse response, @Context SecurityContext sec) {
        try {
            this.log.debug("Attempting to revoke session: userCriterionKey = {}, userCriterionValue = {}, isSecure = {}", new Object[]{userCriterionKey, userCriterionValue, sec.isSecure()});
            this.validateAccess();
            User user = this.userService.getUserByAttribute(userCriterionKey, userCriterionValue);
            if (user == null) {
                this.log.trace("Unable to find user by {}={}", (Object)userCriterionKey, (Object)userCriterionValue);
                return Response.ok().build();
            }
            List<SessionId> sessionIdList = this.sessionIdService.findByUser(user.getDn());
            if (sessionIdList == null || sessionIdList.isEmpty()) {
                this.log.trace("No sessions found for user uid: {}, dn: {}", (Object)user.getUserId(), (Object)user.getDn());
                return Response.ok().build();
            }
            List<SessionId> authenticatedSessions = sessionIdList.stream().filter(sessionId -> sessionId.getState() == SessionIdState.AUTHENTICATED).collect(Collectors.toList());
            this.sessionIdService.remove(authenticatedSessions);
            this.log.debug("Revoked {} user's sessions (user: {})", (Object)authenticatedSessions.size(), (Object)user.getUserId());
            return Response.ok().build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    private void validateAccess() {
        SessionClient sessionClient = this.identity.getSessionClient();
        if (sessionClient == null || sessionClient.getClient() == null || ArrayUtils.isEmpty((Object[])sessionClient.getClient().getScopes())) {
            this.log.debug("Client failed to authenticate.");
            throw new WebApplicationException(Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST)).build());
        }
        List<String> scopesAllowedIds = this.scopeService.getScopeIdsByDns(Arrays.asList(sessionClient.getClient().getScopes()));
        if (!scopesAllowedIds.contains("revoke_session")) {
            this.log.debug("Client does not have required revoke_session scope.");
            throw new WebApplicationException(Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST)).build());
        }
    }
}

