/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.token;

import com.google.common.base.Strings;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.AlgorithmFamily;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.ClientAssertionType;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.service.ClientService;
import org.gluu.service.cdi.util.CdiUtil;
import org.gluu.util.security.StringEncrypter;
import org.json.JSONObject;

public class ClientAssertion {
    private Jwt jwt;
    private String clientSecret;

    public ClientAssertion(AppConfiguration appConfiguration, AbstractCryptoProvider cryptoProvider, String clientId, ClientAssertionType clientAssertionType, String encodedAssertion) throws InvalidJwtException {
        try {
            if (!this.load(appConfiguration, cryptoProvider, clientId, clientAssertionType, encodedAssertion)) {
                throw new InvalidJwtException("Cannot load the JWT");
            }
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJwtException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJwtException("Cannot verify the JWT", (Throwable)e);
        }
    }

    public String getSubjectIdentifier() {
        return this.jwt.getClaims().getClaimAsString("sub");
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean load(AppConfiguration appConfiguration, AbstractCryptoProvider cryptoProvider, String clientId, ClientAssertionType clientAssertionType, String encodedAssertion) throws Exception {
        if (clientAssertionType != ClientAssertionType.JWT_BEARER) throw new InvalidJwtException("Invalid Client Assertion Type");
        if (!StringUtils.isNotBlank((String)encodedAssertion)) throw new InvalidJwtException("The Client Assertion is null or empty");
        this.jwt = Jwt.parse((String)encodedAssertion);
        String issuer = this.jwt.getClaims().getClaimAsString("iss");
        String subject = this.jwt.getClaims().getClaimAsString("sub");
        List audience = this.jwt.getClaims().getClaimAsStringList("aud");
        Date expirationTime = this.jwt.getClaims().getClaimAsDate("exp");
        if (!(clientId == null && StringUtils.isNotBlank((String)issuer) && StringUtils.isNotBlank((String)subject) && issuer.equals(subject))) {
            if (!StringUtils.isNotBlank((String)clientId)) throw new InvalidJwtException("Invalid clientId");
            if (!StringUtils.isNotBlank((String)issuer)) throw new InvalidJwtException("Invalid clientId");
            if (!StringUtils.isNotBlank((String)subject)) throw new InvalidJwtException("Invalid clientId");
            if (!clientId.equals(issuer)) throw new InvalidJwtException("Invalid clientId");
            if (!issuer.equals(subject)) throw new InvalidJwtException("Invalid clientId");
        }
        String tokenUrl = appConfiguration.getTokenEndpoint();
        String cibaAuthUrl = appConfiguration.getBackchannelAuthenticationEndpoint();
        if (audience == null) throw new InvalidJwtException("Invalid audience: " + audience);
        if (!audience.contains(appConfiguration.getIssuer()) && !audience.contains(tokenUrl)) {
            if (!audience.contains(cibaAuthUrl)) throw new InvalidJwtException("Invalid audience: " + audience);
        }
        if (!expirationTime.after(new Date())) throw new InvalidJwtException("JWT has expired");
        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
        Client client = clientService.getClient(subject);
        if (client == null) throw new InvalidJwtException("Invalid client");
        JwtType jwtType = JwtType.fromString((String)this.jwt.getHeader().getClaimAsString("typ"));
        AuthenticationMethod authenticationMethod = client.getAuthenticationMethod();
        SignatureAlgorithm signatureAlgorithm = this.jwt.getHeader().getSignatureAlgorithm();
        if (jwtType == null && signatureAlgorithm != null) {
            jwtType = signatureAlgorithm.getJwtType();
        }
        if (jwtType == null) throw new InvalidJwtException("Invalid authentication method");
        if (signatureAlgorithm == null) throw new InvalidJwtException("Invalid authentication method");
        if (signatureAlgorithm.getFamily() == null) throw new InvalidJwtException("Invalid authentication method");
        if (authenticationMethod != AuthenticationMethod.CLIENT_SECRET_JWT || !AlgorithmFamily.HMAC.equals((Object)signatureAlgorithm.getFamily())) {
            if (authenticationMethod != AuthenticationMethod.PRIVATE_KEY_JWT) throw new InvalidJwtException("Invalid authentication method");
            if (!AlgorithmFamily.RSA.equals((Object)signatureAlgorithm.getFamily())) {
                if (!AlgorithmFamily.EC.equals((Object)signatureAlgorithm.getFamily())) throw new InvalidJwtException("Invalid authentication method");
            }
        }
        if (client.getTokenEndpointAuthSigningAlg() != null) {
            if (!SignatureAlgorithm.fromString((String)client.getTokenEndpointAuthSigningAlg()).equals((Object)signatureAlgorithm)) throw new InvalidJwtException("Invalid signing algorithm");
        }
        this.clientSecret = clientService.decryptSecret(client.getClientSecret());
        String keyId = this.jwt.getHeader().getKeyId();
        JSONObject jwks = Strings.isNullOrEmpty((String)client.getJwks()) ? JwtUtil.getJSONWebKeys((String)client.getJwksUri()) : new JSONObject(client.getJwks());
        String sharedSecret = clientService.decryptSecret(client.getClientSecret());
        boolean validSignature = cryptoProvider.verifySignature(this.jwt.getSigningInput(), this.jwt.getEncodedSignature(), keyId, jwks, sharedSecret, signatureAlgorithm);
        if (!validSignature) throw new InvalidJwtException("Invalid cryptographic segment");
        return true;
    }
}

