/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.ldap;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.ldap.TokenAttributes;
import org.gluu.oxauth.model.ldap.TokenType;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.Expiration;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;

@DataEntry
@ObjectClass(value="token")
public class TokenLdap
implements Serializable {
    @DN
    private String dn;
    @AttributeName(name="grtId", consistency=true)
    private String grantId;
    @AttributeName(name="usrId")
    private String userId;
    @AttributeName(name="clnId")
    private String clientId;
    @AttributeName(name="iat")
    private Date creationDate;
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private boolean deletable = true;
    @AttributeName(name="authnTime")
    private Date authenticationTime;
    @AttributeName(name="scp")
    private String scope;
    @AttributeName(name="tknCde", consistency=true)
    private String tokenCode;
    @AttributeName(name="tknTyp")
    private String tokenType;
    @AttributeName(name="grtTyp")
    private String grantType;
    @AttributeName(name="jwtReq")
    private String jwtRequest;
    @AttributeName(name="authzCode", consistency=true)
    private String authorizationCode;
    @AttributeName(name="nnc")
    private String nonce;
    @AttributeName(name="chlng")
    private String codeChallenge;
    @AttributeName(name="chlngMth")
    private String codeChallengeMethod;
    @AttributeName(name="clms")
    private String claims;
    @AttributeName(name="tknBndCnf")
    private String tokenBindingHash;
    @AttributeName(name="acr")
    private String authMode;
    @AttributeName(name="ssnId", consistency=true)
    private String sessionDn;
    @Expiration
    private Integer ttl;
    @AttributeName(name="attr")
    @JsonObject
    private TokenAttributes attributes;
    private boolean isFromCache;

    public TokenAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new TokenAttributes();
        }
        return this.attributes;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public final void setAttributes(TokenAttributes attributes) {
        this.attributes = attributes;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String p_authorizationCode) {
        this.authorizationCode = p_authorizationCode;
    }

    public String getTokenBindingHash() {
        return this.tokenBindingHash;
    }

    public void setTokenBindingHash(String tokenBindingHash) {
        this.tokenBindingHash = tokenBindingHash;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getGrantId() {
        return this.grantId;
    }

    public void setGrantId(String p_grantId) {
        this.grantId = p_grantId;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date p_authenticationTime) {
        this.authenticationTime = p_authenticationTime;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date p_creationDate) {
        this.creationDate = p_creationDate;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date p_expirationDate) {
        this.expirationDate = p_expirationDate;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String p_grantType) {
        this.grantType = p_grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String p_scope) {
        this.scope = p_scope;
    }

    public String getTokenCode() {
        return this.tokenCode;
    }

    public void setTokenCode(String p_tokenCode) {
        this.tokenCode = p_tokenCode;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String p_tokenType) {
        this.tokenType = p_tokenType;
    }

    public TokenType getTokenTypeEnum() {
        return TokenType.fromValue(this.tokenType);
    }

    public void setTokenTypeEnum(TokenType p_tokenType) {
        if (p_tokenType != null) {
            this.tokenType = p_tokenType.getValue();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String p_userId) {
        this.userId = p_userId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getJwtRequest() {
        return this.jwtRequest;
    }

    public void setJwtRequest(String p_jwtRequest) {
        this.jwtRequest = p_jwtRequest;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getSessionDn() {
        return this.sessionDn;
    }

    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    public boolean isFromCache() {
        return this.isFromCache;
    }

    public void setIsFromCache(boolean isFromCache) {
        this.isFromCache = isFromCache;
    }

    public final void setFromCache(boolean isFromCache) {
        this.isFromCache = isFromCache;
    }

    public boolean isImplicitFlow() {
        return StringUtils.isBlank((String)this.grantType) || this.grantType.equals(GrantType.IMPLICIT.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenLdap tokenLdap = (TokenLdap)o;
        if (this.tokenCode != null ? !this.tokenCode.equals(tokenLdap.tokenCode) : tokenLdap.tokenCode != null) {
            return false;
        }
        return !(this.tokenType != null ? !this.tokenType.equals(tokenLdap.tokenType) : tokenLdap.tokenType != null);
    }

    public int hashCode() {
        int result = this.tokenCode != null ? this.tokenCode.hashCode() : 0;
        result = 31 * result + (this.tokenType != null ? this.tokenType.hashCode() : 0);
        return result;
    }
}

