/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import javax.inject.Inject;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.CacheGrant;
import org.gluu.oxauth.model.common.CibaRequestCacheControl;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.service.CacheService;

public class CIBAGrant
extends AuthorizationGrant {
    private String authReqId;
    private boolean tokensDelivered;
    @Inject
    private CacheService cacheService;

    @Override
    public GrantType getGrantType() {
        return GrantType.CIBA;
    }

    public void init(CibaRequestCacheControl cibaRequest) {
        super.init(cibaRequest.getUser(), AuthorizationGrantType.CIBA, cibaRequest.getClient(), null);
        this.setAuthReqId(cibaRequest.getAuthReqId());
        this.setAcrValues(cibaRequest.getAcrValues());
        this.setIsCachedWithNoPersistence(true);
    }

    @Override
    public void save() {
        CacheGrant cachedGrant = new CacheGrant(this, this.appConfiguration);
        this.cacheService.put(cachedGrant.getExpiresIn(), cachedGrant.getAuthReqId(), (Object)cachedGrant);
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public boolean isTokensDelivered() {
        return this.tokensDelivered;
    }

    public void setTokensDelivered(boolean tokensDelivered) {
        this.tokensDelivered = tokensDelivered;
    }
}

