/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.common;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.metric.MetricType;
import org.gluu.oxauth.claims.Audience;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.common.AbstractAuthorizationGrant;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCode;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.CacheGrant;
import org.gluu.oxauth.model.common.ExecutionContext;
import org.gluu.oxauth.model.common.IAuthorizationGrant;
import org.gluu.oxauth.model.common.IdToken;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.ldap.TokenLdap;
import org.gluu.oxauth.model.ldap.TokenType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.HandleTokenFactory;
import org.gluu.oxauth.model.token.IdTokenFactory;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.token.JwtSigner;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.service.MetricService;
import org.gluu.oxauth.service.SectorIdentifierService;
import org.gluu.oxauth.service.external.ExternalIntrospectionService;
import org.gluu.oxauth.service.external.context.ExternalIntrospectionContext;
import org.gluu.oxauth.service.stat.StatService;
import org.gluu.oxauth.util.TokenHashUtil;
import org.gluu.service.CacheService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorizationGrant
extends AbstractAuthorizationGrant {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationGrant.class);
    @Inject
    private CacheService cacheService;
    @Inject
    private GrantService grantService;
    @Inject
    private IdTokenFactory idTokenFactory;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalIntrospectionService externalIntrospectionService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private SectorIdentifierService sectorIdentifierService;
    @Inject
    private MetricService metricService;
    @Inject
    private StatService statService;
    private boolean isCachedWithNoPersistence = false;

    public AuthorizationGrant() {
    }

    public AuthorizationGrant(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        super(user, authorizationGrantType, client, authenticationTime);
    }

    @Override
    public void init(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        super.init(user, authorizationGrantType, client, authenticationTime);
    }

    public IdToken createIdToken(IAuthorizationGrant grant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, String state, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        JsonWebResponse jwr = this.idTokenFactory.createJwr(grant, nonce, authorizationCode, accessToken, refreshToken, state, scopes, includeIdTokenClaims, preProcessing);
        return new IdToken(jwr.toString(), jwr.getClaims().getClaimAsDate("iat"), jwr.getClaims().getClaimAsDate("exp"));
    }

    @Override
    public String checkScopesPolicy(String scope) {
        String result = super.checkScopesPolicy(scope);
        this.save();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save() {
        if (this.isCachedWithNoPersistence) {
            if (this.getAuthorizationGrantType() == AuthorizationGrantType.AUTHORIZATION_CODE) {
                this.saveInCache();
                return;
            } else {
                if (this.getAuthorizationGrantType() != AuthorizationGrantType.CIBA) throw new UnsupportedOperationException("Grant caching is not supported for : " + (Object)((Object)this.getAuthorizationGrantType()));
                this.saveInCache();
            }
            return;
        } else {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getUseCacheForAllImplicitFlowObjects()) && this.isImplicitFlow()) {
                this.saveInCache();
                return;
            }
            this.saveImpl();
        }
    }

    private void saveInCache() {
        CacheGrant cachedGrant = new CacheGrant(this, this.appConfiguration);
        this.cacheService.put(cachedGrant.getExpiresIn(), cachedGrant.cacheKey(), (Object)cachedGrant);
    }

    public boolean isImplicitFlow() {
        return this.getAuthorizationGrantType() == null || this.getAuthorizationGrantType() == AuthorizationGrantType.IMPLICIT;
    }

    private void saveImpl() {
        List<TokenLdap> grants;
        String grantId = this.getGrantId();
        if (grantId != null && StringUtils.isNotBlank((String)grantId) && (grants = this.grantService.getGrantsByGrantId(grantId)) != null && !grants.isEmpty()) {
            for (TokenLdap t : grants) {
                this.initTokenFromGrant(t);
                log.debug("Saving grant: " + grantId + ", code_challenge: " + this.getCodeChallenge());
                this.grantService.mergeSilently(t);
            }
        }
    }

    private void initTokenFromGrant(TokenLdap token) {
        String nonce = this.getNonce();
        if (nonce != null) {
            token.setNonce(nonce);
        }
        token.setScope(this.getScopesAsString());
        token.setAuthMode(this.getAcrValues());
        token.setSessionDn(this.getSessionDn());
        token.setAuthenticationTime(this.getAuthenticationTime());
        token.setCodeChallenge(this.getCodeChallenge());
        token.setCodeChallengeMethod(this.getCodeChallengeMethod());
        token.setClaims(this.getClaims());
        JwtAuthorizationRequest jwtRequest = this.getJwtAuthorizationRequest();
        if (jwtRequest != null && StringUtils.isNotBlank((String)jwtRequest.getEncodedJwt())) {
            token.setJwtRequest(jwtRequest.getEncodedJwt());
        }
    }

    @Override
    public AccessToken createAccessToken(String certAsPem, ExecutionContext context) {
        try {
            AccessToken accessToken = super.createAccessToken(certAsPem, context);
            if (this.getClient().isAccessTokenAsJwt()) {
                accessToken.setCode(this.createAccessTokenAsJwt(accessToken, context));
            }
            if (accessToken.getExpiresIn() > 0) {
                this.persist(this.asToken(accessToken));
            }
            this.statService.reportAccessToken(this.getGrantType());
            this.metricService.incCounter(MetricType.OXAUTH_TOKEN_ACCESS_TOKEN_COUNT);
            return accessToken;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String createAccessTokenAsJwt(AccessToken accessToken, ExecutionContext context) throws Exception {
        User user = this.getUser();
        Client client = this.getClient();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getAccessTokenSigningAlg() != null && SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg()) != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAccessTokenSigningAlg());
        }
        JwtSigner jwtSigner = new JwtSigner(this.appConfiguration, this.webKeysConfiguration, signatureAlgorithm, client.getClientId(), this.clientService.decryptSecret(client.getClientSecret()));
        Jwt jwt = jwtSigner.newJwt();
        jwt.getClaims().setClaim("scope", (List)Lists.newArrayList(this.getScopes()));
        jwt.getClaims().setClaim("client_id", this.getClientId());
        jwt.getClaims().setClaim("username", user != null ? user.getAttribute("displayName") : null);
        jwt.getClaims().setClaim("token_type", accessToken.getTokenType().getName());
        jwt.getClaims().setClaim("code", accessToken.getCode());
        jwt.getClaims().setExpirationTime(accessToken.getExpirationDate());
        jwt.getClaims().setIssuedAt(accessToken.getCreationDate());
        jwt.getClaims().setSubjectIdentifier(this.getSub());
        jwt.getClaims().setClaim("x5t#S256", accessToken.getX5ts256());
        Audience.setAudience((JwtClaims)jwt.getClaims(), (Client)this.getClient());
        if (client.getAttributes().getRunIntrospectionScriptBeforeAccessTokenAsJwtCreationAndIncludeClaims().booleanValue()) {
            this.runIntrospectionScriptAndInjectValuesIntoJwt(jwt, context);
        }
        return jwtSigner.sign().toString();
    }

    private void runIntrospectionScriptAndInjectValuesIntoJwt(Jwt jwt, ExecutionContext executionContext) {
        JSONObject responseAsJsonObject = new JSONObject();
        ExternalIntrospectionContext context = new ExternalIntrospectionContext(this, executionContext.getHttpRequest(), executionContext.getHttpResponse(), this.appConfiguration, this.attributeService);
        context.setAccessTokenAsJwt(jwt);
        if (this.externalIntrospectionService.executeExternalModifyResponse(responseAsJsonObject, context)) {
            log.trace("Successfully run external introspection scripts.");
            if (context.isTranferIntrospectionPropertiesIntoJwtClaims()) {
                log.trace("Transfering claims into jwt ...");
                JwtUtil.transferIntoJwtClaims((JSONObject)responseAsJsonObject, (Jwt)jwt);
                log.trace("Transfered.");
            }
        }
    }

    @Override
    public RefreshToken createRefreshToken() {
        try {
            RefreshToken refreshToken = super.createRefreshToken();
            if (refreshToken.getExpiresIn() > 0) {
                this.persist(this.asToken(refreshToken));
            }
            this.statService.reportRefreshToken(this.getGrantType());
            this.metricService.incCounter(MetricType.OXAUTH_TOKEN_REFRESH_TOKEN_COUNT);
            return refreshToken;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public RefreshToken createRefreshToken(Date expirationDate) {
        try {
            RefreshToken refreshToken = new RefreshToken(HandleTokenFactory.generateHandleToken(), new Date(), expirationDate);
            refreshToken.setAuthMode(this.getAcrValues());
            refreshToken.setSessionDn(this.getSessionDn());
            if (refreshToken.getExpiresIn() > 0) {
                this.persist(this.asToken(refreshToken));
                this.statService.reportRefreshToken(this.getGrantType());
                this.metricService.incCounter(MetricType.OXAUTH_TOKEN_REFRESH_TOKEN_COUNT);
                return refreshToken;
            }
            log.debug("Token expiration date is in the past. Skip creation.");
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public IdToken createIdToken(String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, String state, AuthorizationGrant authorizationGrant, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) {
        try {
            IdToken idToken = this.createIdToken(this, nonce, authorizationCode, accessToken, refreshToken, state, this.getScopes(), includeIdTokenClaims, preProcessing);
            String acrValues = authorizationGrant.getAcrValues();
            String sessionDn = authorizationGrant.getSessionDn();
            if (idToken.getExpiresIn() > 0) {
                TokenLdap tokenLdap = this.asToken(idToken);
                tokenLdap.setAuthMode(acrValues);
                tokenLdap.setSessionDn(sessionDn);
                this.persist(tokenLdap);
            }
            this.setAcrValues(acrValues);
            this.setSessionDn(sessionDn);
            this.statService.reportIdToken(this.getGrantType());
            this.metricService.incCounter(MetricType.OXAUTH_TOKEN_ID_TOKEN_COUNT);
            return idToken;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void persist(TokenLdap p_token) {
        this.grantService.persist(p_token);
    }

    public void persist(AuthorizationCode p_code) {
        this.persist(this.asToken(p_code));
    }

    public TokenLdap asToken(IdToken p_token) {
        TokenLdap result = this.asTokenLdap(p_token);
        result.setTokenTypeEnum(TokenType.ID_TOKEN);
        return result;
    }

    public TokenLdap asToken(RefreshToken p_token) {
        TokenLdap result = this.asTokenLdap(p_token);
        result.setTokenTypeEnum(TokenType.REFRESH_TOKEN);
        return result;
    }

    public TokenLdap asToken(AuthorizationCode p_authorizationCode) {
        TokenLdap result = this.asTokenLdap(p_authorizationCode);
        result.setTokenTypeEnum(TokenType.AUTHORIZATION_CODE);
        return result;
    }

    public TokenLdap asToken(AccessToken p_accessToken) {
        TokenLdap result = this.asTokenLdap(p_accessToken);
        result.setTokenTypeEnum(TokenType.ACCESS_TOKEN);
        return result;
    }

    public String getScopesAsString() {
        StringBuilder scopes = new StringBuilder();
        for (String s : this.getScopes()) {
            scopes.append(s).append(" ");
        }
        return scopes.toString().trim();
    }

    public TokenLdap asTokenLdap(AbstractToken p_token) {
        AuthorizationCode authorizationCode;
        TokenLdap result = new TokenLdap();
        String hashedCode = TokenHashUtil.hash(p_token.getCode());
        result.setDn(this.grantService.buildDn(hashedCode));
        result.setGrantId(this.getGrantId());
        result.setCreationDate(p_token.getCreationDate());
        result.setExpirationDate(p_token.getExpirationDate());
        result.setTtl(p_token.getTtl());
        result.setTokenCode(hashedCode);
        result.setUserId(this.getUserId());
        result.setClientId(this.getClientId());
        result.getAttributes().setX5cs256(p_token.getX5ts256());
        AuthorizationGrantType grantType = this.getAuthorizationGrantType();
        if (grantType != null) {
            result.setGrantType(grantType.getParamName());
        }
        if ((authorizationCode = this.getAuthorizationCode()) != null) {
            result.setAuthorizationCode(TokenHashUtil.hash(authorizationCode.getCode()));
        }
        this.initTokenFromGrant(result);
        return result;
    }

    @Override
    public void revokeAllTokens() {
        TokenLdap tokenLdap = this.getTokenLdap();
        if (tokenLdap != null && StringUtils.isNotBlank((String)tokenLdap.getGrantId())) {
            this.grantService.removeAllByGrantId(tokenLdap.getGrantId());
        }
    }

    @Override
    public void checkExpiredTokens() {
    }

    @Override
    public String getSub() {
        return this.sectorIdentifierService.getSub(this);
    }

    public boolean isCachedWithNoPersistence() {
        return this.isCachedWithNoPersistence;
    }

    public void setIsCachedWithNoPersistence(boolean isCachedWithNoPersistence) {
        this.isCachedWithNoPersistence = isCachedWithNoPersistence;
    }
}

