/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ciba;

import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.util.Strings;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.SubjectType;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.signature.AsymmetricSignatureAlgorithm;
import org.gluu.oxauth.model.util.Util;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBARegisterParamsValidatorService {
    private static final Logger log = LoggerFactory.getLogger(CIBARegisterParamsValidatorService.class);
    @Inject
    private AppConfiguration appConfiguration;

    public boolean validateParams(BackchannelTokenDeliveryMode backchannelTokenDeliveryMode, String backchannelClientNotificationEndpoint, AsymmetricSignatureAlgorithm backchannelAuthenticationRequestSigningAlg, Boolean backchannelUserCodeParameter, List<GrantType> grantTypes, SubjectType subjectType, String sectorIdentifierUri, String jwks, String jwksUri) {
        try {
            if (backchannelTokenDeliveryMode == null && Strings.isBlank((String)backchannelClientNotificationEndpoint) && backchannelAuthenticationRequestSigningAlg == null) {
                return true;
            }
            if (backchannelTokenDeliveryMode == null || !this.appConfiguration.getBackchannelTokenDeliveryModesSupported().contains(backchannelTokenDeliveryMode.getValue())) {
                return false;
            }
            if ((backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PING || backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PUSH) && Strings.isBlank((String)backchannelClientNotificationEndpoint)) {
                return false;
            }
            if (!(backchannelTokenDeliveryMode != BackchannelTokenDeliveryMode.PING && backchannelTokenDeliveryMode != BackchannelTokenDeliveryMode.POLL || this.appConfiguration.getGrantTypesSupported().contains(GrantType.CIBA) && grantTypes.contains(GrantType.CIBA))) {
                return false;
            }
            if (this.appConfiguration.getBackchannelUserCodeParameterSupported() == null || !this.appConfiguration.getBackchannelUserCodeParameterSupported().booleanValue()) {
                backchannelUserCodeParameter = false;
            }
            if (subjectType != null && subjectType == SubjectType.PAIRWISE) {
                if ((backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PING || backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.POLL) && Strings.isBlank((String)jwks) && Strings.isBlank((String)jwksUri)) {
                    return false;
                }
                if (Strings.isNotBlank((String)sectorIdentifierUri)) {
                    ClientRequest clientRequest = new ClientRequest(sectorIdentifierUri);
                    clientRequest.setHttpMethod("GET");
                    ClientResponse clientResponse = clientRequest.get(String.class);
                    int status = clientResponse.getStatus();
                    if (status != 200) {
                        return false;
                    }
                    String entity = (String)clientResponse.getEntity(String.class);
                    JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                    if (backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PING || backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.POLL ? !Strings.isBlank((String)jwksUri) && !Util.asList((JSONArray)sectorIdentifierJsonArray).contains(jwksUri) : backchannelTokenDeliveryMode == BackchannelTokenDeliveryMode.PUSH && !Util.asList((JSONArray)sectorIdentifierJsonArray).contains(backchannelClientNotificationEndpoint)) {
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            log.trace(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

