/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ciba;

import javax.ejb.Stateless;
import javax.inject.Named;
import org.gluu.oxauth.client.BaseRequest;
import org.gluu.oxauth.client.ciba.push.PushErrorClient;
import org.gluu.oxauth.client.ciba.push.PushErrorRequest;
import org.gluu.oxauth.client.ciba.push.PushErrorResponse;
import org.gluu.oxauth.model.ciba.PushErrorResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBAPushErrorService {
    private static final Logger log = LoggerFactory.getLogger(CIBAPushErrorService.class);

    public void pushError(String authReqId, String clientNotificationEndpoint, String clientNotificationToken, PushErrorResponseType error, String errorDescription) {
        PushErrorRequest pushErrorRequest = new PushErrorRequest();
        pushErrorRequest.setClientNotificationToken(clientNotificationToken);
        pushErrorRequest.setAuthReqId(authReqId);
        pushErrorRequest.setErrorType(error);
        pushErrorRequest.setErrorDescription(errorDescription);
        PushErrorClient pushErrorClient = new PushErrorClient(clientNotificationEndpoint);
        pushErrorClient.setRequest((BaseRequest)pushErrorRequest);
        PushErrorResponse pushErrorResponse = pushErrorClient.exec();
        log.debug("CIBA: push error result status " + pushErrorResponse.getStatus());
    }
}

