/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ciba;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.BooleanUtils;
import org.apache.logging.log4j.util.Strings;
import org.gluu.oxauth.model.ciba.BackchannelAuthenticationErrorResponseType;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.DefaultErrorResponse;
import org.gluu.oxauth.model.error.IErrorType;

@Stateless
@Named
public class CIBAAuthorizeParamsValidatorService {
    @Inject
    private AppConfiguration appConfiguration;

    public DefaultErrorResponse validateParams(List<String> scopeList, String clientNotificationToken, BackchannelTokenDeliveryMode tokenDeliveryMode, String loginHintToken, String idTokenHint, String loginHint, String bindingMessage, Boolean backchannelUserCodeParameter, String userCodeParam, String userCode, Integer requestedExpirity) {
        DefaultErrorResponse errorResponse;
        Pattern pattern;
        if (tokenDeliveryMode == null) {
            DefaultErrorResponse errorResponse2 = new DefaultErrorResponse();
            errorResponse2.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            errorResponse2.setType((IErrorType)BackchannelAuthenticationErrorResponseType.UNAUTHORIZED_CLIENT);
            errorResponse2.setReason("Clients registering to use CIBA must indicate a token delivery mode.");
            return errorResponse2;
        }
        if (scopeList == null || !scopeList.contains("openid")) {
            DefaultErrorResponse errorResponse3 = new DefaultErrorResponse();
            errorResponse3.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            errorResponse3.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_SCOPE);
            errorResponse3.setReason("CIBA authentication requests must contain the openid scope value.");
            return errorResponse3;
        }
        if (!this.validateOneParamNotBlank(loginHintToken, idTokenHint, loginHint)) {
            DefaultErrorResponse errorResponse4 = new DefaultErrorResponse();
            errorResponse4.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            errorResponse4.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST);
            errorResponse4.setReason("It is required that the Client provides one (and only one) of the hints in the authentication request, that is login_hint_token, id_token_hint or login_hint.");
            return errorResponse4;
        }
        if ((tokenDeliveryMode == BackchannelTokenDeliveryMode.PING || tokenDeliveryMode == BackchannelTokenDeliveryMode.PUSH) && Strings.isBlank((String)clientNotificationToken)) {
            DefaultErrorResponse errorResponse5 = new DefaultErrorResponse();
            errorResponse5.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            errorResponse5.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST);
            errorResponse5.setReason("The client notification token is required if the Client is registered to use Ping or Push modes.");
            return errorResponse5;
        }
        if (Strings.isNotBlank((String)bindingMessage) && !(pattern = Pattern.compile(this.appConfiguration.getBackchannelBindingMessagePattern())).matcher(bindingMessage).matches()) {
            DefaultErrorResponse errorResponse6 = new DefaultErrorResponse();
            errorResponse6.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            errorResponse6.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_BINDING_MESSAGE);
            errorResponse6.setReason("The provided binding message is unacceptable. It must match the pattern: " + pattern.pattern());
            return errorResponse6;
        }
        if (BooleanUtils.isTrue((Boolean)backchannelUserCodeParameter)) {
            if (Strings.isBlank((String)userCodeParam)) {
                errorResponse = new DefaultErrorResponse();
                errorResponse.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                errorResponse.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_USER_CODE);
                errorResponse.setReason("The user code is required.");
                return errorResponse;
            }
            if (Strings.isBlank((String)userCode)) {
                errorResponse = new DefaultErrorResponse();
                errorResponse.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                errorResponse.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_USER_CODE);
                errorResponse.setReason("The user code is not set.");
                return errorResponse;
            }
            if (!userCode.equals(userCodeParam)) {
                errorResponse = new DefaultErrorResponse();
                errorResponse.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                errorResponse.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_USER_CODE);
                errorResponse.setReason("The user code is not valid.");
                return errorResponse;
            }
        }
        if (requestedExpirity != null && (requestedExpirity < 1 || requestedExpirity > this.appConfiguration.getCibaMaxExpirationTimeAllowedSec())) {
            errorResponse = new DefaultErrorResponse();
            errorResponse.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            errorResponse.setType((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST);
            errorResponse.setReason("Requested expirity is not allowed.");
            return errorResponse;
        }
        return null;
    }

    private boolean validateOneParamNotBlank(String ... params) {
        ArrayList<String> notBlankParams = new ArrayList<String>();
        for (String param : params) {
            if (!Strings.isNotBlank((String)param)) continue;
            notBlankParams.add(param);
        }
        return notBlankParams.size() == 1;
    }
}

