/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.authorize.ws.rs;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gluu.jsf2.service.FacesService;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.oxauth.authorize.ws.rs.ConsentGatheringSessionService;
import org.gluu.oxauth.i18n.LanguageBean;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.service.AuthorizeService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.oxauth.service.external.ExternalConsentGatheringService;
import org.gluu.oxauth.service.external.context.ConsentGatheringContext;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@RequestScoped
@Named(value="consentGatherer")
public class ConsentGathererService {
    @Inject
    private Logger log;
    @Inject
    private ExternalConsentGatheringService external;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private FacesService facesService;
    @Inject
    private LanguageBean languageBean;
    @Inject
    private ConsentGatheringSessionService sessionService;
    @Inject
    private UserService userService;
    @Inject
    private AuthorizeService authorizeService;
    @Inject
    private ClientService clientService;
    private final Map<String, String> pageAttributes = new HashMap<String, String>();
    private ConsentGatheringContext context;

    public boolean configure(String userDn, String clientId, String state) {
        HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
        HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
        SessionId session = this.sessionService.getConsentSession(httpRequest, httpResponse, userDn, true);
        CustomScriptConfiguration script = this.determineConsentScript(clientId);
        if (script == null) {
            this.log.error("Failed to determine consent-gathering script");
            return false;
        }
        this.sessionService.configure(session, script.getName(), clientId, state);
        this.context = new ConsentGatheringContext(script.getConfigurationAttributes(), httpRequest, httpResponse, session, this.pageAttributes, this.sessionService, this.userService, this.facesService, this.appConfiguration);
        this.log.debug("Configuring consent-gathering script '{}'", (Object)script.getName());
        int step = this.sessionService.getStep(session);
        String redirectTo = this.external.getPageForStep(script, step, this.context);
        if (StringHelper.isEmpty((String)redirectTo)) {
            this.log.error("Failed to determine page for consent-gathering script");
            return false;
        }
        this.context.persist();
        this.log.trace("Redirecting to page: '{}'", (Object)redirectTo);
        this.facesService.redirectWithExternal(redirectTo, null);
        return true;
    }

    private CustomScriptConfiguration determineConsentScript(String clientId) {
        if (this.appConfiguration.getConsentGatheringScriptBackwardCompatibility().booleanValue()) {
            return this.external.getDefaultExternalCustomScript();
        }
        List consentGatheringScripts = this.clientService.getClient(clientId).getAttributes().getConsentGatheringScripts();
        List scripts = this.external.getCustomScriptConfigurationsByDns(consentGatheringScripts);
        if (!scripts.isEmpty()) {
            CustomScriptConfiguration script = Collections.max(scripts, Comparator.comparingInt(CustomScriptConfiguration::getLevel));
            this.log.debug("Determined consent gathering script `%s`", (Object)script.getName());
            return script;
        }
        this.log.debug("There no consent gathering script configured for client `%s`. Therefore taking default consent script.", (Object)clientId);
        return this.external.getDefaultExternalCustomScript();
    }

    public boolean authorize() {
        try {
            int stepsCount;
            HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
            HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
            SessionId session = this.sessionService.getConsentSession(httpRequest, httpResponse, null, false);
            if (session == null) {
                this.log.error("Failed to restore claim-gathering session state");
                this.errorPage("consent.gather.invalid.session");
                return false;
            }
            CustomScriptConfiguration script = this.getScript(session);
            if (script == null) {
                this.log.error("Failed to find script '{}' in session:", (Object)this.sessionService.getScriptName(session));
                this.errorPage("consent.gather.failed");
                return false;
            }
            int step = this.sessionService.getStep(session);
            if (!this.sessionService.isPassedPreviousSteps(session, step)) {
                this.log.error("There are consent-gathering steps not marked as passed. scriptName: '{}', step: '{}'", (Object)script.getName(), (Object)step);
                this.errorPage("consent.gather.invalid.step");
                return false;
            }
            this.context = new ConsentGatheringContext(script.getConfigurationAttributes(), httpRequest, httpResponse, session, this.pageAttributes, this.sessionService, this.userService, this.facesService, this.appConfiguration);
            boolean authorizeResult = this.external.authorize(script, step, this.context);
            this.log.debug("Consent-gathering result for script '{}', step: '{}', gatheredResult: '{}'", new Object[]{script.getName(), step, authorizeResult});
            int overridenNextStep = this.external.getNextStep(script, step, this.context);
            if (!authorizeResult && overridenNextStep == -1) {
                SessionId connectSession = this.sessionService.getConnectSession(httpRequest);
                this.authorizeService.permissionDenied(connectSession);
                return false;
            }
            if (overridenNextStep != -1) {
                this.sessionService.resetToStep(session, overridenNextStep, step);
                step = overridenNextStep;
            }
            if (step < (stepsCount = this.external.getStepsCount(script, this.context)) || overridenNextStep != -1) {
                int nextStep;
                if (overridenNextStep != -1) {
                    nextStep = overridenNextStep;
                } else {
                    nextStep = step + 1;
                    this.sessionService.markStep(session, step, true);
                }
                this.sessionService.setStep(nextStep, session);
                String redirectTo = this.external.getPageForStep(script, nextStep, this.context);
                this.context.persist();
                this.log.trace("Redirecting to page: '{}'", (Object)redirectTo);
                this.facesService.redirectWithExternal(redirectTo, null);
                return true;
            }
            if (step == stepsCount) {
                this.context.persist();
                this.onSuccess(httpRequest, session, this.context);
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Exception during gather() method call.", (Throwable)e);
        }
        this.log.error("Failed to perform gather() method successfully.");
        this.errorPage("consent.gather.failed");
        return false;
    }

    private void onSuccess(HttpServletRequest httpRequest, SessionId session, ConsentGatheringContext context) {
        this.sessionService.setAuthenticatedSessionState(httpRequest, context.getHttpResponse(), session);
        SessionId connectSessionId = this.sessionService.getConnectSession(httpRequest);
        this.authorizeService.permissionGranted(httpRequest, connectSessionId);
    }

    public String prepareForStep() {
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
            HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
            SessionId session = this.sessionService.getConsentSession(httpRequest, httpResponse, null, false);
            if (session == null || session.getSessionAttributes().isEmpty()) {
                this.log.error("Failed to restore claim-gathering session state");
                return this.result("expired");
            }
            CustomScriptConfiguration script = this.getScript(session);
            if (script == null) {
                this.log.error("Failed to find script '{}' in session:", (Object)this.sessionService.getScriptName(session));
                return this.result("failure");
            }
            int step = this.sessionService.getStep(session);
            if (step < 1) {
                this.log.error("Invalid step: {}", (Object)step);
                return this.result("invalid_step");
            }
            if (!this.sessionService.isPassedPreviousSteps(session, step)) {
                this.log.error("There are consent-gathering steps not marked as passed. scriptName: '{}', step: '{}'", (Object)script.getName(), (Object)step);
                return this.result("failure");
            }
            this.context = new ConsentGatheringContext(script.getConfigurationAttributes(), httpRequest, httpResponse, session, this.pageAttributes, this.sessionService, this.userService, this.facesService, this.appConfiguration);
            boolean result = this.external.prepareForStep(script, step, this.context);
            this.log.debug("Consent-gathering prepare for step result for script '{}', step: '{}', gatheredResult: '{}'", new Object[]{script.getName(), step, result});
            if (result) {
                this.context.persist();
                return this.result("success");
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to prepareForStep()", (Throwable)ex);
        }
        return this.result("failure");
    }

    private void errorPage(String errorKey) {
        this.addMessage(FacesMessage.SEVERITY_ERROR, errorKey);
        this.facesService.redirect("/error.xhtml");
    }

    public String result(String resultCode) {
        if ("failure".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "consent.gather.failed");
        } else if ("invalid_step".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "consent.gather.invalid.step");
        } else if ("expired".equals(resultCode)) {
            this.addMessage(FacesMessage.SEVERITY_ERROR, "consent.gather.invalid.session");
        }
        return resultCode;
    }

    public void addMessage(FacesMessage.Severity severity, String summary) {
        String msg = this.languageBean.getMessage(summary);
        FacesMessage message = new FacesMessage(severity, msg, null);
        this.facesContext.addMessage(null, message);
    }

    public Map<String, String> getPageAttributes() {
        return this.pageAttributes;
    }

    protected CustomScriptConfiguration getScript(SessionId session) {
        String scriptName = this.sessionService.getScriptName(session);
        CustomScriptConfiguration script = this.external.getCustomScriptConfigurationByName(scriptName);
        return script;
    }

    public boolean isConsentGathered() {
        HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
        return this.sessionService.isSessionStateAuthenticated(httpRequest);
    }

    public ConsentGatheringContext getContext() {
        return this.context;
    }
}

