/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.authorize.ws.rs;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.authorize.ws.rs.AuthorizeRestWebService;
import org.gluu.oxauth.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import org.gluu.oxauth.ciba.CIBAPingCallbackService;
import org.gluu.oxauth.ciba.CIBAPushTokenDeliveryService;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.authorize.AuthorizeParamsValidator;
import org.gluu.oxauth.model.authorize.Claim;
import org.gluu.oxauth.model.authorize.IdTokenMember;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.authorize.ScopeChecker;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCode;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.CibaRequestCacheControl;
import org.gluu.oxauth.model.common.CibaRequestStatus;
import org.gluu.oxauth.model.common.DeviceAuthorizationCacheControl;
import org.gluu.oxauth.model.common.DeviceAuthorizationStatus;
import org.gluu.oxauth.model.common.DeviceCodeGrant;
import org.gluu.oxauth.model.common.ExecutionContext;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.IdToken;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.ResponseMode;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.binding.TokenBindingMessage;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.exception.AcrChangedException;
import org.gluu.oxauth.model.exception.InvalidSessionStateException;
import org.gluu.oxauth.model.ldap.ClientAuthorization;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.token.JwrService;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.AuthenticationFilterService;
import org.gluu.oxauth.service.ClientAuthorizationsService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.DeviceAuthorizationService;
import org.gluu.oxauth.service.RedirectUriResponse;
import org.gluu.oxauth.service.RequestParameterService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.ciba.CibaRequestService;
import org.gluu.oxauth.service.external.ExternalPostAuthnService;
import org.gluu.oxauth.service.external.context.ExternalPostAuthnContext;
import org.gluu.oxauth.service.external.session.SessionEvent;
import org.gluu.oxauth.service.external.session.SessionEventType;
import org.gluu.oxauth.util.QueryStringDecoder;
import org.gluu.oxauth.util.RedirectUri;
import org.gluu.oxauth.util.RedirectUtil;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/")
public class AuthorizeRestWebServiceImpl
implements AuthorizeRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private UserService userService;
    @Inject
    private Identity identity;
    @Inject
    private AuthenticationFilterService authenticationFilterService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    CookieService cookieService;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private ClientAuthorizationsService clientAuthorizationsService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ConfigurationFactory \u0441onfigurationFactory;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;
    @Inject
    private CIBAPushTokenDeliveryService cibaPushTokenDeliveryService;
    @Inject
    private CIBAPingCallbackService cibaPingCallbackService;
    @Inject
    private ExternalPostAuthnService externalPostAuthnService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;
    @Context
    private HttpServletRequest servletRequest;

    @Override
    public Response requestAuthorizationGet(String scope, String responseType, String clientId, String redirectUri, String state, String responseMode, String nonce, String display, String prompt, Integer maxAge, String uiLocales, String idTokenHint, String loginHint, String acrValues, String amrValues, String request, String requestUri, String requestSessionId, String sessionId, String originHeaders, String codeChallenge, String codeChallengeMethod, String customResponseHeaders, String claims, String authReqId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        return this.requestAuthorization(scope, responseType, clientId, redirectUri, state, responseMode, nonce, display, prompt, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, requestSessionId, sessionId, "GET", originHeaders, codeChallenge, codeChallengeMethod, customResponseHeaders, claims, authReqId, httpRequest, httpResponse, securityContext);
    }

    @Override
    public Response requestAuthorizationPost(String scope, String responseType, String clientId, String redirectUri, String state, String responseMode, String nonce, String display, String prompt, Integer maxAge, String uiLocales, String idTokenHint, String loginHint, String acrValues, String amrValues, String request, String requestUri, String requestSessionId, String sessionId, String originHeaders, String codeChallenge, String codeChallengeMethod, String customResponseHeaders, String claims, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        return this.requestAuthorization(scope, responseType, clientId, redirectUri, state, responseMode, nonce, display, prompt, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, requestSessionId, sessionId, "POST", originHeaders, codeChallenge, codeChallengeMethod, customResponseHeaders, claims, null, httpRequest, httpResponse, securityContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response requestAuthorization(String scope, String responseType, String clientId, String redirectUri, String state, String respMode, String nonce, String display, String prompt, Integer maxAge, String uiLocalesStr, String idTokenHint, String loginHint, String acrValuesStr, String amrValuesStr, String request, String requestUri, String requestSessionId, String sessionId, String method, String originHeaders, String codeChallenge, String codeChallengeMethod, String customRespHeaders, String claims, String authReqId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        scope = ServerUtil.urlDecode(scope);
        String tokenBindingHeader = httpRequest.getHeader("Sec-Token-Binding");
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.USER_AUTHORIZATION);
        oAuth2AuditLog.setClientId(clientId);
        oAuth2AuditLog.setScope(scope);
        this.log.debug("Attempting to request authorization: responseType = {}, clientId = {}, scope = {}, redirectUri = {}, nonce = {}, state = {}, request = {}, isSecure = {}, requestSessionId = {}, sessionId = {}", new Object[]{responseType, clientId, scope, redirectUri, nonce, state, request, securityContext.isSecure(), requestSessionId, sessionId});
        this.log.debug("Attempting to request authorization: acrValues = {}, amrValues = {}, originHeaders = {}, codeChallenge = {}, codeChallengeMethod = {}, customRespHeaders = {}, claims = {}, tokenBindingHeader = {}", new Object[]{acrValuesStr, amrValuesStr, originHeaders, codeChallenge, codeChallengeMethod, customRespHeaders, claims, tokenBindingHeader});
        Response.ResponseBuilder builder = Response.ok();
        List uiLocales = Util.splittedStringAsList((String)uiLocalesStr, (String)" ");
        List responseTypes = ResponseType.fromString((String)responseType, (String)" ");
        List prompts = Prompt.fromString((String)prompt, (String)" ");
        List acrValues = Util.splittedStringAsList((String)acrValuesStr, (String)" ");
        List amrValues = Util.splittedStringAsList((String)amrValuesStr, (String)" ");
        ResponseMode responseMode = ResponseMode.getByValue((String)respMode);
        Map<String, String> customParameters = this.requestParameterService.getCustomParameters(QueryStringDecoder.decode(httpRequest.getQueryString()));
        SessionId sessionUser = this.identity.getSessionId();
        User user = this.sessionIdService.getUser(sessionUser);
        try {
            boolean validAuthenticationMaxAge;
            boolean isResponseTypeValid;
            Map customResponseHeaders = Util.jsonObjectArrayStringAsMap((String)customRespHeaders);
            this.updateSessionForROPC(httpRequest, sessionUser);
            Client client = this.authorizeRestWebServiceValidator.validateClient(clientId, state);
            String deviceAuthzUserCode = this.deviceAuthorizationService.getUserCodeFromSession(httpRequest);
            redirectUri = this.authorizeRestWebServiceValidator.validateRedirectUri(client, redirectUri, state, deviceAuthzUserCode, httpRequest);
            this.checkAcrChanged(acrValuesStr, prompts, sessionUser);
            RedirectUriResponse redirectUriResponse = new RedirectUriResponse(new RedirectUri(redirectUri, responseTypes, responseMode), state, httpRequest, this.errorResponseFactory);
            redirectUriResponse.setFapiCompatible(this.appConfiguration.getFapiCompatibility());
            Set<String> scopes = this.scopeChecker.checkScopesPolicy(client, scope);
            JwtAuthorizationRequest jwtRequest = null;
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)request) || org.apache.commons.lang.StringUtils.isNotBlank((String)requestUri)) {
                try {
                    IdTokenMember idTokenMember;
                    jwtRequest = JwtAuthorizationRequest.createJwtRequest(request, requestUri, client, redirectUriResponse, this.cryptoProvider, this.appConfiguration);
                    if (jwtRequest == null) {
                        throw this.createInvalidJwtRequestException(redirectUriResponse, "Failed to parse jwt.");
                    }
                    if (org.apache.commons.lang.StringUtils.isNotBlank((String)jwtRequest.getState())) {
                        state = jwtRequest.getState();
                        redirectUriResponse.setState(state);
                    }
                    if (this.appConfiguration.getFapiCompatibility().booleanValue() && org.apache.commons.lang.StringUtils.isBlank((String)jwtRequest.getState())) {
                        state = "";
                        redirectUriResponse.setState("");
                    }
                    this.authorizeRestWebServiceValidator.validateRequestObject(jwtRequest, redirectUriResponse);
                    if (!jwtRequest.getResponseTypes().containsAll(responseTypes) || !responseTypes.containsAll(jwtRequest.getResponseTypes())) {
                        throw this.createInvalidJwtRequestException(redirectUriResponse, "The responseType parameter is not the same in the JWT");
                    }
                    if (org.apache.commons.lang.StringUtils.isBlank((String)jwtRequest.getClientId()) || !jwtRequest.getClientId().equals(clientId)) {
                        throw this.createInvalidJwtRequestException(redirectUriResponse, "The clientId parameter is not the same in the JWT");
                    }
                    if (!jwtRequest.getScopes().isEmpty()) {
                        if (!scopes.contains("openid")) {
                            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_SCOPE, state, "scope parameter does not contain openid value which is required.")).build());
                        }
                        scopes = this.scopeChecker.checkScopesPolicy(client, Lists.newArrayList(jwtRequest.getScopes()));
                    }
                    if (jwtRequest.getRedirectUri() != null && !jwtRequest.getRedirectUri().equals(redirectUri)) {
                        throw this.createInvalidJwtRequestException(redirectUriResponse, "The redirect_uri parameter is not the same in the JWT");
                    }
                    if (org.apache.commons.lang.StringUtils.isNotBlank((String)jwtRequest.getNonce())) {
                        nonce = jwtRequest.getNonce();
                    }
                    if (jwtRequest.getDisplay() != null && org.apache.commons.lang.StringUtils.isNotBlank((String)jwtRequest.getDisplay().getParamName())) {
                        display = jwtRequest.getDisplay().getParamName();
                    }
                    if (!jwtRequest.getPrompts().isEmpty()) {
                        prompts = Lists.newArrayList(jwtRequest.getPrompts());
                    }
                    if ((idTokenMember = jwtRequest.getIdTokenMember()) != null) {
                        Claim userIdClaim;
                        Claim acrClaim;
                        if (idTokenMember.getMaxAge() != null) {
                            maxAge = idTokenMember.getMaxAge();
                        }
                        if ((acrClaim = idTokenMember.getClaim("acr")) != null && acrClaim.getClaimValue() != null) {
                            acrValuesStr = acrClaim.getClaimValue().getValueAsString();
                            acrValues = Util.splittedStringAsList((String)acrValuesStr, (String)" ");
                        }
                        if ((userIdClaim = idTokenMember.getClaim("sub")) != null && userIdClaim.getClaimValue() != null && userIdClaim.getClaimValue().getValue() != null) {
                            String userId;
                            String userIdClaimValue = userIdClaim.getClaimValue().getValue();
                            if (user != null && !(userId = user.getUserId()).equalsIgnoreCase(userIdClaimValue)) {
                                builder = redirectUriResponse.createErrorBuilder((IErrorType)AuthorizeErrorResponseType.USER_MISMATCHED);
                                this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                                return builder.build();
                            }
                        }
                    }
                    this.requestParameterService.getCustomParameters(jwtRequest, customParameters);
                }
                catch (WebApplicationException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.log.error("Invalid JWT authorization request. Message : " + e.getMessage(), (Throwable)e);
                    throw this.createInvalidJwtRequestException(redirectUriResponse, "Invalid JWT authorization request");
                }
            }
            if (!this.cibaRequestService.hasCibaCompatibility(client)) {
                if (this.appConfiguration.getFapiCompatibility().booleanValue() && jwtRequest == null) {
                    throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST);
                }
                this.authorizeRestWebServiceValidator.validateRequestJwt(request, requestUri, redirectUriResponse);
            }
            this.authorizeRestWebServiceValidator.validate(responseTypes, prompts, nonce, state, redirectUri, httpRequest, client, responseMode);
            if (CollectionUtils.isEmpty((Collection)acrValues) && !ArrayUtils.isEmpty((Object[])client.getDefaultAcrValues())) {
                acrValues = Lists.newArrayList((Object[])client.getDefaultAcrValues());
            }
            if (scopes.contains("offline_access") && !client.getTrustedClient()) {
                if (!responseTypes.contains(ResponseType.CODE)) {
                    this.log.trace("Removed (ignored) offline_scope. Can't find `code` in response_type which is required.");
                    scopes.remove("offline_access");
                }
                if (scopes.contains("offline_access") && !prompts.contains(Prompt.CONSENT)) {
                    this.log.error("Removed offline_access. Can't find prompt=consent. Consent is required for offline_access.");
                    scopes.remove("offline_access");
                }
            }
            boolean bl = isResponseTypeValid = AuthorizeParamsValidator.validateResponseTypes(responseTypes, client) && AuthorizeParamsValidator.validateGrantType(responseTypes, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported());
            if (!isResponseTypeValid) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNSUPPORTED_RESPONSE_TYPE, state, "")).build());
            }
            AuthorizationGrant authorizationGrant = null;
            if (user == null) {
                this.identity.logout();
                if (prompts.contains(Prompt.NONE)) {
                    if (!this.authenticationFilterService.isEnabled()) {
                        builder = redirectUriResponse.createErrorBuilder((IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED);
                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                        return builder.build();
                    }
                    Map<String, String> params = method.equals("GET") ? QueryStringDecoder.decode(httpRequest.getQueryString()) : this.getGenericRequestMap(httpRequest);
                    String userDn = this.authenticationFilterService.processAuthenticationFilters(params);
                    if (userDn == null) {
                        builder = redirectUriResponse.createErrorBuilder((IErrorType)AuthorizeErrorResponseType.LOGIN_REQUIRED);
                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                        return builder.build();
                    }
                    Map<String, String> genericRequestMap = this.getGenericRequestMap(httpRequest);
                    HashMap parameterMap = Maps.newHashMap(genericRequestMap);
                    Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
                    sessionUser = this.sessionIdService.generateAuthenticatedSessionId(httpRequest, userDn, prompt);
                    sessionUser.setSessionAttributes(requestParameterMap);
                    this.cookieService.createSessionIdCookie(sessionUser, httpRequest, httpResponse, false);
                    this.sessionIdService.updateSessionId(sessionUser);
                    user = this.userService.getUserByDn(sessionUser.getUserDn(), new String[0]);
                } else {
                    if (prompts.contains(Prompt.LOGIN)) {
                        this.unauthenticateSession(sessionId, httpRequest);
                        sessionId = null;
                        prompts.remove(Prompt.LOGIN);
                    }
                    return this.redirectToAuthorizationPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
                }
            }
            if (!(validAuthenticationMaxAge = this.authorizeRestWebServiceValidator.validateAuthnMaxAge(maxAge, sessionUser, client))) {
                this.unauthenticateSession(sessionId, httpRequest);
                sessionId = null;
                return this.redirectToAuthorizationPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
            }
            oAuth2AuditLog.setUsername(user.getUserId());
            ExternalPostAuthnContext postAuthnContext = new ExternalPostAuthnContext(client, sessionUser, httpRequest, httpResponse);
            boolean forceReAuthentication = this.externalPostAuthnService.externalForceReAuthentication(client, postAuthnContext);
            if (forceReAuthentication) {
                this.unauthenticateSession(sessionId, httpRequest);
                sessionId = null;
                return this.redirectToAuthorizationPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
            }
            boolean forceAuthorization = this.externalPostAuthnService.externalForceAuthorization(client, postAuthnContext);
            if (forceAuthorization) {
                return this.redirectToAuthorizationPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
            }
            ClientAuthorization clientAuthorization = null;
            boolean clientAuthorizationFetched = false;
            if (scopes.size() > 0) {
                if (prompts.contains(Prompt.CONSENT)) {
                    return this.redirectToAuthorizationPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
                }
                if (client.getTrustedClient()) {
                    sessionUser.addPermission(clientId, true);
                    this.sessionIdService.updateSessionId(sessionUser);
                } else {
                    clientAuthorization = this.clientAuthorizationsService.find(user.getAttribute("inum"), client.getClientId());
                    clientAuthorizationFetched = true;
                    if (clientAuthorization != null && clientAuthorization.getScopes() != null) {
                        this.log.trace("ClientAuthorization - scope: " + scope + ", dn: " + clientAuthorization.getDn() + ", requestedScope: " + scopes);
                        if (!Arrays.asList(clientAuthorization.getScopes()).containsAll(scopes)) {
                            return this.redirectToAuthorizationPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
                        }
                        sessionUser.addPermission(clientId, true);
                        this.sessionIdService.updateSessionId(sessionUser);
                    }
                }
            }
            if (prompts.contains(Prompt.LOGIN)) {
                if (this.identity.getSessionId().getState() == SessionIdState.AUTHENTICATED) {
                    this.unauthenticateSession(sessionId, httpRequest);
                }
                sessionId = null;
                prompts.remove(Prompt.LOGIN);
                return this.redirectToAuthorizationPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
            }
            if (prompts.contains(Prompt.CONSENT) || !sessionUser.isPermissionGrantedForClient(clientId).booleanValue()) {
                if (!clientAuthorizationFetched) {
                    clientAuthorization = this.clientAuthorizationsService.find(user.getAttribute("inum"), client.getClientId());
                }
                this.clientAuthorizationsService.clearAuthorizations(clientAuthorization, client.getPersistClientAuthorizations());
                prompts.remove(Prompt.CONSENT);
                return this.redirectToAuthorizationPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
            }
            if (prompts.contains(Prompt.SELECT_ACCOUNT)) {
                return this.redirectToSelectAccountPage(redirectUriResponse.getRedirectUri(), responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
            }
            AuthorizationCode authorizationCode = null;
            if (responseTypes.contains(ResponseType.CODE)) {
                authorizationGrant = this.authorizationGrantList.createAuthorizationCodeGrant(user, client, sessionUser.getAuthenticationTime());
                authorizationGrant.setNonce(nonce);
                authorizationGrant.setJwtAuthorizationRequest(jwtRequest);
                authorizationGrant.setTokenBindingHash(TokenBindingMessage.getTokenBindingIdHashFromTokenBindingMessage((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf()));
                authorizationGrant.setScopes(scopes);
                authorizationGrant.setCodeChallenge(codeChallenge);
                authorizationGrant.setCodeChallengeMethod(codeChallengeMethod);
                authorizationGrant.setClaims(claims);
                authorizationGrant.setAcrValues(this.getAcrForGrant(acrValuesStr, sessionUser));
                authorizationGrant.setSessionDn(sessionUser.getDn());
                authorizationGrant.save();
                authorizationCode = authorizationGrant.getAuthorizationCode();
                redirectUriResponse.getRedirectUri().addResponseParameter("code", authorizationCode.getCode());
            }
            AccessToken newAccessToken = null;
            if (responseTypes.contains(ResponseType.TOKEN)) {
                if (authorizationGrant == null) {
                    authorizationGrant = this.authorizationGrantList.createImplicitGrant(user, client, sessionUser.getAuthenticationTime());
                    authorizationGrant.setNonce(nonce);
                    authorizationGrant.setJwtAuthorizationRequest(jwtRequest);
                    authorizationGrant.setScopes(scopes);
                    authorizationGrant.setClaims(claims);
                    authorizationGrant.setAcrValues(this.getAcrForGrant(acrValuesStr, sessionUser));
                    authorizationGrant.setSessionDn(sessionUser.getDn());
                    authorizationGrant.save();
                }
                newAccessToken = authorizationGrant.createAccessToken(httpRequest.getHeader("X-ClientCert"), new ExecutionContext(httpRequest, httpResponse));
                redirectUriResponse.getRedirectUri().addResponseParameter("access_token", newAccessToken.getCode());
                redirectUriResponse.getRedirectUri().addResponseParameter("token_type", newAccessToken.getTokenType().toString());
                redirectUriResponse.getRedirectUri().addResponseParameter("expires_in", newAccessToken.getExpiresIn() + "");
            }
            if (responseTypes.contains(ResponseType.ID_TOKEN)) {
                boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                if (authorizationGrant == null) {
                    includeIdTokenClaims = true;
                    authorizationGrant = this.authorizationGrantList.createImplicitGrant(user, client, sessionUser.getAuthenticationTime());
                    authorizationGrant.setNonce(nonce);
                    authorizationGrant.setJwtAuthorizationRequest(jwtRequest);
                    authorizationGrant.setScopes(scopes);
                    authorizationGrant.setClaims(claims);
                    authorizationGrant.setAcrValues(this.getAcrForGrant(acrValuesStr, sessionUser));
                    authorizationGrant.setSessionDn(sessionUser.getDn());
                    authorizationGrant.save();
                }
                IdToken idToken = authorizationGrant.createIdToken(nonce, authorizationCode, newAccessToken, null, state, authorizationGrant, includeIdTokenClaims, JwrService.wrapWithSidFunction((Function<JsonWebResponse, Void>)TokenBindingMessage.createIdTokenTokingBindingPreprocessing((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf()), sessionUser.getOutsideSid()));
                redirectUriResponse.getRedirectUri().addResponseParameter("id_token", idToken.getCode());
            }
            if (authorizationGrant != null && StringHelper.isNotEmpty((String)acrValuesStr) && !this.appConfiguration.getFapiCompatibility().booleanValue()) {
                redirectUriResponse.getRedirectUri().addResponseParameter("acr_values", acrValuesStr);
            }
            if (sessionUser.getId() == null) {
                SessionId newSessionUser = this.sessionIdService.generateAuthenticatedSessionId(httpRequest, sessionUser.getUserDn(), prompt);
                String newSessionId = newSessionUser.getId();
                sessionUser.setId(newSessionId);
                this.log.trace("newSessionId = {}", (Object)newSessionId);
            }
            if (!this.appConfiguration.getFapiCompatibility().booleanValue()) {
                redirectUriResponse.getRedirectUri().addResponseParameter("session_id", sessionUser.getId());
            }
            redirectUriResponse.getRedirectUri().addResponseParameter("sid", sessionUser.getOutsideSid());
            redirectUriResponse.getRedirectUri().addResponseParameter("session_state", this.sessionIdService.computeSessionState(sessionUser, clientId, redirectUri));
            redirectUriResponse.getRedirectUri().addResponseParameter("state", state);
            if (scope != null && !scope.isEmpty() && authorizationGrant != null && !this.appConfiguration.getFapiCompatibility().booleanValue()) {
                scope = authorizationGrant.checkScopesPolicy(scope);
                redirectUriResponse.getRedirectUri().addResponseParameter("scope", scope);
            }
            this.clientService.updateAccessTime(client, false);
            oAuth2AuditLog.setSuccess(true);
            builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse.getRedirectUri(), httpRequest);
            if (this.appConfiguration.getCustomHeadersWithAuthorizationResponse().booleanValue()) {
                for (String key : customResponseHeaders.keySet()) {
                    builder.header(key, customResponseHeaders.get(key));
                }
            }
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)authReqId)) {
                this.runCiba(authReqId, httpRequest, httpResponse);
            }
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)deviceAuthzUserCode)) {
                this.processDeviceAuthorization(deviceAuthzUserCode, user);
            }
        }
        catch (WebApplicationException e) {
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (AcrChangedException e) {
            this.log.error("ACR is changed, please provide a supported and enabled acr value");
            this.log.error(e.getMessage(), (Throwable)e);
            RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
            redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.SESSION_SELECTION_REQUIRED, state));
            redirectUriResponse.addResponseParameter("hint", "Use prompt=login in order to alter existing session.");
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            return RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest).build();
        }
        catch (EntryPersistenceException e) {
            builder = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "")).type(MediaType.APPLICATION_JSON_TYPE);
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidSessionStateException ex) {
            throw ex;
        }
        catch (Exception e) {
            builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private String getAcrForGrant(String acrValuesStr, SessionId sessionUser) {
        String acr = this.sessionIdService.getAcr(sessionUser);
        return org.apache.commons.lang.StringUtils.isNotBlank((String)acr) ? acr : acrValuesStr;
    }

    private void runCiba(String authReqId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        CibaRequestCacheControl cibaRequest = this.cibaRequestService.getCibaRequest(authReqId);
        if (cibaRequest == null || cibaRequest.getStatus() == CibaRequestStatus.EXPIRED) {
            this.log.trace("User responded too late and the grant {} has expired, {}", (Object)authReqId, (Object)cibaRequest);
            return;
        }
        this.cibaRequestService.removeCibaRequest(authReqId);
        CIBAGrant cibaGrant = this.authorizationGrantList.createCIBAGrant(cibaRequest);
        RefreshToken refreshToken = cibaGrant.createRefreshToken();
        this.log.debug("Issuing refresh token: {}", (Object)refreshToken.getCode());
        AccessToken accessToken = cibaGrant.createAccessToken(httpRequest.getHeader("X-ClientCert"), new ExecutionContext(httpRequest, httpResponse));
        this.log.debug("Issuing access token: {}", (Object)accessToken.getCode());
        IdToken idToken = cibaGrant.createIdToken(null, null, accessToken, refreshToken, null, cibaGrant, false, null);
        cibaGrant.setTokensDelivered(true);
        cibaGrant.save();
        if (cibaRequest.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH) {
            this.cibaPushTokenDeliveryService.pushTokenDelivery(cibaGrant.getAuthReqId(), cibaGrant.getClient().getBackchannelClientNotificationEndpoint(), cibaRequest.getClientNotificationToken(), accessToken.getCode(), refreshToken.getCode(), idToken.getCode(), accessToken.getExpiresIn());
        } else if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PING) {
            cibaGrant.setTokensDelivered(false);
            cibaGrant.save();
            this.cibaPingCallbackService.pingCallback(cibaGrant.getAuthReqId(), cibaGrant.getClient().getBackchannelClientNotificationEndpoint(), cibaRequest.getClientNotificationToken());
        } else if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.POLL) {
            cibaGrant.setTokensDelivered(false);
            cibaGrant.save();
        }
    }

    private WebApplicationException createInvalidJwtRequestException(RedirectUriResponse redirectUriResponse, String reason) {
        if (this.appConfiguration.getFapiCompatibility().booleanValue()) {
            this.log.debug(reason);
            return redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        return redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT, reason);
    }

    private void updateSessionForROPC(HttpServletRequest httpRequest, SessionId sessionUser) {
        if (sessionUser == null) {
            return;
        }
        Map<String, String> sessionAttributes = sessionUser.getSessionAttributes();
        String authorizedGrant = sessionUser.getSessionAttributes().get("authorized_grant");
        if (StringHelper.isNotEmpty((String)authorizedGrant) && GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS == GrantType.fromString((String)authorizedGrant)) {
            sessionAttributes.remove("authorized_grant");
            Map<String, String> parameterMap = this.getGenericRequestMap(httpRequest);
            Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
            sessionAttributes.putAll(requestParameterMap);
            this.sessionIdService.updateSessionId(sessionUser, true, true, true);
        }
    }

    private void checkAcrChanged(String acrValuesStr, List<Prompt> prompts, SessionId sessionUser) throws AcrChangedException {
        try {
            this.sessionIdService.assertAuthenticatedSessionCorrespondsToNewRequest(sessionUser, acrValuesStr);
        }
        catch (AcrChangedException e) {
            if (e.isForceReAuthentication()) {
                if (!prompts.contains(Prompt.LOGIN)) {
                    this.log.info("ACR is changed, adding prompt=login to prompts");
                    prompts.add(Prompt.LOGIN);
                    sessionUser.setState(SessionIdState.UNAUTHENTICATED);
                    sessionUser.getSessionAttributes().put("prompt", StringUtils.implode(prompts, (String)" "));
                    this.sessionIdService.persistSessionId(sessionUser);
                    this.sessionIdService.externalEvent(new SessionEvent(SessionEventType.UNAUTHENTICATED, sessionUser));
                }
            }
            throw e;
        }
    }

    private Map<String, String> getGenericRequestMap(HttpServletRequest httpRequest) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : httpRequest.getParameterMap().entrySet()) {
            result.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return result;
    }

    private Response redirectToAuthorizationPage(RedirectUri redirectUriResponse, List<ResponseType> responseTypes, String scope, String clientId, String redirectUri, String state, ResponseMode responseMode, String nonce, String display, List<Prompt> prompts, Integer maxAge, List<String> uiLocales, String idTokenHint, String loginHint, List<String> acrValues, List<String> amrValues, String request, String requestUri, String originHeaders, String codeChallenge, String codeChallengeMethod, String sessionId, String claims, String authReqId, Map<String, String> customParameters, OAuth2AuditLog oAuth2AuditLog, HttpServletRequest httpRequest) {
        return this.redirectTo("/authorize", redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
    }

    private Response redirectToSelectAccountPage(RedirectUri redirectUriResponse, List<ResponseType> responseTypes, String scope, String clientId, String redirectUri, String state, ResponseMode responseMode, String nonce, String display, List<Prompt> prompts, Integer maxAge, List<String> uiLocales, String idTokenHint, String loginHint, List<String> acrValues, List<String> amrValues, String request, String requestUri, String originHeaders, String codeChallenge, String codeChallengeMethod, String sessionId, String claims, String authReqId, Map<String, String> customParameters, OAuth2AuditLog oAuth2AuditLog, HttpServletRequest httpRequest) {
        return this.redirectTo("/selectAccount", redirectUriResponse, responseTypes, scope, clientId, redirectUri, state, responseMode, nonce, display, prompts, maxAge, uiLocales, idTokenHint, loginHint, acrValues, amrValues, request, requestUri, originHeaders, codeChallenge, codeChallengeMethod, sessionId, claims, authReqId, customParameters, oAuth2AuditLog, httpRequest);
    }

    private Response redirectTo(String pathToRedirect, RedirectUri redirectUriResponse, List<ResponseType> responseTypes, String scope, String clientId, String redirectUri, String state, ResponseMode responseMode, String nonce, String display, List<Prompt> prompts, Integer maxAge, List<String> uiLocales, String idTokenHint, String loginHint, List<String> acrValues, List<String> amrValues, String request, String requestUri, String originHeaders, String codeChallenge, String codeChallengeMethod, String sessionId, String claims, String authReqId, Map<String, String> customParameters, OAuth2AuditLog oAuth2AuditLog, HttpServletRequest httpRequest) {
        String amrValuesStr;
        String acrValuesStr;
        String uiLocalesStr;
        String prompt;
        URI contextUri = URI.create(this.appConfiguration.getIssuer()).resolve(this.servletRequest.getContextPath() + pathToRedirect + this.\u0441onfigurationFactory.getFacesMapping());
        redirectUriResponse.setBaseRedirectUri(contextUri.toString());
        redirectUriResponse.setResponseMode(ResponseMode.QUERY);
        String responseType = StringUtils.implode(responseTypes, (String)" ");
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)responseType)) {
            redirectUriResponse.addResponseParameter("response_type", responseType);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)scope)) {
            redirectUriResponse.addResponseParameter("scope", scope);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)clientId)) {
            redirectUriResponse.addResponseParameter("client_id", clientId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)redirectUri)) {
            redirectUriResponse.addResponseParameter("redirect_uri", redirectUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)state)) {
            redirectUriResponse.addResponseParameter("state", state);
        }
        if (responseMode != null) {
            redirectUriResponse.addResponseParameter("response_mode", responseMode.getParamName());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)nonce)) {
            redirectUriResponse.addResponseParameter("nonce", nonce);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)display)) {
            redirectUriResponse.addResponseParameter("display", display);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(prompt = StringUtils.implode(prompts, (String)" ")))) {
            redirectUriResponse.addResponseParameter("prompt", prompt);
        }
        if (maxAge != null) {
            redirectUriResponse.addResponseParameter("max_age", maxAge.toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(uiLocalesStr = StringUtils.implode(uiLocales, (String)" ")))) {
            redirectUriResponse.addResponseParameter("ui_locales", uiLocalesStr);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)idTokenHint)) {
            redirectUriResponse.addResponseParameter("id_token_hint", idTokenHint);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)loginHint)) {
            redirectUriResponse.addResponseParameter("login_hint", loginHint);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(acrValuesStr = StringUtils.implode(acrValues, (String)" ")))) {
            redirectUriResponse.addResponseParameter("acr_values", acrValuesStr);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(amrValuesStr = StringUtils.implode(amrValues, (String)" ")))) {
            redirectUriResponse.addResponseParameter("amr_values", amrValuesStr);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)request)) {
            redirectUriResponse.addResponseParameter("request", request);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)requestUri)) {
            redirectUriResponse.addResponseParameter("request_uri", requestUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)codeChallenge)) {
            redirectUriResponse.addResponseParameter("code_challenge", codeChallenge);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)codeChallengeMethod)) {
            redirectUriResponse.addResponseParameter("code_challenge_method", codeChallengeMethod);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)sessionId) && this.appConfiguration.getSessionIdRequestParameterEnabled().booleanValue()) {
            redirectUriResponse.addResponseParameter("session_id", sessionId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)claims)) {
            redirectUriResponse.addResponseParameter("claims", claims);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)authReqId)) {
            redirectUriResponse.addResponseParameter("auth_req_id", authReqId);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)originHeaders)) {
            redirectUriResponse.addResponseParameter("origin_headers", originHeaders);
        }
        if (customParameters != null && customParameters.size() > 0) {
            for (Map.Entry<String, String> entry : customParameters.entrySet()) {
                redirectUriResponse.addResponseParameter(entry.getKey(), entry.getValue());
            }
        }
        Response.ResponseBuilder builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, httpRequest);
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private void unauthenticateSession(String sessionId, HttpServletRequest httpRequest) {
        SessionId persistenceSessionId;
        this.identity.logout();
        SessionId sessionUser = this.identity.getSessionId();
        if (sessionUser != null) {
            sessionUser.setUserDn(null);
            sessionUser.setUser(null);
            sessionUser.setAuthenticationTime(null);
        }
        if (StringHelper.isEmpty((String)sessionId)) {
            sessionId = this.cookieService.getSessionIdFromCookie(httpRequest);
        }
        if ((persistenceSessionId = this.sessionIdService.getSessionId(sessionId)) == null) {
            this.log.error("Failed to load session from LDAP by session_id: '{}'", (Object)sessionId);
            return;
        }
        persistenceSessionId.setState(SessionIdState.UNAUTHENTICATED);
        persistenceSessionId.setUserDn(null);
        persistenceSessionId.setUser(null);
        persistenceSessionId.setAuthenticationTime(null);
        boolean result = this.sessionIdService.updateSessionId(persistenceSessionId);
        this.sessionIdService.externalEvent(new SessionEvent(SessionEventType.UNAUTHENTICATED, persistenceSessionId).setHttpRequest(httpRequest));
        if (!result) {
            this.log.error("Failed to update session_id '{}'", (Object)sessionId);
        }
    }

    private void processDeviceAuthorization(String userCode, User user) {
        DeviceAuthorizationCacheControl cacheData = this.deviceAuthorizationService.getDeviceAuthzByUserCode(userCode);
        if (cacheData == null || cacheData.getStatus() == DeviceAuthorizationStatus.EXPIRED) {
            this.log.trace("User responded too late and the authorization {} has expired, {}", (Object)userCode, (Object)cacheData);
            return;
        }
        this.deviceAuthorizationService.removeDeviceAuthRequestInCache(userCode, cacheData.getDeviceCode());
        DeviceCodeGrant deviceCodeGrant = this.authorizationGrantList.createDeviceGrant(cacheData, user);
        this.log.info("Granted device authorization request, user_code: {}, device_code: {}, grant_id: {}", new Object[]{userCode, cacheData.getDeviceCode(), deviceCodeGrant.getGrantId()});
    }
}

