/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs.fido.u2f;

import javax.inject.Inject;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.exception.fido.u2f.DeviceCompromisedException;
import org.gluu.oxauth.exception.fido.u2f.InvalidKeyHandleDeviceException;
import org.gluu.oxauth.exception.fido.u2f.NoEligableDevicesException;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.fido.u2f.AuthenticateRequestMessageLdap;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistrationResult;
import org.gluu.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.gluu.oxauth.model.fido.u2f.exception.BadInputException;
import org.gluu.oxauth.model.fido.u2f.protocol.AuthenticateRequestMessage;
import org.gluu.oxauth.model.fido.u2f.protocol.AuthenticateResponse;
import org.gluu.oxauth.model.fido.u2f.protocol.AuthenticateStatus;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.oxauth.service.fido.u2f.AuthenticationService;
import org.gluu.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.gluu.oxauth.service.fido.u2f.UserSessionIdService;
import org.gluu.oxauth.service.fido.u2f.ValidationService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/fido/u2f/authentication")
public class U2fAuthenticationWS {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UserService userService;
    @Inject
    private AuthenticationService u2fAuthenticationService;
    @Inject
    private DeviceRegistrationService deviceRegistrationService;
    @Inject
    private UserSessionIdService userSessionIdService;
    @Inject
    private ValidationService u2fValidationService;

    @GET
    @Produces(value={"application/json"})
    public Response startAuthentication(@QueryParam(value="username") String userName, @QueryParam(value="keyhandle") String keyHandle, @QueryParam(value="application") String appId, @QueryParam(value="session_id") String sessionId) {
        try {
            if (this.appConfiguration.getDisableU2fEndpoint().booleanValue()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.log.debug("Startig authentication with username '{}', keyhandle '{}' for appId '{}' and session_id '{}'", new Object[]{userName, keyHandle, appId, sessionId});
            if (StringHelper.isEmpty((String)userName) && StringHelper.isEmpty((String)keyHandle)) {
                throw new BadInputException("The request should contains either username or keyhandle");
            }
            String foundUserInum = null;
            boolean twoStep = StringHelper.isNotEmpty((String)userName);
            if (twoStep) {
                boolean valid = this.u2fValidationService.isValidSessionId(userName, sessionId);
                if (!valid) {
                    throw new BadInputException(String.format("session_id '%s' is invalid", sessionId));
                }
                foundUserInum = this.userService.getUserInum(userName);
            } else {
                String keyHandleWithoutPading = Base64Util.base64urlencode((byte[])Base64Util.base64urldecode((String)keyHandle));
                foundUserInum = this.u2fAuthenticationService.getUserInumByKeyHandle(appId, keyHandleWithoutPading);
            }
            if (StringHelper.isEmpty((String)foundUserInum)) {
                throw new BadInputException(String.format("Failed to find user by userName '%s' or keyHandle '%s' in LDAP", userName, keyHandle));
            }
            AuthenticateRequestMessage authenticateRequestMessage = this.u2fAuthenticationService.buildAuthenticateRequestMessage(appId, foundUserInum);
            this.u2fAuthenticationService.storeAuthenticationRequestMessage(authenticateRequestMessage, foundUserInum, sessionId);
            String entity = ServerUtil.asJson(authenticateRequestMessage);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            if (ex instanceof NoEligableDevicesException || ex instanceof InvalidKeyHandleDeviceException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.NO_ELIGABLE_DEVICES)).build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response finishAuthentication(@FormParam(value="username") String userName, @FormParam(value="tokenResponse") String authenticateResponseString) {
        String sessionId = null;
        try {
            if (this.appConfiguration.getDisableU2fEndpoint().booleanValue()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.log.debug("Finishing authentication for username '{}' with response '{}'", (Object)userName, (Object)authenticateResponseString);
            AuthenticateResponse authenticateResponse = (AuthenticateResponse)ServerUtil.jsonMapperWithWrapRoot().readValue(authenticateResponseString, AuthenticateResponse.class);
            String requestId = authenticateResponse.getRequestId();
            AuthenticateRequestMessageLdap authenticateRequestMessageLdap = this.u2fAuthenticationService.getAuthenticationRequestMessageByRequestId(requestId);
            if (authenticateRequestMessageLdap == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SESSION_EXPIRED)).build());
            }
            sessionId = authenticateRequestMessageLdap.getSessionId();
            this.u2fAuthenticationService.removeAuthenticationRequestMessage(authenticateRequestMessageLdap);
            AuthenticateRequestMessage authenticateRequestMessage = authenticateRequestMessageLdap.getAuthenticateRequestMessage();
            String foundUserInum = authenticateRequestMessageLdap.getUserInum();
            DeviceRegistrationResult deviceRegistrationResult = this.u2fAuthenticationService.finishAuthentication(authenticateRequestMessage, authenticateResponse, foundUserInum);
            if (StringHelper.isNotEmpty((String)sessionId)) {
                this.log.debug("There is session id. Setting session id attributes");
                boolean oneStep = StringHelper.isEmpty((String)userName);
                this.userSessionIdService.updateUserSessionIdOnFinishRequest(sessionId, foundUserInum, deviceRegistrationResult, false, oneStep);
            }
            AuthenticateStatus authenticationStatus = new AuthenticateStatus("success", requestId);
            String entity = ServerUtil.asJson(authenticationStatus);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            try {
                if (StringHelper.isNotEmpty(sessionId)) {
                    this.log.debug("There is session id. Setting session id status to 'declined'");
                    this.userSessionIdService.updateUserSessionIdOnError(sessionId);
                }
            }
            catch (Exception ex2) {
                this.log.error("Failed to update session id status", (Throwable)ex2);
            }
            if (ex instanceof BadInputException) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.INVALID_REQUEST)).build());
            }
            if (ex instanceof DeviceCompromisedException) {
                DeviceRegistration deviceRegistration = ((DeviceCompromisedException)ex).getDeviceRegistration();
                try {
                    this.deviceRegistrationService.disableUserDeviceRegistration(deviceRegistration);
                }
                catch (Exception ex2) {
                    this.log.error("Failed to mark device '{}' as compomised", (Object)ex2, (Object)deviceRegistration.getId());
                }
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getErrorResponse((IErrorType)U2fErrorResponseType.DEVICE_COMPROMISED)).build());
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getJsonErrorResponse((IErrorType)U2fErrorResponseType.SERVER_ERROR)).build());
        }
    }
}

