/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.userinfo.ws.rs;

import java.security.PublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.GluuAttribute;
import org.gluu.model.attribute.AttributeDataType;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.claims.Audience;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.authorize.Claim;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.DefaultScope;
import org.gluu.oxauth.model.common.ScopeType;
import org.gluu.oxauth.model.common.UnmodifiableAuthorizationGrant;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.exception.InvalidClaimException;
import org.gluu.oxauth.model.exception.InvalidJweException;
import org.gluu.oxauth.model.json.JsonApplier;
import org.gluu.oxauth.model.jwe.Jwe;
import org.gluu.oxauth.model.jwe.JweEncrypterImpl;
import org.gluu.oxauth.model.jwk.Algorithm;
import org.gluu.oxauth.model.jwk.JSONWebKeySet;
import org.gluu.oxauth.model.jwk.Use;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.jwt.JwtSubClaimObject;
import org.gluu.oxauth.model.jwt.JwtType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.gluu.oxauth.model.userinfo.UserInfoParamsValidator;
import org.gluu.oxauth.model.util.JwtUtil;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.ScopeService;
import org.gluu.oxauth.service.ServerCryptoProvider;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.external.ExternalDynamicScopeService;
import org.gluu.oxauth.service.external.context.DynamicScopeExternalContext;
import org.gluu.oxauth.service.token.TokenService;
import org.gluu.oxauth.userinfo.ws.rs.UserInfoRestWebService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Path(value="/")
public class UserInfoRestWebServiceImpl
implements UserInfoRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private UserService userService;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private TokenService tokenService;

    @Override
    public Response requestUserInfoGet(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        return this.requestUserInfo(accessToken, authorization, request, securityContext);
    }

    @Override
    public Response requestUserInfoPost(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        return this.requestUserInfo(accessToken, authorization, request, securityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response requestUserInfo(String accessToken, String authorization, HttpServletRequest request, SecurityContext securityContext) {
        if (this.tokenService.isBearerAuthToken(authorization)) {
            accessToken = this.tokenService.getBearerToken(authorization);
        }
        this.log.debug("Attempting to request User Info, Access token = {}, Is Secure = {}", (Object)accessToken, (Object)securityContext.isSecure());
        Response.ResponseBuilder builder = Response.ok();
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.USER_INFO);
        try {
            if (!UserInfoParamsValidator.validateParams(accessToken)) {
                Response response = this.response(400, UserInfoErrorResponseType.INVALID_REQUEST, "access token is not valid.");
                return response;
            }
            AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
            if (authorizationGrant == null) {
                this.log.trace("Failed to find authorization grant by access_token: " + accessToken);
                Response response = this.response(401, UserInfoErrorResponseType.INVALID_TOKEN);
                return response;
            }
            oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, false);
            AbstractToken accessTokenObject = authorizationGrant.getAccessToken(accessToken);
            if (accessTokenObject == null || !accessTokenObject.isValid()) {
                this.log.trace("Invalid access token object, access_token: {}, isNull: {}, isValid: {}", new Object[]{accessToken, accessTokenObject == null, false});
                Response response = this.response(401, UserInfoErrorResponseType.INVALID_TOKEN);
                return response;
            }
            if (authorizationGrant.getAuthorizationGrantType() == AuthorizationGrantType.CLIENT_CREDENTIALS) {
                Response response = this.response(403, UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Grant object has client_credentials grant_type which is not valid.");
                return response;
            }
            if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && !authorizationGrant.getScopes().contains(DefaultScope.OPEN_ID.toString()) && !authorizationGrant.getScopes().contains(DefaultScope.PROFILE.toString())) {
                Response response = this.response(403, UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Both openid and profile scopes are not present.");
                return response;
            }
            if (!this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && !authorizationGrant.getScopes().contains(DefaultScope.OPEN_ID.toString())) {
                Response response = this.response(403, UserInfoErrorResponseType.INSUFFICIENT_SCOPE, "Missed openid scope.");
                return response;
            }
            oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, true);
            builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
            builder.header("Pragma", (Object)"no-cache");
            User currentUser = authorizationGrant.getUser();
            try {
                currentUser = this.userService.getUserByDn(authorizationGrant.getUserDn(), new String[0]);
            }
            catch (EntryPersistenceException ex) {
                this.log.warn("Failed to reload user entry: '{}'", (Object)authorizationGrant.getUserDn());
            }
            if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getUserInfoEncryptedResponseAlg() != null && authorizationGrant.getClient().getUserInfoEncryptedResponseEnc() != null) {
                KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoEncryptedResponseAlg());
                BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getUserInfoEncryptedResponseEnc());
                builder.type("application/jwt");
                builder.entity((Object)this.getJweResponse(keyEncryptionAlgorithm, blockEncryptionAlgorithm, currentUser, authorizationGrant, authorizationGrant.getScopes()));
            } else if (authorizationGrant.getClient() != null && authorizationGrant.getClient().getUserInfoSignedResponseAlg() != null) {
                SignatureAlgorithm algorithm = SignatureAlgorithm.fromString((String)authorizationGrant.getClient().getUserInfoSignedResponseAlg());
                builder.type("application/jwt");
                builder.entity((Object)this.getJwtResponse(algorithm, currentUser, authorizationGrant, authorizationGrant.getScopes()));
            } else {
                builder.type("application/json;charset=UTF-8");
                builder.entity((Object)this.getJSonResponse(currentUser, authorizationGrant, authorizationGrant.getScopes()));
            }
            Response response = builder.build();
            return response;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            Response response = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).build();
            return response;
        }
        finally {
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        }
    }

    private Response response(int status, UserInfoErrorResponseType errorResponseType) {
        return this.response(status, errorResponseType, "");
    }

    private Response response(int status, UserInfoErrorResponseType errorResponseType, String reason) {
        return Response.status((int)status).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)errorResponseType, reason)).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate()).build();
    }

    private String getJwtResponse(SignatureAlgorithm signatureAlgorithm, User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        this.log.trace("Building JWT reponse with next scopes {0} for user {1} and user custom attributes {0}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        Jwt jwt = new Jwt();
        jwt.getHeader().setType(JwtType.JWT);
        jwt.getHeader().setAlgorithm(signatureAlgorithm);
        String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(this.webKeysConfiguration, Algorithm.fromString((String)signatureAlgorithm.getName()), Use.SIGNATURE);
        if (keyId != null) {
            jwt.getHeader().setKeyId(keyId);
        }
        jwt.setClaims(this.createJwtClaims(user, authorizationGrant, scopes));
        String sharedSecret = this.clientService.decryptSecret(authorizationGrant.getClient().getClientSecret());
        String signature = this.cryptoProvider.sign(jwt.getSigningInput(), jwt.getHeader().getKeyId(), sharedSecret, signatureAlgorithm);
        jwt.setEncodedSignature(signature);
        return jwt.toString();
    }

    private JwtClaims createJwtClaims(User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        String claimsString = this.getJSonResponse(user, authorizationGrant, scopes);
        JwtClaims claims = new JwtClaims(new JSONObject(claimsString));
        claims.setIssuer(this.appConfiguration.getIssuer());
        Audience.setAudience((JwtClaims)claims, (Client)authorizationGrant.getClient());
        return claims;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getJweResponse(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        this.log.trace("Building JWE reponse with next scopes {0} for user {1} and user custom attributes {0}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        Jwe jwe = new Jwe();
        jwe.getHeader().setType(JwtType.JWT);
        jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
        jwe.setClaims(this.createJwtClaims(user, authorizationGrant, scopes));
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            JSONObject jsonWebKeys = JwtUtil.getJSONWebKeys((String)authorizationGrant.getClient().getJwksUri());
            String keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyEncryptionAlgorithm.getName()), Use.ENCRYPTION);
            PublicKey publicKey = this.cryptoProvider.getPublicKey(keyId, jsonWebKeys, null);
            if (publicKey == null) throw new InvalidJweException("The public key is not valid");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, publicKey);
            jwe = jweEncrypter.encrypt(jwe);
            return jwe.toString();
        }
        if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A128KW && keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A256KW) return jwe.toString();
        try {
            byte[] sharedSymmetricKey = this.clientService.decryptSecret(authorizationGrant.getClient().getClientSecret()).getBytes("UTF-8");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedSymmetricKey);
            jwe = jweEncrypter.encrypt(jwe);
            return jwe.toString();
        }
        catch (Exception e) {
            throw new InvalidJweException((Throwable)e);
        }
    }

    public String getJSonResponse(User user, AuthorizationGrant authorizationGrant, Collection<String> scopes) throws Exception {
        Object claimsObj;
        this.log.trace("Building JSON reponse with next scopes {0} for user {1} and user custom attributes {0}", new Object[]{scopes, user.getUserId(), user.getCustomAttributes()});
        JsonWebResponse jsonWebResponse = new JsonWebResponse();
        ArrayList<Scope> dynamicScopes = new ArrayList<Scope>();
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeById(scopeName);
            if (scope != null && ScopeType.DYNAMIC == scope.getScopeType()) {
                dynamicScopes.add(scope);
                continue;
            }
            Map<String, Object> claims = this.getClaims(user, scope);
            if (Boolean.TRUE.equals(scope.isOxAuthGroupClaims())) {
                JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                groupClaim.setName(scope.getId());
                for (Map.Entry<String, Object> entry : claims.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof List) {
                        groupClaim.setClaim(key, (List)value);
                        continue;
                    }
                    groupClaim.setClaim(key, String.valueOf(value));
                }
                jsonWebResponse.getClaims().setClaim(scope.getId(), groupClaim);
                continue;
            }
            for (Map.Entry entry : claims.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    jsonWebResponse.getClaims().setClaim(key, (List)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    jsonWebResponse.getClaims().setClaim(key, (Boolean)value);
                    continue;
                }
                if (value instanceof Date) {
                    jsonWebResponse.getClaims().setClaim(key, Long.valueOf(((Date)value).getTime() / 1000L));
                    continue;
                }
                jsonWebResponse.getClaims().setClaim(key, String.valueOf(value));
            }
        }
        if (authorizationGrant.getClaims() != null && (claimsObj = new JSONObject(authorizationGrant.getClaims())).has("userinfo")) {
            JSONObject userInfoObj = claimsObj.getJSONObject("userinfo");
            Iterator it = userInfoObj.keys();
            while (it.hasNext()) {
                String claimName = (String)it.next();
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claimName);
                if (gluuAttribute == null) continue;
                String ldapClaimName = gluuAttribute.getName();
                Object attribute = user.getAttribute(ldapClaimName, optional, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                jsonWebResponse.getClaims().setClaimFromJsonObject(claimName, attribute);
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getUserInfoMember().getClaims()) {
                Client client;
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null || !this.validateRequesteClaim(gluuAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes)) continue;
                String string = gluuAttribute.getName();
                Object attribute = user.getAttribute(string, optional, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                jsonWebResponse.getClaims().setClaimFromJsonObject(claim.getName(), attribute);
            }
        }
        jsonWebResponse.getClaims().setSubjectIdentifier(authorizationGrant.getSub());
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, jsonWebResponse, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        return jsonWebResponse.toString();
    }

    public boolean validateRequesteClaim(GluuAttribute gluuAttribute, String[] clientAllowedClaims, Collection<String> scopes) {
        if (gluuAttribute == null) {
            this.log.trace("gluuAttribute is null.");
            return false;
        }
        if (clientAllowedClaims != null) {
            for (String clientAllowedClaim : clientAllowedClaims) {
                if (!gluuAttribute.getDn().equals(clientAllowedClaim)) continue;
                return true;
            }
        }
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeById(scopeName);
            if (scope == null || scope.getOxAuthClaims() == null) continue;
            for (String claimDn : scope.getOxAuthClaims()) {
                if (!gluuAttribute.getDisplayName().equals(this.attributeService.getAttributeByDn(claimDn).getDisplayName())) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getClaims(User user, Scope scope) throws InvalidClaimException, ParseException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        if (scope == null) {
            this.log.trace("Scope is null.");
            return claims;
        }
        List scopeClaims = scope.getOxAuthClaims();
        if (scopeClaims == null) {
            this.log.trace("No claims set for scope: " + scope.getId());
            return claims;
        }
        for (String claimDn : scopeClaims) {
            Object value;
            GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
            String claimName = gluuAttribute.getOxAuthClaimName();
            String ldapName = gluuAttribute.getName();
            Object attribute = null;
            if (StringUtils.isBlank((String)claimName)) {
                this.log.error("Failed to get claim because claim name is not set for attribute, id: " + gluuAttribute.getDn());
                continue;
            }
            if (StringUtils.isBlank((String)ldapName)) {
                this.log.error("Failed to get claim because name is not set for attribute, id: " + gluuAttribute.getDn());
                continue;
            }
            if (ldapName.equals("uid")) {
                attribute = user.getUserId();
            } else if (ldapName.equals("updatedAt")) {
                attribute = user.getUpdatedAt();
            } else if (AttributeDataType.BOOLEAN.equals((Object)gluuAttribute.getDataType())) {
                value = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                attribute = value instanceof String ? Boolean.valueOf(Boolean.parseBoolean(String.valueOf(value))) : value;
            } else if (AttributeDataType.DATE.equals((Object)gluuAttribute.getDataType())) {
                value = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
                if (value instanceof Date) {
                    attribute = value;
                } else if (value != null) {
                    attribute = this.entryManager.decodeTime(user.getDn(), value.toString());
                }
            } else {
                attribute = user.getAttribute(gluuAttribute.getName(), true, gluuAttribute.getOxMultiValuedAttribute().booleanValue());
            }
            if (attribute == null) continue;
            if (attribute instanceof JSONArray) {
                claims.put(claimName, JsonApplier.getStringList((JSONArray)((JSONArray)attribute)));
                continue;
            }
            claims.put(claimName, attribute);
        }
        return claims;
    }
}

