/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.RptIntrospectionResponse;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.external.ExternalUmaRptClaimsService;
import org.gluu.oxauth.service.external.context.ExternalUmaRptClaimsContext;
import org.gluu.oxauth.uma.authorization.UmaPCT;
import org.gluu.oxauth.uma.authorization.UmaRPT;
import org.gluu.oxauth.uma.service.UmaPctService;
import org.gluu.oxauth.uma.service.UmaRptService;
import org.gluu.oxauth.uma.service.UmaScopeService;
import org.gluu.oxauth.uma.service.UmaValidationService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.StringHelper;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/rpt/status")
public class UmaRptIntrospectionWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaRptService rptService;
    @Inject
    private UmaValidationService umaValidationService;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private ExternalUmaRptClaimsService externalUmaRptClaimsService;
    @Inject
    private ClientService clientService;

    @GET
    @Produces(value={"application/json"})
    public Response introspectGet(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="token") String token, @QueryParam(value="token_type_hint") String tokenTypeHint, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(authorization, token, tokenTypeHint, httpRequest, httpResponse);
    }

    @POST
    @Produces(value={"application/json"})
    public Response introspectPost(@HeaderParam(value="Authorization") String authorization, @FormParam(value="token") String token, @FormParam(value="token_type_hint") String tokenTypeHint, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(authorization, token, tokenTypeHint, httpRequest, httpResponse);
    }

    private Response introspect(String authorization, String token, String tokenTypeHint, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ExternalUmaRptClaimsContext context;
            JSONObject rptAsJson;
            this.umaValidationService.assertHasProtectionScope(authorization);
            UmaRPT rpt = this.rptService.getRPTByCode(token);
            if (!this.isValid(rpt)) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new RptIntrospectionResponse(false)).cacheControl(ServerUtil.cacheControl(true)).build();
            }
            List<UmaPermission> permissions = this.buildStatusResponsePermissions(rpt);
            RptIntrospectionResponse statusResponse = new RptIntrospectionResponse();
            statusResponse.setActive(true);
            statusResponse.setExpiresAt(ServerUtil.dateToSeconds(rpt.getExpirationDate()));
            statusResponse.setIssuedAt(ServerUtil.dateToSeconds(rpt.getCreationDate()));
            statusResponse.setPermissions(permissions);
            statusResponse.setClientId(rpt.getClientId());
            statusResponse.setAud(rpt.getClientId());
            statusResponse.setSub(rpt.getUserId());
            List<org.gluu.oxauth.model.uma.persistence.UmaPermission> rptPermissions = this.rptService.getRptPermissions(rpt);
            if (!rptPermissions.isEmpty()) {
                org.gluu.oxauth.model.uma.persistence.UmaPermission permission = rptPermissions.iterator().next();
                String pctCode = (String)permission.getAttributes().get("pct");
                if (StringHelper.isNotEmpty((String)pctCode)) {
                    UmaPCT pct = this.pctService.getByCode(pctCode);
                    if (pct != null) {
                        statusResponse.setPctClaims(pct.getClaims().toMap());
                    } else {
                        this.log.error("Failed to find PCT with code: " + pctCode + " which is taken from permission object: " + permission.getDn());
                    }
                } else {
                    this.log.trace("PCT code is blank for RPT: " + rpt.getCode());
                }
            }
            if (this.externalUmaRptClaimsService.externalModify(rptAsJson = new JSONObject(ServerUtil.asJson(statusResponse)), context = new ExternalUmaRptClaimsContext(this.clientService.getClient(rpt.getClientId()), httpRequest, httpResponse))) {
                this.log.trace("Successfully run external RPT Claims script associated with {}", (Object)rpt.getClientId());
            } else {
                rptAsJson = new JSONObject(ServerUtil.asJson(statusResponse));
                this.log.trace("Canceled changes made by external RPT Claims script since method returned `false`.");
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)rptAsJson.toString()).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Internal error.");
        }
    }

    private boolean isValid(UmaRPT p_rpt) {
        if (p_rpt != null) {
            p_rpt.checkExpired();
            return p_rpt.isValid();
        }
        return false;
    }

    private boolean isValid(org.gluu.oxauth.model.uma.persistence.UmaPermission permission) {
        if (permission != null) {
            permission.checkExpired();
            return permission.isValid();
        }
        return false;
    }

    private List<UmaPermission> buildStatusResponsePermissions(UmaRPT rpt) {
        List<org.gluu.oxauth.model.uma.persistence.UmaPermission> rptPermissions;
        ArrayList<UmaPermission> result = new ArrayList<UmaPermission>();
        if (rpt != null && (rptPermissions = this.rptService.getRptPermissions(rpt)) != null && !rptPermissions.isEmpty()) {
            for (org.gluu.oxauth.model.uma.persistence.UmaPermission permission : rptPermissions) {
                if (this.isValid(permission)) {
                    UmaPermission toAdd = ServerUtil.convert(permission, this.umaScopeService);
                    if (toAdd == null) continue;
                    result.add(toAdd);
                    continue;
                }
                this.log.debug("Ignore permission, skip it in response because permission is not valid. Permission dn: {}, rpt dn: {}", (Object)permission.getDn(), (Object)rpt.getDn());
            }
        }
        return result;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response requestRptStatusGet(@HeaderParam(value="Authorization") String authorization, @FormParam(value="token") String rpt, @FormParam(value="token_type_hint") String tokenTypeHint) {
        throw new WebApplicationException(Response.status((int)405).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"Introspection of RPT is not allowed by GET HTTP method.").build());
    }
}

