/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.UmaResourceResponse;
import org.gluu.oxauth.model.uma.UmaResourceWithId;
import org.gluu.oxauth.model.uma.persistence.UmaResource;
import org.gluu.oxauth.uma.service.UmaResourceService;
import org.gluu.oxauth.uma.service.UmaScopeService;
import org.gluu.oxauth.uma.service.UmaValidationService;
import org.gluu.oxauth.util.ServerUtil;
import org.slf4j.Logger;

@Path(value="/host/rsrc/resource_set")
public class UmaResourceRegistrationWS {
    private static final int NOT_ALLOWED_STATUS = 405;
    private static final int DEFAULT_RESOURCE_LIFETIME = 2592000;
    @Inject
    private Logger log;
    @Inject
    private UmaValidationService umaValidationService;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private AppConfiguration appConfiguration;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createResource(@HeaderParam(value="Authorization") String authorization, org.gluu.oxauth.model.uma.UmaResource resource) {
        try {
            String id = UUID.randomUUID().toString();
            this.log.trace("Try to create resource, id: {}", (Object)id);
            return this.putResourceImpl(Response.Status.CREATED, authorization, id, resource);
        }
        catch (Exception ex) {
            this.log.error("Exception during resource creation", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    @PUT
    @Path(value="{rsid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateResource(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") String rsid, org.gluu.oxauth.model.uma.UmaResource resource) {
        try {
            return this.putResourceImpl(Response.Status.OK, authorization, rsid, resource);
        }
        catch (Exception ex) {
            this.log.error("Exception during resource update, rsId: " + rsid + ", message: " + ex.getMessage(), (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    @GET
    @Path(value="{rsid}")
    @Produces(value={"application/json"})
    public Response getResource(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") String rsid) {
        try {
            AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
            this.umaValidationService.validateRestrictedByClient(authorizationGrant.getClientDn(), rsid);
            this.log.debug("Getting resource description: '{}'", (Object)rsid);
            UmaResource ldapResource = this.resourceService.getResourceById(rsid);
            UmaResourceWithId response = new UmaResourceWithId();
            response.setId(ldapResource.getId());
            response.setName(ldapResource.getName());
            response.setDescription(ldapResource.getDescription());
            response.setIconUri(ldapResource.getIconUri());
            response.setScopes(this.umaScopeService.getScopeIdsByDns(ldapResource.getScopes()));
            response.setScopeExpression(ldapResource.getScopeExpression());
            response.setType(ldapResource.getType());
            response.setIat(ServerUtil.dateToSeconds(ldapResource.getCreationDate()));
            response.setExp(ServerUtil.dateToSeconds(ldapResource.getExpirationDate()));
            Response.ResponseBuilder builder = Response.ok();
            builder.entity((Object)ServerUtil.asJson(response));
            return builder.build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    @GET
    @Produces(value={"application/json"})
    public List<String> getResourceList(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="scope") String scope) {
        try {
            this.log.trace("Getting list of resource descriptions.");
            AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
            String clientDn = authorizationGrant.getClientDn();
            List<UmaResource> ldapResources = this.resourceService.getResourcesByAssociatedClient(clientDn);
            ArrayList<String> result = new ArrayList<String>(ldapResources.size());
            for (UmaResource ldapResource : ldapResources) {
                if (StringUtils.isNotBlank((String)scope)) {
                    List<String> scopeUrlsByDns = this.umaScopeService.getScopeIdsByDns(ldapResource.getScopes());
                    if (scopeUrlsByDns == null || !scopeUrlsByDns.contains(scope)) continue;
                    result.add(ldapResource.getId());
                    continue;
                }
                result.add(ldapResource.getId());
            }
            return result;
        }
        catch (Exception ex) {
            this.log.error("Exception happened on getResourceList()", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    @DELETE
    @Path(value="{rsid}")
    public Response deleteResource(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") String rsid) {
        try {
            this.log.debug("Deleting resource descriptions'");
            AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
            this.umaValidationService.validateRestrictedByClient(authorizationGrant.getClientDn(), rsid);
            this.resourceService.remove(rsid);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception ex) {
            this.log.error("Error on DELETE Resource - " + ex.getMessage(), (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, ex.getMessage());
        }
    }

    private Response putResourceImpl(Response.Status status, String authorization, String rsid, org.gluu.oxauth.model.uma.UmaResource resource) throws IOException {
        UmaResource ldapUpdatedResource;
        this.log.trace("putResourceImpl, rsid: {}, status:", (Object)rsid, (Object)status.name());
        AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
        this.umaValidationService.validateResource(resource);
        String userDn = authorizationGrant.getUserDn();
        String clientDn = authorizationGrant.getClientDn();
        if (status == Response.Status.CREATED) {
            ldapUpdatedResource = this.addResource(rsid, resource, userDn, clientDn);
        } else {
            this.umaValidationService.validateRestrictedByClient(clientDn, rsid);
            ldapUpdatedResource = this.updateResource(rsid, resource);
        }
        UmaResourceResponse response = new UmaResourceResponse();
        response.setId(ldapUpdatedResource.getId());
        return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ServerUtil.asJson(response)).build();
    }

    private UmaResource addResource(String rsid, org.gluu.oxauth.model.uma.UmaResource resource, String userDn, String clientDn) {
        this.log.debug("Adding new resource: '{}'", (Object)rsid);
        String resourceDn = this.resourceService.getDnForResource(rsid);
        List<String> scopeDNs = this.umaScopeService.getScopeDNsByIdsAndAddToLdapIfNeeded(resource.getScopes());
        Calendar calendar = Calendar.getInstance();
        Date iat = calendar.getTime();
        Date exp = this.getExpirationDate(calendar);
        if (resource.getIat() != null && resource.getIat() > 0) {
            iat = new Date((long)resource.getIat().intValue() * 1000L);
        }
        if (resource.getExp() != null && resource.getExp() > 0) {
            exp = new Date((long)resource.getExp().intValue() * 1000L);
        }
        UmaResource ldapResource = new UmaResource();
        ldapResource.setName(resource.getName());
        ldapResource.setDescription(resource.getDescription());
        ldapResource.setIconUri(resource.getIconUri());
        ldapResource.setId(rsid);
        ldapResource.setRev("1");
        ldapResource.setCreator(userDn);
        ldapResource.setDn(resourceDn);
        ldapResource.setScopes(scopeDNs);
        ldapResource.setScopeExpression(resource.getScopeExpression());
        ldapResource.setClients(new ArrayList<String>(Collections.singletonList(clientDn)));
        ldapResource.setType(resource.getType());
        ldapResource.setCreationDate(iat);
        ldapResource.setExpirationDate(exp);
        ldapResource.setTtl(Integer.valueOf(this.appConfiguration.getUmaResourceLifetime()));
        this.resourceService.addResource(ldapResource);
        return ldapResource;
    }

    private Date getExpirationDate(Calendar creationCalender) {
        int lifetime = this.appConfiguration.getUmaResourceLifetime();
        if (lifetime <= 0) {
            lifetime = 2592000;
        }
        creationCalender.add(13, lifetime);
        return creationCalender.getTime();
    }

    private UmaResource updateResource(String rsid, org.gluu.oxauth.model.uma.UmaResource resource) {
        this.log.debug("Updating resource description: '{}'.", (Object)rsid);
        UmaResource ldapResource = this.resourceService.getResourceById(rsid);
        if (ldapResource == null) {
            return (UmaResource)this.throwNotFoundException(rsid);
        }
        ldapResource.setName(resource.getName());
        ldapResource.setDescription(resource.getDescription());
        ldapResource.setIconUri(resource.getIconUri());
        ldapResource.setScopes(this.umaScopeService.getScopeDNsByIdsAndAddToLdapIfNeeded(resource.getScopes()));
        ldapResource.setScopeExpression(resource.getScopeExpression());
        ldapResource.setRev(String.valueOf(this.incrementRev(ldapResource.getRev())));
        ldapResource.setType(resource.getType());
        if (resource.getExp() != null && resource.getExp() > 0) {
            ldapResource.setExpirationDate(new Date((long)resource.getExp().intValue() * 1000L));
            ldapResource.setTtl(Integer.valueOf(this.appConfiguration.getUmaResourceLifetime()));
        }
        this.resourceService.updateResource(ldapResource);
        return ldapResource;
    }

    private int incrementRev(String rev) {
        try {
            return Integer.parseInt(rev) + 1;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 1;
        }
    }

    private <T> T throwNotFoundException(String rsid) {
        this.log.error("Specified resource description doesn't exist, id: " + rsid);
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.NOT_FOUND, (IErrorType)UmaErrorResponseType.NOT_FOUND, "Resource does not exists.");
    }

    @HEAD
    public Response unsupportedHeadMethod() {
        this.log.error("HEAD method is not allowed");
        throw new WebApplicationException(Response.status((int)405).entity((Object)"HEAD Method Not Allowed").build());
    }

    @OPTIONS
    public Response unsupportedOptionsMethod() {
        this.log.error("OPTIONS method is not allowed");
        throw new WebApplicationException(Response.status((int)405).entity((Object)"OPTIONS Method Not Allowed").build());
    }
}

