/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.signature.RSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.gluu.oxauth.model.jws.RSASigner;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.uma.ClaimTokenFormatType;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.model.uma.UmaPermissionList;
import org.gluu.oxauth.model.uma.UmaScopeType;
import org.gluu.oxauth.model.uma.persistence.UmaResource;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.RedirectionUriService;
import org.gluu.oxauth.service.token.TokenService;
import org.gluu.oxauth.uma.authorization.UmaPCT;
import org.gluu.oxauth.uma.authorization.UmaRPT;
import org.gluu.oxauth.uma.authorization.UmaWebException;
import org.gluu.oxauth.uma.service.UmaExpressionService;
import org.gluu.oxauth.uma.service.UmaPctService;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaResourceService;
import org.gluu.oxauth.uma.service.UmaRptService;
import org.gluu.oxauth.uma.service.UmaScopeService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.util.StringHelper;
import org.oxauth.persistence.model.Scope;
import org.python.google.common.base.Function;
import org.python.google.common.collect.Iterables;
import org.slf4j.Logger;

@Named
@Stateless
public class UmaValidationService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private TokenService tokenService;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private UmaScopeService umaScopeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private UmaRptService rptService;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private UmaExpressionService expressionService;

    public AuthorizationGrant assertHasProtectionScope(String authorization) {
        return this.validateAuthorization(authorization, UmaScopeType.PROTECTION);
    }

    private AuthorizationGrant validateAuthorization(String authorization, UmaScopeType umaScopeType) {
        this.log.trace("Validate authorization: {}", (Object)authorization);
        if (StringHelper.isEmpty((String)authorization)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.UNAUTHORIZED_CLIENT, "Authorization header is blank.");
        }
        String token = this.tokenService.getToken(authorization);
        if (StringHelper.isEmpty((String)token)) {
            this.log.debug("Token is invalid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.UNAUTHORIZED_CLIENT, "Token is invalid.");
        }
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
        if (authorizationGrant == null) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.ACCESS_DENIED, "Unable to find authorization grant by token.");
        }
        Set<String> scopes = authorizationGrant.getScopes();
        if (!scopes.contains(umaScopeType.getValue())) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.NOT_ACCEPTABLE, (IErrorType)UmaErrorResponseType.INVALID_CLIENT_SCOPE, "Client does not have scope: " + umaScopeType.getValue());
        }
        return authorizationGrant;
    }

    public UmaRPT validateRPT(String rptCode) {
        if (StringUtils.isNotBlank((String)rptCode)) {
            UmaRPT rpt = this.rptService.getRPTByCode(rptCode);
            if (rpt != null) {
                rpt.checkExpired();
                if (rpt.isValid()) {
                    return rpt;
                }
                this.log.error("RPT is not valid. Revoked: " + rpt.isRevoked() + ", Expired: " + rpt.isExpired() + ", rptCode: " + rptCode);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RPT, "RPT is not valid. Revoked: " + rpt.isRevoked() + ", Expired: " + rpt.isExpired() + ", rptCode: " + rptCode);
            }
            this.log.error("RPT is null, rptCode: " + rptCode);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RPT, "RPT is null, rptCode: " + rptCode);
        }
        return null;
    }

    public void validatePermissions(List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions) {
        for (org.gluu.oxauth.model.uma.persistence.UmaPermission permission : permissions) {
            this.validatePermission(permission);
        }
    }

    public void validatePermission(org.gluu.oxauth.model.uma.persistence.UmaPermission permission) {
        if (permission == null || "invalidated".equalsIgnoreCase(permission.getStatus())) {
            this.log.error("Permission is null or otherwise invalidated. Status: " + (permission != null ? permission.getStatus() : "No permissions."));
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_TICKET, "Permission is null or otherwise invalidated. Status: " + (permission != null ? permission.getStatus() : "No permissions."));
        }
        permission.checkExpired();
        if (!permission.isValid()) {
            this.log.error("Permission is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.EXPIRED_TICKET, "Permission is not valid.");
        }
    }

    public void validatePermissions(UmaPermissionList permissions, Client client) {
        for (UmaPermission permission : permissions) {
            this.validatePermission(permission, client);
        }
    }

    public void validatePermission(UmaPermission permission, Client client) {
        String resourceId = permission.getResourceId();
        if (StringHelper.isEmpty((String)resourceId)) {
            this.log.error("Resource id is empty");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_ID, "Resource id is empty");
        }
        try {
            UmaResource resource = this.resourceService.getResourceById(resourceId);
            if (resource == null) {
                this.log.error("Resource isn't registered or there are two resources with same Id");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_ID, "Resource is not registered.");
            }
            for (String s : permission.getScopes()) {
                Scope spontaneousScope;
                if (resource.getScopes().contains(s) || (spontaneousScope = this.umaScopeService.getOrCreate(client, s, Sets.newHashSet(this.umaScopeService.getScopeIdsByDns(resource.getScopes())))) != null) continue;
                this.log.error("Scope isn't registered and is not allowed by spontaneous scopes. Scope: " + s);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_SCOPE, "At least one of the scopes isn't registered");
            }
            return;
        }
        catch (EntryPersistenceException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.log.error("Resource isn't registered");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_ID, "Resource isn't registered");
        }
    }

    public void validateGrantType(String grantType) {
        this.log.trace("Validate grantType: {}", (Object)grantType);
        if (!GrantType.OXAUTH_UMA_TICKET.getValue().equals(grantType)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_RESOURCE_ID, "No required grant_type: " + GrantType.OXAUTH_UMA_TICKET.getValue());
        }
    }

    public List<org.gluu.oxauth.model.uma.persistence.UmaPermission> validateTicket(String ticket) {
        if (StringUtils.isBlank((String)ticket)) {
            this.log.error("Ticket is null or blank.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_TICKET, "Ticket is null or blank.");
        }
        List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions = this.permissionService.getPermissionsByTicket(ticket);
        if (permissions == null || permissions.isEmpty()) {
            this.log.error("Unable to find permissions registered for given ticket:" + ticket);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_TICKET, "Unable to find permissions registered for given ticket:" + ticket);
        }
        return permissions;
    }

    public List<org.gluu.oxauth.model.uma.persistence.UmaPermission> validateTicketWithRedirect(String ticket, String claimsRedirectUri, String state) {
        if (StringUtils.isBlank((String)ticket)) {
            this.log.error("Ticket is null or blank.");
            throw new UmaWebException(claimsRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_TICKET, state);
        }
        List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions = this.permissionService.getPermissionsByTicket(ticket);
        if (permissions == null || permissions.isEmpty()) {
            this.log.error("Unable to find permissions registered for given ticket:" + ticket);
            throw new UmaWebException(claimsRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_TICKET, state);
        }
        return permissions;
    }

    public Jwt validateClaimToken(String claimToken, String claimTokenFormat) {
        if (StringUtils.isNotBlank((String)claimToken)) {
            if (!ClaimTokenFormatType.isValueValid((String)claimTokenFormat)) {
                this.log.error("claim_token_format is unsupported. Supported format is http://openid.net/specs/openid-connect-core-1_0.html#IDToken");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN_FORMAT, "claim_token_format is unsupported. Supported format is http://openid.net/specs/openid-connect-core-1_0.html#IDToken");
            }
            try {
                Jwt idToken = Jwt.parse((String)claimToken);
                if (idToken != null) {
                    if (ServerUtil.isTrue(this.appConfiguration.getUmaValidateClaimToken()) && !this.isIdTokenValid(idToken)) {
                        this.log.error("claim_token validation failed.");
                        throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN, "claim_token validation failed.");
                    }
                    return idToken;
                }
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN, "id_tokne is null.");
            }
            catch (Exception e) {
                this.log.error("Failed to parse claim_token as valid id_token.", (Throwable)e);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN, "Failed to parse claim_token as valid id_token.");
            }
        }
        if (StringUtils.isNotBlank((String)claimTokenFormat)) {
            this.log.error("claim_token is blank but claim_token_format is not blank. Both must be blank or both must be not blank");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIM_TOKEN, "claim_token is blank but claim_token_format is not blank. Both must be blank or both must be not blank");
        }
        return null;
    }

    public boolean isIdTokenValid(Jwt idToken) {
        try {
            String issuer = idToken.getClaims().getClaimAsString("iss");
            Date expiresAt = idToken.getClaims().getClaimAsDate("exp");
            Date now = new Date();
            if (now.after(expiresAt)) {
                this.log.error("ID Token is expired. (It is after " + now + ").");
                return false;
            }
            if (!issuer.equals(this.appConfiguration.getIssuer())) {
                this.log.error("ID Token issuer is invalid. Token issuer: " + issuer + ", server issuer: " + this.appConfiguration.getIssuer());
                return false;
            }
            String kid = idToken.getHeader().getClaimAsString("kid");
            String algorithm = idToken.getHeader().getClaimAsString("alg");
            RSAPublicKey publicKey = this.getPublicKey(kid);
            if (publicKey != null) {
                RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.fromString((String)algorithm), publicKey);
                boolean signature = rsaSigner.validate(idToken);
                if (signature) {
                    this.log.debug("ID Token is successfully validated.");
                    return true;
                }
                this.log.error("ID Token signature is invalid.");
            } else {
                this.log.error("Failed to get RSA public key.");
            }
            return false;
        }
        catch (Exception e) {
            this.log.error("Failed to validate id_token. Message: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private RSAPublicKey getPublicKey(String kid) {
        JSONWebKey key = this.webKeysConfiguration.getKey(kid);
        if (key != null) {
            switch (key.getKty()) {
                case RSA: {
                    return new RSAPublicKey(key.getN(), key.getE());
                }
            }
        }
        return null;
    }

    public UmaPCT validatePct(String pctCode) {
        if (StringUtils.isNotBlank((String)pctCode)) {
            UmaPCT pct = this.pctService.getByCode(pctCode);
            if (pct != null) {
                pct.checkExpired();
                if (pct.isValid()) {
                    this.log.trace("PCT is validated successfully, pct: " + pctCode);
                    return pct;
                }
                this.log.error("PCT is not valid. Revoked: " + pct.isRevoked() + ", Expired: " + pct.isExpired() + ", pctCode: " + pctCode);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.INVALID_PCT, "PCT is not valid. Revoked: " + pct.isRevoked() + ", Expired: " + pct.isExpired() + ", pctCode: " + pctCode);
            }
            this.log.error("Failed to find PCT with pctCode: " + pctCode);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)UmaErrorResponseType.INVALID_PCT, "Failed to find PCT with pctCode: " + pctCode);
        }
        return null;
    }

    public Map<Scope, Boolean> validateScopes(String scope, List<org.gluu.oxauth.model.uma.persistence.UmaPermission> permissions, Client client) {
        Object[] scopesRequested = StringUtils.isNotBlank((String)(scope = ServerUtil.urlDecode(scope))) ? scope.split(" ") : new String[]{};
        HashMap<Scope, Boolean> result = new HashMap<Scope, Boolean>();
        if (ArrayUtils.isNotEmpty((Object[])scopesRequested)) {
            Set<String> resourceScopes = this.resourceService.getResourceScopes(permissions.stream().map(org.gluu.oxauth.model.uma.persistence.UmaPermission::getResourceId).collect(Collectors.toSet()));
            for (Object scopeId : scopesRequested) {
                Scope ldapScope = this.umaScopeService.getOrCreate(client, (String)scopeId, resourceScopes);
                if (ldapScope != null) {
                    result.put(ldapScope, true);
                    continue;
                }
                this.log.trace("Skip requested scope because it's not allowed, scope: " + (String)scopeId);
            }
        }
        for (org.gluu.oxauth.model.uma.persistence.UmaPermission permission : permissions) {
            for (Scope s : this.umaScopeService.getScopesByDns(permission.getScopeDns())) {
                result.put(s, false);
            }
        }
        if (result.isEmpty()) {
            this.log.error("There are no any scopes requested in the request.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_SCOPE, "There are no any scopes requested in give request.");
        }
        this.log.trace("CandidateGrantedScopes: " + Joiner.on((String)", ").join(Iterables.transform(result.keySet(), (Function)new Function<Scope, String>(){

            public String apply(Scope scope) {
                return scope.getId();
            }
        })));
        return result;
    }

    public void validateScopeExpression(String scopeExpression) {
        if (StringUtils.isNotBlank((String)scopeExpression) && !this.expressionService.isExpressionValid(scopeExpression)) {
            this.log.error("Scope expression is invalid. Expression: " + scopeExpression);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_SCOPE, "Scope expression is invalid. Expression: " + scopeExpression);
        }
    }

    public Client validateClientAndClaimsRedirectUri(String clientId, String claimsRedirectUri, String state) {
        if (StringUtils.isBlank((String)clientId)) {
            this.log.error("Invalid clientId: {}", (Object)clientId);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLIENT_ID, "Invalid clientId: " + clientId);
        }
        Client client = this.clientService.getClient(clientId);
        if (client == null) {
            this.log.error("Failed to find client with client_id: {}", (Object)clientId);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLIENT_ID, "Failed to find client with client_id:" + clientId);
        }
        if (StringUtils.isNotBlank((String)claimsRedirectUri)) {
            if (ArrayUtils.isEmpty((Object[])client.getClaimRedirectUris())) {
                this.log.error("Client does not have claims_redirect_uri specified, clientId: " + clientId);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIMS_REDIRECT_URI, "Client does not have claims_redirect_uri specified, clientId: " + clientId);
            }
            String equalRedirectUri = this.getEqualRedirectUri(claimsRedirectUri, client.getClaimRedirectUris());
            if (equalRedirectUri != null) {
                this.log.trace("Found match for claims_redirect_uri : " + equalRedirectUri);
                return client;
            }
            this.log.trace("Failed to find match for claims_redirect_uri : " + claimsRedirectUri + ", client claimRedirectUris: " + Arrays.toString(client.getClaimRedirectUris()));
        } else {
            this.log.trace("claims_redirect_uri is blank");
            if (client.getClaimRedirectUris() != null && client.getClaimRedirectUris().length == 1) {
                this.log.trace("claims_redirect_uri is blank and only one claims_redirect_uri is registered.");
                return client;
            }
        }
        if (StringUtils.isBlank((String)claimsRedirectUri)) {
            this.log.error("claims_redirect_uri is blank and there is none or more then one registered claims_redirect_uri for clientId: " + clientId);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_CLAIMS_REDIRECT_URI, "claims_redirect_uri is blank and there is none or more then one registered claims_redirect_uri for clientId: " + clientId);
        }
        throw new UmaWebException(claimsRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLAIMS_REDIRECT_URI, state);
    }

    private String getEqualRedirectUri(String redirectUri, String[] clientRedirectUris) {
        String redirectUriWithoutParams = RedirectionUriService.uriWithoutParams(redirectUri);
        for (String uri : clientRedirectUris) {
            this.log.debug("Comparing {} == {}", (Object)uri, (Object)redirectUri);
            if (uri.equals(redirectUri)) {
                return redirectUri;
            }
            String uriWithoutParams = RedirectionUriService.uriWithoutParams(uri);
            Map<String, String> params = RedirectionUriService.getParams(uri);
            if ((!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() != 0 || RedirectionUriService.getParams(redirectUri).size() != 0) && (!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() <= 0 || !RedirectionUriService.compareParams(redirectUri, uri))) continue;
            return redirectUri;
        }
        return null;
    }

    public String[] validatesGatheringScriptNames(String scriptNamesAsString, String claimsRedirectUri, String state) {
        Object[] scriptNames;
        if (StringUtils.isNotBlank((String)scriptNamesAsString) && ArrayUtils.isNotEmpty((Object[])(scriptNames = scriptNamesAsString.split(" ")))) {
            return scriptNames;
        }
        throw new UmaWebException(claimsRedirectUri, this.errorResponseFactory, UmaErrorResponseType.INVALID_CLAIMS_GATHERING_SCRIPT_NAME, state);
    }

    public void validateRestrictedByClient(String patClientDn, String rsId) {
        List clients;
        if (ServerUtil.isTrue(this.appConfiguration.getUmaRestrictResourceToAssociatedClient()) && !(clients = this.resourceService.getResourceById(rsId).getClients()).contains(patClientDn)) {
            this.log.error("Access to resource is denied because resource associated client does not match PAT client (it can be switched off if set umaRestrictResourceToAssociatedClient oxauth configuration property to false). Associated clients: " + clients + ", PAT client: " + patClientDn);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.ACCESS_DENIED, "Access to resource is denied because resource associated client does not match PAT client (it can be switched off if set umaRestrictResourceToAssociatedClient oxauth configuration property to false).");
        }
    }

    public void validateResource(org.gluu.oxauth.model.uma.UmaResource resource) {
        this.validateScopeExpression(resource.getScopeExpression());
        List<String> scopeDNs = this.umaScopeService.getScopeDNsByIdsAndAddToLdapIfNeeded(resource.getScopes());
        if (scopeDNs.isEmpty() && StringUtils.isBlank((String)resource.getScopeExpression())) {
            this.log.error("Invalid resource. Both `scope` and `scope_expression` are blank.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_SCOPE, "Invalid resource. Both `scope` and `scope_expression` are blank.");
        }
    }

    public Client validate(Client client) {
        if (client == null || client.isDisabled()) {
            this.log.debug("Client is not found or otherwise disabled.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.DISABLED_CLIENT, "Client is disabled.");
        }
        return client;
    }
}

