/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.common.ExecutionContext;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.UmaTokenResponse;
import org.gluu.oxauth.model.uma.persistence.UmaPermission;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.uma.authorization.Claims;
import org.gluu.oxauth.uma.authorization.UmaAuthorizationContext;
import org.gluu.oxauth.uma.authorization.UmaPCT;
import org.gluu.oxauth.uma.authorization.UmaRPT;
import org.gluu.oxauth.uma.authorization.UmaScriptByScope;
import org.gluu.oxauth.uma.service.UmaExpressionService;
import org.gluu.oxauth.uma.service.UmaNeedsInfoService;
import org.gluu.oxauth.uma.service.UmaPctService;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaRptService;
import org.gluu.oxauth.uma.service.UmaScopeService;
import org.gluu.oxauth.uma.service.UmaValidationService;
import org.gluu.oxauth.util.ServerUtil;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Named
@Stateless
public class UmaTokenService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaRptService rptService;
    @Inject
    private UmaPctService pctService;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private UmaValidationService umaValidationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaNeedsInfoService umaNeedsInfoService;
    @Inject
    private UmaExpressionService expressionService;

    public Response requestRpt(String grantType, String ticket, String claimToken, String claimTokenFormat, String pctCode, String rptCode, String scope, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            this.log.trace("requestRpt grant_type: {}, ticket: {}, claim_token: {}, claim_token_format: {}, pct: {}, rpt: {}, scope: {}", new Object[]{grantType, ticket, claimToken, claimTokenFormat, pctCode, rptCode, scope});
            this.umaValidationService.validateGrantType(grantType);
            List<UmaPermission> permissions = this.umaValidationService.validateTicket(ticket);
            Jwt idToken = this.umaValidationService.validateClaimToken(claimToken, claimTokenFormat);
            UmaPCT pct = this.umaValidationService.validatePct(pctCode);
            UmaRPT rpt = this.umaValidationService.validateRPT(rptCode);
            Client client = this.umaValidationService.validate(this.identity.getSessionClient().getClient());
            Map<Scope, Boolean> scopes = this.umaValidationService.validateScopes(scope, permissions, client);
            pct = this.pctService.updateClaims(pct, idToken, client.getClientId(), permissions);
            Claims claims = new Claims(idToken, pct, claimToken);
            Map<UmaScriptByScope, UmaAuthorizationContext> scriptMap = this.umaNeedsInfoService.checkNeedsInfo(claims, scopes, permissions, pct, httpRequest, client);
            if (!scriptMap.isEmpty()) {
                this.expressionService.evaluate(scriptMap, permissions);
            } else {
                this.log.warn("There are no any policies that protects scopes. Scopes: " + UmaScopeService.asString(scopes.keySet()) + ". Configuration property umaGrantAccessIfNoPolicies: " + this.appConfiguration.getUmaGrantAccessIfNoPolicies());
                if (this.appConfiguration.getUmaGrantAccessIfNoPolicies() != null && this.appConfiguration.getUmaGrantAccessIfNoPolicies().booleanValue()) {
                    this.log.warn("Access granted because there are no any protection. Make sure it is intentional behavior.");
                } else {
                    this.log.warn("Access denied because there are no any protection. Make sure it is intentional behavior.");
                    throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)UmaErrorResponseType.FORBIDDEN_BY_POLICY, "Access denied because there are no any protection. Make sure it is intentional behavior.");
                }
            }
            this.log.trace("Access granted.");
            this.updatePermissionsWithClientRequestedScope(permissions, scopes);
            this.addPctToPermissions(permissions, pct);
            boolean upgraded = false;
            if (rpt == null) {
                ExecutionContext executionContext = new ExecutionContext(httpRequest, httpResponse);
                executionContext.setClient(client);
                rpt = this.rptService.createRPTAndPersist(executionContext, permissions);
                rptCode = rpt.getNotHashedCode();
            } else if (this.rptService.addPermissionToRPT(rpt, permissions)) {
                upgraded = true;
            }
            UmaTokenResponse response = new UmaTokenResponse();
            response.setAccessToken(rptCode);
            response.setUpgraded(Boolean.valueOf(upgraded));
            response.setTokenType("Bearer");
            response.setPct(pct.getCode());
            return Response.ok((Object)ServerUtil.asJson(response)).build();
        }
        catch (Exception ex) {
            this.log.error("Exception happened", (Throwable)ex);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            this.log.error("Failed to handle request to UMA Token Endpoint.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Failed to handle request to UMA Token Endpoint.");
        }
    }

    private void addPctToPermissions(List<UmaPermission> permissions, UmaPCT pct) {
        for (UmaPermission p : permissions) {
            p.getAttributes().put("pct", pct.getCode());
            this.permissionService.mergeSilently(p);
        }
    }

    private void updatePermissionsWithClientRequestedScope(List<UmaPermission> permissions, Map<Scope, Boolean> scopes) {
        this.log.trace("Updating permissions with requested scopes ...");
        for (UmaPermission permission : permissions) {
            HashSet<String> scopeDns = new HashSet<String>(permission.getScopeDns());
            for (Map.Entry<Scope, Boolean> entry : scopes.entrySet()) {
                this.log.trace("Updating permissions with scope: " + entry.getKey().getId() + ", isRequestedScope: " + entry.getValue() + ", permisson: " + permission.getDn());
                scopeDns.add(entry.getKey().getDn());
            }
            permission.setScopeDns(new ArrayList(scopeDns));
        }
    }
}

