/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.persistence.UmaResource;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.service.CacheService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaResourceService {
    private static final int RESOURCE_CACHE_EXPIRATION_IN_SECONDS = 120;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private CacheService cacheService;

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("resources");
        branch.setDn(this.getDnForResource(null));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addResource(UmaResource resource) {
        this.validate(resource);
        this.ldapEntryManager.persist((Object)resource);
    }

    public void validate(UmaResource resource) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)resource.getName()), (Object)"Name is required for resource.");
        Preconditions.checkArgument((resource.getScopes() != null && !resource.getScopes().isEmpty() || StringUtils.isNotBlank((String)resource.getScopeExpression()) ? 1 : 0) != 0, (Object)"Scope must be specified for resource.");
        Preconditions.checkState((!resource.isExpired() ? 1 : 0) != 0, (Object)"UMA Resource expired. It must not be expired.");
        this.prepareBranch();
    }

    public void updateResource(UmaResource resource) {
        this.updateResource(resource, false);
    }

    public void updateResource(UmaResource resource, boolean skipValidation) {
        if (!skipValidation) {
            this.validate(resource);
        }
        this.cacheService.put(resource.getDn(), (Object)resource);
        this.ldapEntryManager.merge((Object)resource);
    }

    public void remove(UmaResource resource) {
        this.ldapEntryManager.remove((Object)resource);
    }

    public void remove(String rsid) {
        this.ldapEntryManager.remove((Object)this.getResourceById(rsid));
    }

    public void remove(List<UmaResource> resources) {
        for (UmaResource resource : resources) {
            this.remove(resource);
        }
    }

    public List<UmaResource> getResourcesByAssociatedClient(String associatedClientDn) {
        try {
            this.prepareBranch();
            if (StringUtils.isNotBlank((String)associatedClientDn)) {
                Filter filter = Filter.createEqualityFilter((String)"oxAssociatedClient", (Object)associatedClientDn);
                return this.ldapEntryManager.findEntries(this.getBaseDnForResource(), UmaResource.class, filter);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public Set<UmaResource> getResources(Set<String> ids) {
        HashSet<UmaResource> result = new HashSet<UmaResource>();
        if (ids != null) {
            for (String id : ids) {
                UmaResource resource = this.getResourceById(id);
                if (resource != null) {
                    result.add(resource);
                    continue;
                }
                this.log.error("Failed to find resource by id: " + id);
            }
        }
        return result;
    }

    public UmaResource getResourceById(String id) {
        this.prepareBranch();
        try {
            String key = this.getDnForResource(id);
            UmaResource resource = (UmaResource)this.cacheService.getWithPut(key, () -> (UmaResource)this.ldapEntryManager.find(UmaResource.class, (Object)key), 120);
            if (resource != null) {
                return resource;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to find resource set with id: " + id, (Throwable)e);
        }
        this.log.error("Failed to find resource set with id: " + id);
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.NOT_FOUND, (IErrorType)UmaErrorResponseType.NOT_FOUND, "Failed to find resource set with id: " + id);
    }

    public Set<String> getResourceScopes(Set<String> resourceIds) {
        HashSet result = Sets.newHashSet();
        for (String resourceId : resourceIds) {
            result.addAll(this.getResourceById(resourceId).getScopes());
        }
        return result;
    }

    private void prepareBranch() {
        if (!this.ldapEntryManager.hasBranchesSupport(this.getDnForResource(null))) {
            return;
        }
        if (!this.ldapEntryManager.contains(this.getDnForResource(null), SimpleBranch.class)) {
            this.addBranch();
        }
    }

    public String getDnForResource(String oxId) {
        if (StringHelper.isEmpty((String)oxId)) {
            return this.getBaseDnForResource();
        }
        return String.format("oxId=%s,%s", oxId, this.getBaseDnForResource());
    }

    public String getBaseDnForResource() {
        String umaBaseDn = this.staticConfiguration.getBaseDn().getUmaBase();
        return String.format("ou=resources,%s", umaBaseDn);
    }
}

