/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.uma.ClaimDefinition;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.uma.UmaNeedInfoResponse;
import org.gluu.oxauth.model.uma.persistence.UmaPermission;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.oxauth.service.external.ExternalUmaRptPolicyService;
import org.gluu.oxauth.uma.authorization.Claims;
import org.gluu.oxauth.uma.authorization.UmaAuthorizationContext;
import org.gluu.oxauth.uma.authorization.UmaAuthorizationContextBuilder;
import org.gluu.oxauth.uma.authorization.UmaPCT;
import org.gluu.oxauth.uma.authorization.UmaScriptByScope;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaResourceService;
import org.gluu.oxauth.uma.service.UmaSessionService;
import org.gluu.oxauth.util.ServerUtil;
import org.oxauth.persistence.model.Scope;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaNeedsInfoService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private ExternalUmaRptPolicyService policyService;
    @Inject
    private UmaSessionService sessionService;
    @Inject
    private UserService userService;

    public Map<UmaScriptByScope, UmaAuthorizationContext> checkNeedsInfo(Claims claims, Map<Scope, Boolean> requestedScopes, List<UmaPermission> permissions, UmaPCT pct, HttpServletRequest httpRequest, Client client) {
        HashMap<UmaScriptByScope, UmaAuthorizationContext> scriptMap = new HashMap<UmaScriptByScope, UmaAuthorizationContext>();
        HashMap<String, String> ticketAttributes = new HashMap<String, String>();
        ArrayList<ClaimDefinition> missedClaims = new ArrayList<ClaimDefinition>();
        UmaAuthorizationContextBuilder contextBuilder = new UmaAuthorizationContextBuilder(this.appConfiguration, this.attributeService, this.resourceService, permissions, requestedScopes, claims, httpRequest, this.sessionService, this.userService, this.permissionService, client);
        for (Scope scope : requestedScopes.keySet()) {
            List authorizationPolicies = scope.getUmaAuthorizationPolicies();
            if (authorizationPolicies != null && !authorizationPolicies.isEmpty()) {
                for (String scriptDN : authorizationPolicies) {
                    CustomScriptConfiguration script = this.policyService.getScriptByDn(scriptDN);
                    if (script != null) {
                        String claimsGatheringScriptName;
                        UmaAuthorizationContext context = contextBuilder.build(script);
                        scriptMap.put(new UmaScriptByScope(scope, script), context);
                        List<ClaimDefinition> requiredClaims = this.policyService.getRequiredClaims(script, context);
                        if (requiredClaims != null && !requiredClaims.isEmpty()) {
                            for (ClaimDefinition definition : requiredClaims) {
                                if (claims.has(definition.getName())) continue;
                                missedClaims.add(definition);
                            }
                        }
                        if (StringUtils.isNotBlank((String)(claimsGatheringScriptName = this.policyService.getClaimsGatheringScriptName(script, context)))) {
                            ticketAttributes.put("gathering_id", this.constructGatheringScriptNameValue((String)ticketAttributes.get("gathering_id"), claimsGatheringScriptName));
                            continue;
                        }
                        this.log.debug("External 'getClaimsGatheringScriptName' script method return null or blank value, script: " + script.getName());
                        continue;
                    }
                    this.log.error("Unable to load UMA script dn: '{}'", (Object)scriptDN);
                }
                continue;
            }
            this.log.trace("No policies defined for scope: " + scope.getId() + ", scopeDn: " + scope.getDn());
        }
        if (!missedClaims.isEmpty()) {
            ticketAttributes.put("pct", pct.getCode());
            String newTicket = this.permissionService.changeTicket(permissions, ticketAttributes);
            UmaNeedInfoResponse needInfoResponse = new UmaNeedInfoResponse();
            needInfoResponse.setTicket(newTicket);
            needInfoResponse.setError("need_info");
            needInfoResponse.setRedirectUser(this.buildClaimsGatheringRedirectUri(scriptMap.values(), client, newTicket));
            needInfoResponse.setRequiredClaims(missedClaims);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ServerUtil.asJsonSilently(needInfoResponse)).build());
        }
        return scriptMap;
    }

    private String constructGatheringScriptNameValue(String existingValue, String claimsGatheringScriptName) {
        if (StringUtils.isBlank((String)existingValue)) {
            return claimsGatheringScriptName;
        }
        return existingValue + " " + claimsGatheringScriptName;
    }

    private String buildClaimsGatheringRedirectUri(Collection<UmaAuthorizationContext> contexts, Client client, String newTicket) {
        String queryParameters = "";
        for (UmaAuthorizationContext context : contexts) {
            queryParameters = queryParameters + context.getRedirectUserParameters().buildQueryString() + "&";
        }
        queryParameters = StringUtils.removeEnd((String)queryParameters, (String)"&");
        String result = this.appConfiguration.getBaseEndpoint() + "/uma/gather_claims";
        if (StringUtils.isNotBlank((String)queryParameters)) {
            result = result + "?" + queryParameters;
        }
        result = result + "&client_id=" + client.getClientId() + "&ticket=" + newTicket;
        return result;
    }

    public static Set<String> getScriptDNs(List<Scope> scopes) {
        HashSet<String> result = new HashSet<String>();
        for (Scope scope : scopes) {
            List authorizationPolicies = scope.getUmaAuthorizationPolicies();
            if (authorizationPolicies == null) continue;
            result.addAll(authorizationPolicies);
        }
        return result;
    }
}

