/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectParameters.class);
    private final Map<String, Set<String>> map = new HashMap<String, Set<String>>();

    public void add(String paramName, String paramValue) {
        Set<String> valueSet = this.map.get(paramName);
        if (valueSet != null) {
            valueSet.add(paramValue);
        } else {
            HashSet<String> value = new HashSet<String>();
            value.add(paramValue);
            this.map.put(paramName, value);
        }
    }

    public void remove(String paramName) {
        this.map.remove(paramName);
    }

    public Map<String, Set<String>> map() {
        return this.map;
    }

    public String buildQueryString() {
        String queryString = "";
        for (Map.Entry<String, Set<String>> param : this.map.entrySet()) {
            Set<String> values = param.getValue();
            if (!StringUtils.isNotBlank((String)param.getKey()) || values == null || values.isEmpty()) continue;
            for (String value : values) {
                if (!StringUtils.isNotBlank((String)value)) continue;
                try {
                    queryString = queryString + param.getKey() + "=" + URLEncoder.encode(value, "UTF-8") + "&";
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("Failed to encode value: " + value, (Throwable)e);
                }
            }
        }
        queryString = StringUtils.removeEnd((String)queryString, (String)"&");
        return queryString;
    }
}

