/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.authorization;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataEntry
@ObjectClass(value="oxAuthUmaPCT")
public class UmaPCT
extends AbstractToken {
    private static final Logger log = LoggerFactory.getLogger(UmaPCT.class);
    @DN
    private String dn;
    @AttributeName(name="clnId")
    private String clientId;
    @AttributeName(name="oxClaimValues")
    private String claimValuesAsJson;

    public UmaPCT() {
        super(2592000);
    }

    public UmaPCT(int lifeTime) {
        super(lifeTime);
    }

    protected UmaPCT(String code, Date creationDate, Date expirationDate) {
        super(code, creationDate, expirationDate);
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClaimValuesAsJson() {
        return this.claimValuesAsJson;
    }

    public void setClaimValuesAsJson(String claimValuesAsJson) {
        this.claimValuesAsJson = claimValuesAsJson;
    }

    public JwtClaims getClaims() {
        try {
            return StringUtils.isNotBlank((String)this.claimValuesAsJson) ? new JwtClaims(new JSONObject(this.claimValuesAsJson)) : new JwtClaims();
        }
        catch (Exception e) {
            log.error("Failed to parse PCT claims. " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setClaims(JwtClaims claims) throws InvalidJwtException {
        this.claimValuesAsJson = claims != null ? claims.toJsonString() : null;
    }
}

