/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.session.ws.rs;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Path(value="/")
public class CheckSessionStatusRestWebServiceImpl {
    @Inject
    private Logger log;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;

    @GET
    @Path(value="/session_status")
    @Produces(value={"application/json"})
    public Response requestCheckSessionStatus(@Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse, @Context SecurityContext securityContext) throws IOException {
        String sessionIdCookie = this.cookieService.getSessionIdFromCookie(httpRequest);
        this.log.debug("Found session '{}' cookie: '{}'", (Object)"session_id", (Object)sessionIdCookie);
        CheckSessionResponse response = new CheckSessionResponse("unknown", "");
        SessionId sessionId = this.sessionIdService.getSessionId(sessionIdCookie);
        if (sessionId != null) {
            response.setState(sessionId.getState().getValue());
            response.setAuthTime(sessionId.getAuthenticationTime());
            String sessionCustomState = sessionId.getSessionAttributes().get("session_custom_state");
            if (StringHelper.isNotEmpty((String)sessionCustomState)) {
                response.setCustomState(sessionCustomState);
            }
        }
        String responseJson = ServerUtil.asJson(response);
        this.log.debug("Check session status response: '{}'", (Object)responseJson);
        return Response.ok().type("application/json").entity((Object)responseJson).build();
    }

    class CheckSessionResponse {
        @JsonProperty(value="state")
        String state;
        @JsonProperty(value="custom_state")
        String customState;
        @JsonProperty(value="auth_time")
        Date authTime;

        public CheckSessionResponse(String state, String stateExt) {
            this.state = state;
            this.customState = stateExt;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getCustomState() {
            return this.customState;
        }

        public void setCustomState(String customState) {
            this.customState = customState;
        }

        public Date getAuthTime() {
            return this.authTime;
        }

        public void setAuthTime(Date authTime) {
            this.authTime = authTime;
        }
    }
}

