/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.net;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.gluu.net.SslDefaultHttpClient;
import org.gluu.oxauth.model.net.HttpServiceResponse;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class HttpService
implements Serializable {
    private static final long serialVersionUID = -2398422090669045605L;
    @Inject
    private Logger log;
    private Base64 base64;

    @PostConstruct
    public void init() {
        this.base64 = new Base64();
    }

    public HttpClient getHttpsClientTrustAll() {
        try {
            SSLSocketFactory sf = new SSLSocketFactory(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }, (X509HostnameVerifier)new AllowAllHostnameVerifier());
            PlainSocketFactory psf = PlainSocketFactory.getSocketFactory();
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, (SchemeSocketFactory)psf));
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)sf));
            PoolingClientConnectionManager ccm = new PoolingClientConnectionManager(registry);
            return new DefaultHttpClient((ClientConnectionManager)ccm);
        }
        catch (Exception ex) {
            this.log.error("Failed to create TrustAll https client", (Throwable)ex);
            return new DefaultHttpClient();
        }
    }

    public HttpClient getHttpsClient() {
        SslDefaultHttpClient httpClient = new SslDefaultHttpClient();
        return httpClient;
    }

    public HttpClient getHttpsClient(String trustStoreType, String trustStorePath, String trustStorePassword) {
        SslDefaultHttpClient httpClient = new SslDefaultHttpClient(trustStoreType, trustStorePath, trustStorePassword);
        return httpClient;
    }

    public HttpClient getHttpsClient(String trustStoreType, String trustStorePath, String trustStorePassword, String keyStoreType, String keyStorePath, String keyStorePassword) {
        SslDefaultHttpClient httpClient = new SslDefaultHttpClient(trustStoreType, trustStorePath, trustStorePassword, keyStoreType, keyStorePath, keyStorePassword);
        return httpClient;
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authData, Map<String, String> headers, String postData, ContentType contentType) {
        HttpPost httpPost = new HttpPost(uri);
        if (StringHelper.isNotEmpty((String)authData)) {
            httpPost.setHeader("Authorization", "Basic " + authData);
        }
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                httpPost.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        StringEntity stringEntity = new StringEntity(postData, contentType);
        httpPost.setEntity((HttpEntity)stringEntity);
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            return new HttpServiceResponse((HttpRequestBase)httpPost, httpResponse);
        }
        catch (IOException ex) {
            this.log.error("Failed to execute post request", (Throwable)ex);
            return null;
        }
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authData, Map<String, String> headers, String postData) {
        return this.executePost(httpClient, uri, authData, headers, postData, null);
    }

    public HttpServiceResponse executePost(HttpClient httpClient, String uri, String authData, String postData, ContentType contentType) {
        return this.executePost(httpClient, uri, authData, null, postData, contentType);
    }

    public String encodeBase64(String value) {
        try {
            return new String(this.base64.encode(value.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.log.error("Failed to convert '{}' to base64", (Object)value, (Object)ex);
            return null;
        }
    }

    public String encodeUrl(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.log.error("Failed to encode url '{}'", (Object)value, (Object)ex);
            return null;
        }
    }

    public HttpServiceResponse executeGet(HttpClient httpClient, String requestUri, Map<String, String> headers) {
        HttpGet httpGet = new HttpGet(requestUri);
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                httpGet.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            return new HttpServiceResponse((HttpRequestBase)httpGet, httpResponse);
        }
        catch (IOException ex) {
            this.log.error("Failed to execute get request", (Throwable)ex);
            return null;
        }
    }

    public HttpServiceResponse executeGet(HttpClient httpClient, String requestUri) throws ClientProtocolException, IOException {
        return this.executeGet(httpClient, requestUri, null);
    }

    public byte[] getResponseContent(HttpResponse httpResponse) throws IOException {
        if (httpResponse == null || httpResponse.getStatusLine().getStatusCode() != 200) {
            return null;
        }
        HttpEntity entity = httpResponse.getEntity();
        byte[] responseBytes = new byte[]{};
        if (entity != null) {
            responseBytes = EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (entity != null) {
            EntityUtils.consume((HttpEntity)entity);
        }
        return responseBytes;
    }

    public void consume(HttpResponse httpResponse) throws IOException {
        if (httpResponse == null || httpResponse.getStatusLine().getStatusCode() != 200) {
            return;
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    public String convertEntityToString(byte[] responseBytes) {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes);
    }

    public String convertEntityToString(byte[] responseBytes, Charset charset) {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes, charset);
    }

    public String convertEntityToString(byte[] responseBytes, String charsetName) throws UnsupportedEncodingException {
        if (responseBytes == null) {
            return null;
        }
        return new String(responseBytes, charsetName);
    }

    public boolean isResponseStastusCodeOk(HttpResponse httpResponse) {
        int responseStastusCode = httpResponse.getStatusLine().getStatusCode();
        return responseStastusCode == 200;
    }

    public boolean isContentTypeXml(HttpResponse httpResponse) {
        Header contentType = httpResponse.getEntity().getContentType();
        if (contentType == null) {
            return false;
        }
        String contentTypeValue = contentType.getValue();
        return StringHelper.equals((String)contentTypeValue, (String)ContentType.APPLICATION_XML.getMimeType()) || StringHelper.equals((String)contentTypeValue, (String)ContentType.TEXT_XML.getMimeType());
    }

    public String constructServerUrl(HttpServletRequest request) {
        int serverPort = request.getServerPort();
        String redirectUrl = serverPort == 80 || serverPort == 443 ? String.format("%s://%s%s", request.getScheme(), request.getServerName(), request.getContextPath()) : String.format("%s://%s:%s%s", request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
        return redirectUrl.toLowerCase();
    }
}

