/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external.context;

import java.util.ArrayList;
import java.util.List;
import org.gluu.oxauth.model.common.IAuthorizationGrant;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.service.external.context.ExternalScriptContext;
import org.oxauth.persistence.model.Scope;

public class DynamicScopeExternalContext
extends ExternalScriptContext {
    private List<Scope> dynamicScopes;
    private JsonWebResponse jsonWebResponse;
    private IAuthorizationGrant authorizationGrant;

    public DynamicScopeExternalContext(List<Scope> dynamicScopes, JsonWebResponse jsonWebResponse, IAuthorizationGrant authorizationGrant) {
        super(null);
        this.dynamicScopes = dynamicScopes;
        this.jsonWebResponse = jsonWebResponse;
        this.authorizationGrant = authorizationGrant;
    }

    public List<String> getDynamicScopes() {
        ArrayList<String> scopes = new ArrayList<String>();
        if (this.dynamicScopes != null) {
            for (Scope scope : this.dynamicScopes) {
                scopes.add(scope.getId());
            }
        }
        return scopes;
    }

    public List<Scope> getScopes() {
        return this.dynamicScopes;
    }

    public JsonWebResponse getJsonWebResponse() {
        return this.jsonWebResponse;
    }

    public IAuthorizationGrant getAuthorizationGrant() {
        return this.authorizationGrant;
    }

    public User getUser() {
        return this.authorizationGrant.getUser();
    }
}

