/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.uma.UmaRptPolicyType;
import org.gluu.model.uma.ClaimDefinition;
import org.gluu.oxauth.uma.authorization.UmaAuthorizationContext;
import org.gluu.service.LookupService;
import org.gluu.service.custom.script.CustomScriptManager;
import org.gluu.service.custom.script.ExternalScriptService;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalUmaRptPolicyService
extends ExternalScriptService {
    private static final long serialVersionUID = -8609727759114795435L;
    public static final boolean HOTSWAP_UMA_SCRIPT = Boolean.parseBoolean(System.getProperty("uma.hotswap.script"));
    @Inject
    private Logger log;
    @Inject
    private LookupService lookupService;
    @Inject
    private CustomScriptManager scriptManager;
    protected Map<String, CustomScriptConfiguration> scriptInumMap;

    public ExternalUmaRptPolicyService() {
        super(CustomScriptType.UMA_RPT_POLICY);
    }

    protected void reloadExternal() {
        this.scriptInumMap = this.buildExternalConfigurationsInumMap(this.customScriptConfigurations);
    }

    private Map<String, CustomScriptConfiguration> buildExternalConfigurationsInumMap(List<CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<String, CustomScriptConfiguration> reloadedExternalConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations.size());
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations) {
            reloadedExternalConfigurations.put(customScriptConfiguration.getInum(), customScriptConfiguration);
        }
        return reloadedExternalConfigurations;
    }

    public CustomScriptConfiguration getScriptByDn(String scriptDn) {
        String authorizationPolicyInum = this.lookupService.getInumFromDn(scriptDn);
        return this.getScriptByInum(authorizationPolicyInum);
    }

    public CustomScriptConfiguration getScriptByInum(String inum) {
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        return this.scriptInumMap.get(inum);
    }

    private UmaRptPolicyType policyScript(CustomScriptConfiguration script) {
        return HOTSWAP_UMA_SCRIPT ? (UmaRptPolicyType)ExternalUmaRptPolicyService.hotswap(this.scriptManager, script, true) : (UmaRptPolicyType)script.getExternalType();
    }

    public boolean authorize(CustomScriptConfiguration script, UmaAuthorizationContext context) {
        try {
            this.log.debug("Executing python 'authorize' method, script: " + script.getName());
            boolean result = this.policyScript(script).authorize((Object)context);
            this.log.debug("python 'authorize' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'authorize' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public List<ClaimDefinition> getRequiredClaims(CustomScriptConfiguration script, UmaAuthorizationContext context) {
        try {
            this.log.debug("Executing python 'getRequiredClaims' method, script: " + script.getName());
            List result = this.policyScript(script).getRequiredClaims((Object)context);
            this.log.debug("python 'getRequiredClaims' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getRequiredClaims' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return new ArrayList<ClaimDefinition>();
        }
    }

    public String getClaimsGatheringScriptName(CustomScriptConfiguration script, UmaAuthorizationContext context) {
        try {
            this.log.debug("Executing python 'getClaimsGatheringScriptName' method, script: " + script.getName());
            String result = this.policyScript(script).getClaimsGatheringScriptName((Object)context);
            this.log.debug("python 'getClaimsGatheringScriptName' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getClaimsGatheringScriptName' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return "";
        }
    }

    public static <T> T hotswap(CustomScriptManager scriptManager, CustomScriptConfiguration script, boolean rptPolicyScript) {
        if (!HOTSWAP_UMA_SCRIPT) {
            throw new RuntimeException("UMA script hotswap is not allowed");
        }
        String scriptPath = rptPolicyScript ? System.getProperty("uma.hotswap.rpt_policy_script.path") : System.getProperty("uma.hotswap.claims_gathering_script.path");
        try {
            String scriptCode = FileUtils.readFileToString((File)new File(scriptPath));
            script.getCustomScript().setScript(scriptCode);
            return (T)scriptManager.createExternalTypeFromStringWithPythonException(script.getCustomScript(), script.getConfigurationAttributes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

