/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.spontaneous.SpontaneousScopeType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.external.context.SpontaneousScopeExternalContext;
import org.gluu.service.custom.script.ExternalScriptService;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalSpontaneousScopeService
extends ExternalScriptService {
    public ExternalSpontaneousScopeService() {
        super(CustomScriptType.SPONTANEOUS_SCOPE);
    }

    public void executeExternalManipulateScope(SpontaneousScopeExternalContext context) {
        for (CustomScriptConfiguration script : this.getScriptsToExecute(context.getClient())) {
            this.executeExternalManipulateScope(script, context);
            this.log.debug("GrantedScopes {} after execution of interception script {}.", context.getGrantedScopes(), (Object)script.getName());
        }
    }

    private void executeExternalManipulateScope(CustomScriptConfiguration scriptConfiguration, SpontaneousScopeExternalContext context) {
        try {
            this.log.debug("Executing external 'executeExternalManipulateScope' method, script name: {}, grantedScopes: {} , context: {}", new Object[]{scriptConfiguration.getName(), context.getGrantedScopes(), context});
            SpontaneousScopeType script = (SpontaneousScopeType)scriptConfiguration.getExternalType();
            script.manipulateScopes((Object)context);
            this.log.debug("Finished external 'executeExternalManipulateScope' method, script name: {}, grantedScopes: {} , context: {}", new Object[]{scriptConfiguration.getName(), context.getGrantedScopes(), context});
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
        }
    }

    private Set<CustomScriptConfiguration> getScriptsToExecute(Client client) {
        HashSet result = Sets.newHashSet();
        if (this.customScriptConfigurations == null) {
            return result;
        }
        List scriptDns = client.getAttributes().getSpontaneousScopeScriptDns();
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (!scriptDns.contains(script.getCustomScript().getDn())) continue;
            result.add(script);
        }
        return result;
    }
}

