/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.revoke.RevokeTokenType;
import org.gluu.oxauth.service.external.context.RevokeTokenContext;
import org.gluu.service.custom.script.ExternalScriptService;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalRevokeTokenService
extends ExternalScriptService {
    @Inject
    private Logger log;

    public ExternalRevokeTokenService() {
        super(CustomScriptType.REVOKE_TOKEN);
    }

    public boolean revokeToken(CustomScriptConfiguration script, RevokeTokenContext context) {
        try {
            this.log.trace("Executing python 'revokeToken' method, context: {}", (Object)context);
            context.setScript(script);
            RevokeTokenType revokeTokenType = (RevokeTokenType)script.getExternalType();
            boolean result = revokeTokenType.revoke((Object)context);
            this.log.trace("Finished 'revokeToken' method, result: {}, context: {}", (Object)result, (Object)context);
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public boolean revokeTokenMethods(RevokeTokenContext context) {
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (script.getExternalType().getApiVersion() <= 1 || this.revokeToken(script, context)) continue;
            return false;
        }
        return true;
    }
}

