/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.ciba;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.ciba.CIBAPingCallbackService;
import org.gluu.oxauth.ciba.CIBAPushErrorService;
import org.gluu.oxauth.model.ciba.PushErrorResponseType;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.CibaRequestCacheControl;
import org.gluu.oxauth.model.common.CibaRequestStatus;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.ldap.CIBARequest;
import org.gluu.oxauth.service.ciba.CibaRequestService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.CibaRequestsProcessorEvent;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class CibaRequestsProcessorJob {
    public static final int CHUNK_SIZE = 500;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Event<TimerEvent> processorEvent;
    @Inject
    private CIBAPushErrorService cibaPushErrorService;
    @Inject
    private CIBAPingCallbackService cibaPingCallbackService;
    @Inject
    private CibaRequestService cibaRequestService;
    private long lastFinishedTime;
    private AtomicBoolean isActive;
    private ExecutorService executorService;

    public void initTimer() {
        this.log.debug("Initializing CIBA requests processor");
        this.isActive = new AtomicBoolean(false);
        int intervalSec = this.appConfiguration.getBackchannelRequestsProcessorJobIntervalSec();
        this.processorEvent.fire((Object)new TimerEvent(new TimerSchedule(intervalSec, intervalSec), (Object)new CibaRequestsProcessorEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
        this.executorService = Executors.newCachedThreadPool(ServerUtil.daemonThreadFactory());
    }

    @Asynchronous
    public void process(@Observes @Scheduled CibaRequestsProcessorEvent cibaRequestsProcessorEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.jobIsFree()) {
                this.processImpl();
                this.lastFinishedTime = System.currentTimeMillis();
            } else {
                this.log.trace("Starting conditions aren't reached for CIBA requestes processor");
            }
        }
        finally {
            this.isActive.set(false);
        }
    }

    private boolean jobIsFree() {
        int interval = this.appConfiguration.getBackchannelRequestsProcessorJobIntervalSec();
        if (interval < 0) {
            this.log.info("CIBA Requests processor timer is disabled.");
            this.log.warn("CIBA Requests processor timer Interval (cleanServiceInterval in oxauth configuration) is negative which turns OFF internal clean up by the server. Please set it to positive value if you wish internal CIBA Requests processor up timer run.");
            return false;
        }
        long timeDiffrence = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDiffrence >= (long)(interval * 1000);
    }

    public void processImpl() {
        try {
            int chunkSize = this.appConfiguration.getBackchannelRequestsProcessorJobChunkSize() <= 0 ? 500 : this.appConfiguration.getBackchannelRequestsProcessorJobChunkSize();
            List<CIBARequest> expiredRequests = this.cibaRequestService.loadExpiredByStatus(CibaRequestStatus.PENDING, chunkSize);
            expiredRequests.forEach(cibaRequest -> this.cibaRequestService.updateStatus((CIBARequest)cibaRequest, CibaRequestStatus.IN_PROCESS));
            for (CIBARequest expiredRequest : expiredRequests) {
                CibaRequestCacheControl cibaRequest2 = this.cibaRequestService.getCibaRequest(expiredRequest.getAuthReqId());
                if (cibaRequest2 != null) {
                    this.executorService.execute(() -> this.processExpiredRequest(cibaRequest2, expiredRequest.getAuthReqId()));
                }
                this.cibaRequestService.removeCibaRequest(expiredRequest);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to process CIBA request from cache.", (Throwable)e);
        }
    }

    private void processExpiredRequest(CibaRequestCacheControl cibaRequest, String authReqId) {
        if (cibaRequest.getStatus() != CibaRequestStatus.PENDING && cibaRequest.getStatus() != CibaRequestStatus.EXPIRED) {
            return;
        }
        this.log.info("Authentication request id {} has expired", (Object)authReqId);
        this.cibaRequestService.removeCibaCacheRequest(cibaRequest.cacheKey());
        if (cibaRequest.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH) {
            this.cibaPushErrorService.pushError(cibaRequest.getAuthReqId(), cibaRequest.getClient().getBackchannelClientNotificationEndpoint(), cibaRequest.getClientNotificationToken(), PushErrorResponseType.EXPIRED_TOKEN, "Request has expired and there was no answer from the end user.");
        } else if (cibaRequest.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PING) {
            this.cibaPingCallbackService.pingCallback(cibaRequest.getAuthReqId(), cibaRequest.getClient().getBackchannelClientNotificationEndpoint(), cibaRequest.getClientNotificationToken());
        }
    }
}

