/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistrationStatus;
import org.gluu.persist.model.base.CustomEntry;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.service.net.NetworkService;
import org.gluu.util.StringHelper;

@ApplicationScoped
public class UserService
extends org.gluu.oxauth.service.common.UserService {
    public static final String[] USER_OBJECT_CLASSES = new String[]{"gluuPerson"};
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private NetworkService networkService;

    protected List<String> getPersonCustomObjectClassList() {
        return this.appConfiguration.getPersonCustomObjectClassList();
    }

    protected String getPeopleBaseDn() {
        return this.staticConfiguration.getBaseDn().getPeople();
    }

    public long countFido2RegisteredDevices(String username) {
        String userInum = this.getUserInum(username);
        if (userInum == null) {
            return 0L;
        }
        String baseDn = this.getBaseDnForFido2RegistrationEntries(userInum);
        if (this.persistenceEntryManager.hasBranchesSupport(baseDn) && !this.persistenceEntryManager.contains(baseDn, SimpleBranch.class)) {
            return 0L;
        }
        Filter userInumFilter = Filter.createEqualityFilter((String)"personInum", (Object)userInum);
        Filter registeredFilter = Filter.createEqualityFilter((String)"oxStatus", (Object)"registered");
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{userInumFilter, registeredFilter});
        long countEntries = this.persistenceEntryManager.countEntries(baseDn, CustomEntry.class, filter);
        return countEntries;
    }

    public long countFidoRegisteredDevices(String username, String domain) {
        String userInum = this.getUserInum(username);
        if (userInum == null) {
            return 0L;
        }
        String baseDn = this.getBaseDnForFidoDevices(userInum);
        if (this.persistenceEntryManager.hasBranchesSupport(baseDn) && !this.persistenceEntryManager.contains(baseDn, SimpleBranch.class)) {
            return 0L;
        }
        Filter resultFilter = Filter.createEqualityFilter((String)"oxStatus", (Object)DeviceRegistrationStatus.ACTIVE.getValue());
        List fidoRegistrations = this.persistenceEntryManager.findEntries(baseDn, DeviceRegistration.class, resultFilter);
        if (StringUtils.isEmpty((String)domain)) {
            return fidoRegistrations.size();
        }
        long deviceCount = fidoRegistrations.parallelStream().filter(f -> StringHelper.equals((String)domain, (String)this.networkService.getHost(f.getApplication()))).count();
        return deviceCount;
    }

    public long countFidoAndFido2Devices(String username, String domain) {
        return this.countFidoRegisteredDevices(username, domain) + this.countFido2RegisteredDevices(username);
    }

    public String getBaseDnForFido2RegistrationEntries(String userInum) {
        String userBaseDn = this.getDnForUser(userInum);
        return String.format("ou=fido2_register,%s", userBaseDn);
    }

    public String getBaseDnForFidoDevices(String userInum) {
        String userBaseDn = this.getDnForUser(userInum);
        return String.format("ou=fido,%s", userBaseDn);
    }
}

