/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.EndSessionErrorResponseType;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.LocalResponseCache;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.slf4j.Logger;

@Stateless
@Named
public class RedirectionUriService {
    @Inject
    private Logger log;
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private LocalResponseCache localResponseCache;

    public String validateRedirectionUri(String clientIdentifier, String redirectionUri) {
        Client client = this.clientService.getClient(clientIdentifier);
        if (client == null) {
            return null;
        }
        return this.validateRedirectionUri(client, redirectionUri);
    }

    public List<String> getSectorRedirectUris(String sectorIdentiferUri) throws Exception {
        ArrayList result = Lists.newArrayList();
        if (StringUtils.isBlank((String)sectorIdentiferUri)) {
            return result;
        }
        List<String> sectorRedirectUris = this.localResponseCache.getSectorRedirectUris(sectorIdentiferUri);
        if (sectorRedirectUris != null) {
            return sectorRedirectUris;
        }
        ClientRequest clientRequest = new ClientRequest(sectorIdentiferUri);
        clientRequest.setHttpMethod("GET");
        ClientResponse clientResponse = clientRequest.get(String.class);
        int status = clientResponse.getStatus();
        if (status != 200) {
            return result;
        }
        String entity = (String)clientResponse.getEntity(String.class);
        JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
        for (int i = 0; i < sectorIdentifierJsonArray.length(); ++i) {
            result.add(sectorIdentifierJsonArray.getString(i));
        }
        this.localResponseCache.putSectorRedirectUris(sectorIdentiferUri, result);
        return result;
    }

    public String validateRedirectionUri(@NotNull Client client, String redirectionUri) {
        try {
            String sectorIdentifierUri = client.getSectorIdentifierUri();
            String[] redirectUris = client.getRedirectUris();
            if (StringUtils.isNotBlank((String)sectorIdentifierUri)) {
                redirectUris = this.getSectorRedirectUris(sectorIdentifierUri).toArray(new String[0]);
            }
            if (StringUtils.isNotBlank((String)redirectionUri) && redirectUris != null) {
                this.log.debug("Validating redirection URI: clientIdentifier = {}, redirectionUri = {}, found = {}", new Object[]{client.getClientId(), redirectionUri, redirectUris.length});
                if (this.isUriEqual(redirectionUri, redirectUris)) {
                    return redirectionUri;
                }
            } else if (redirectUris != null && redirectUris.length == 1) {
                return redirectUris[0];
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public boolean isUriEqual(String redirectionUri, String[] redirectUris) {
        String redirectUriWithoutParams = RedirectionUriService.uriWithoutParams(redirectionUri);
        for (String uri : redirectUris) {
            this.log.debug("Comparing {} == {}", (Object)uri, (Object)redirectionUri);
            if (uri.equals(redirectionUri)) {
                return true;
            }
            String uriWithoutParams = RedirectionUriService.uriWithoutParams(uri);
            Map<String, String> params = RedirectionUriService.getParams(uri);
            if ((!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() != 0 || RedirectionUriService.getParams(redirectionUri).size() != 0) && (!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() <= 0 || !RedirectionUriService.compareParams(redirectionUri, uri))) continue;
            return true;
        }
        return false;
    }

    public String validatePostLogoutRedirectUri(String clientId, String postLogoutRedirectUri) {
        boolean isBlank = Util.isNullOrEmpty((String)postLogoutRedirectUri);
        Client client = this.clientService.getClient(clientId);
        if (client != null) {
            String[] postLogoutRedirectUris = client.getPostLogoutRedirectUris();
            this.log.debug("Validating post logout redirect URI: clientId = {}, postLogoutRedirectUri = {}", (Object)clientId, (Object)postLogoutRedirectUri);
            return this.validatePostLogoutRedirectUri(postLogoutRedirectUri, postLogoutRedirectUris);
        }
        if (!isBlank) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, "`post_logout_redirect_uri` is not added to associated client.");
        }
        return null;
    }

    public String validatePostLogoutRedirectUri(SessionId sessionId, String postLogoutRedirectUri) {
        if (sessionId == null) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)EndSessionErrorResponseType.SESSION_NOT_PASSED, "Session object is not found.");
        }
        if (Strings.isNullOrEmpty((String)postLogoutRedirectUri)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_PASSED, "`post_logout_redirect_uri` is empty.");
        }
        HashSet clientsByDns = sessionId.getPermissionGrantedMap() != null ? this.clientService.getClient(sessionId.getPermissionGrantedMap().getClientIds(true), true) : Sets.newHashSet();
        this.log.trace("Validating post logout redirect URI: postLogoutRedirectUri = {}", (Object)postLogoutRedirectUri);
        for (Client client : clientsByDns) {
            String[] postLogoutRedirectUris = client.getPostLogoutRedirectUris();
            String validatedUri = this.validatePostLogoutRedirectUri(postLogoutRedirectUri, postLogoutRedirectUris);
            if (!StringUtils.isNotBlank((String)validatedUri)) continue;
            return validatedUri;
        }
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, "Unable to validate `post_logout_redirect_uri`");
    }

    public String validatePostLogoutRedirectUri(String postLogoutRedirectUri, String[] allowedPostLogoutRedirectUris) {
        if (this.appConfiguration.getAllowPostLogoutRedirectWithoutValidation().booleanValue()) {
            return postLogoutRedirectUri;
        }
        if (allowedPostLogoutRedirectUris != null && StringUtils.isNotBlank((String)postLogoutRedirectUri)) {
            if (this.isUriEqual(postLogoutRedirectUri, allowedPostLogoutRedirectUris)) {
                return postLogoutRedirectUri;
            }
        } else if (allowedPostLogoutRedirectUris != null && allowedPostLogoutRedirectUris.length == 1) {
            return allowedPostLogoutRedirectUris[0];
        }
        return "";
    }

    public static Map<String, String> getParams(String uri) {
        int paramsIndex;
        Map<String, String> params = new HashMap<String, String>();
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            String queryString = uri.substring(paramsIndex + 1);
            params = QueryStringDecoder.decode((String)queryString);
        }
        return params;
    }

    public static String uriWithoutParams(String uri) {
        int paramsIndex;
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            return uri.substring(0, paramsIndex);
        }
        return uri;
    }

    public static boolean compareParams(String uri1, String uri2) {
        if (StringUtils.isBlank((String)uri1) || StringUtils.isBlank((String)uri2)) {
            return false;
        }
        Map<String, String> params1 = RedirectionUriService.getParams(uri1);
        Map<String, String> params2 = RedirectionUriService.getParams(uri2);
        return params1.equals(params2);
    }
}

