/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.util.RedirectUri;
import org.gluu.oxauth.util.RedirectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectUriResponse {
    private static final Logger log = LoggerFactory.getLogger(RedirectUriResponse.class);
    private RedirectUri redirectUri;
    private String state;
    private HttpServletRequest httpRequest;
    private ErrorResponseFactory errorFactory;
    private boolean fapiCompatible = false;

    public RedirectUriResponse(RedirectUri redirectUri, String state, HttpServletRequest httpRequest, ErrorResponseFactory errorFactory) {
        this.redirectUri = redirectUri;
        this.state = state;
        this.httpRequest = httpRequest;
        this.errorFactory = errorFactory;
    }

    public WebApplicationException createWebException(IErrorType errorType) {
        return this.createWebException(errorType, null);
    }

    public WebApplicationException createWebException(IErrorType errorType, String reason) {
        if (this.fapiCompatible) {
            log.trace("Reason: " + reason);
            reason = null;
        }
        this.redirectUri.parseQueryString(this.errorFactory.getErrorAsQueryString(errorType, this.state, reason));
        return new WebApplicationException(RedirectUtil.getRedirectResponseBuilder(this.redirectUri, this.httpRequest).build());
    }

    public void setState(String state) {
        this.state = state;
    }

    public Response.ResponseBuilder createErrorBuilder(IErrorType errorType) {
        this.redirectUri.parseQueryString(this.errorFactory.getErrorAsQueryString(errorType, this.state));
        return RedirectUtil.getRedirectResponseBuilder(this.redirectUri, this.httpRequest);
    }

    public RedirectUri getRedirectUri() {
        return this.redirectUri;
    }

    public boolean isFapiCompatible() {
        return this.fapiCompatible;
    }

    public void setFapiCompatible(boolean fapiCompatible) {
        this.fapiCompatible = fapiCompatible;
    }
}

