/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.service.BaseAuthFilterService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.operation.SearchException;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ClientFilterService
extends BaseAuthFilterService {
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;

    @PostConstruct
    public void init() {
        super.init(this.appConfiguration.getClientAuthenticationFilters(), Boolean.TRUE.equals(this.appConfiguration.getClientAuthenticationFiltersEnabled()), false);
    }

    @Override
    public String processAuthenticationFilter(BaseAuthFilterService.AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<?, ?> attributeValues) throws SearchException {
        if (attributeValues == null) {
            return null;
        }
        Map<String, String> normalizedAttributeValues = ClientFilterService.normalizeAttributeMap(attributeValues);
        String resultDn = this.loadEntryDN(this.ldapEntryManager, authenticationFilterWithParameters, normalizedAttributeValues);
        if (StringUtils.isBlank((String)resultDn)) {
            return null;
        }
        return resultDn;
    }
}

