/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.ldap.ClientAuthorization;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ClientService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Named
public class ClientAuthorizationsService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private ClientService clientService;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("authorizations");
        branch.setDn(this.createDn(null));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch() {
        return this.ldapEntryManager.contains(this.createDn(null), SimpleBranch.class);
    }

    public void prepareBranch() {
        String baseDn = this.createDn(null);
        if (!this.ldapEntryManager.hasBranchesSupport(baseDn)) {
            return;
        }
        if (!this.containsBranch()) {
            this.addBranch();
        }
    }

    public ClientAuthorization find(String userInum, String clientId) {
        this.prepareBranch();
        String id = ClientAuthorizationsService.createId(userInum, clientId);
        try {
            if (this.appConfiguration.getClientAuthorizationBackwardCompatibility().booleanValue()) {
                return this.findToRemoveIn50(userInum, clientId);
            }
            return (ClientAuthorization)this.ldapEntryManager.find(ClientAuthorization.class, (Object)this.createDn(ClientAuthorizationsService.createId(userInum, clientId)));
        }
        catch (EntryPersistenceException e) {
            this.log.trace("Unable to find client persistence for {}", (Object)id);
            return null;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ClientAuthorization findToRemoveIn50(String userInum, String clientId) {
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"oxAuthClientId", (Object)clientId), Filter.createEqualityFilter((String)"oxAuthUserId", (Object)userInum)});
        List entries = this.ldapEntryManager.findEntries(this.staticConfiguration.getBaseDn().getAuthorizations(), ClientAuthorization.class, filter);
        if (entries != null && !entries.isEmpty()) {
            if (entries.size() > 1) {
                for (ClientAuthorization entry : entries) {
                    if (!entry.getId().equals(ClientAuthorizationsService.createId(entry.getUserId(), entry.getClientId()))) continue;
                    return entry;
                }
            }
            return (ClientAuthorization)entries.get(0);
        }
        return null;
    }

    public void clearAuthorizations(ClientAuthorization clientAuthorization, boolean persistInPersistence) {
        if (clientAuthorization == null) {
            return;
        }
        if (persistInPersistence) {
            this.ldapEntryManager.remove((Object)clientAuthorization);
        }
    }

    public void add(String userInum, String clientId, Set<String> scopes) {
        this.log.trace("Attempting to add client authorization, scopes:" + scopes + ", clientId: " + clientId + ", userInum: " + userInum);
        Client client = this.clientService.getClient(clientId);
        this.prepareBranch();
        ClientAuthorization clientAuthorization = this.find(userInum, clientId);
        if (clientAuthorization == null) {
            String id = ClientAuthorizationsService.createId(userInum, clientId);
            clientAuthorization = new ClientAuthorization();
            clientAuthorization.setId(id);
            clientAuthorization.setDn(this.createDn(id));
            clientAuthorization.setClientId(clientId);
            clientAuthorization.setUserId(userInum);
            clientAuthorization.setScopes(scopes.toArray(new String[scopes.size()]));
            clientAuthorization.setDeletable(client.getAttributes().getKeepClientAuthorizationAfterExpiration() == false);
            clientAuthorization.setExpirationDate(client.getExpirationDate());
            clientAuthorization.setTtl(this.appConfiguration.getDynamicRegistrationExpirationTime());
            this.ldapEntryManager.persist((Object)clientAuthorization);
        } else if (ArrayUtils.isNotEmpty((Object[])clientAuthorization.getScopes())) {
            HashSet<String> set = new HashSet<String>(scopes);
            set.addAll(Arrays.asList(clientAuthorization.getScopes()));
            if (set.size() != clientAuthorization.getScopes().length) {
                clientAuthorization.setScopes(set.toArray(new String[set.size()]));
                this.ldapEntryManager.merge((Object)clientAuthorization);
            }
        }
    }

    public static String createId(String userId, String clientId) {
        return userId + "_" + clientId;
    }

    public String createDn(String oxId) {
        String baseDn = this.staticConfiguration.getBaseDn().getAuthorizations();
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }
}

