/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.service.fido.u2f.RequestService;
import org.gluu.oxauth.uma.service.UmaPctService;
import org.gluu.oxauth.uma.service.UmaResourceService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.DeletableEntity;
import org.gluu.search.filter.Filter;
import org.gluu.service.cache.CacheProvider;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.CleanerEvent;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class CleanerTimer {
    public static final int BATCH_SIZE = 1000;
    private static final int DEFAULT_INTERVAL = 30;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private UmaPctService umaPctService;
    @Inject
    private UmaResourceService umaResourceService;
    @Inject
    private CacheProvider cacheProvider;
    @Inject
    @Named(value="u2fRequestService")
    private RequestService u2fRequestService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private Event<TimerEvent> cleanerEvent;
    private long lastFinishedTime;
    private AtomicBoolean isActive;

    public void initTimer() {
        this.log.debug("Initializing Cleaner Timer");
        this.isActive = new AtomicBoolean(false);
        this.cleanerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new CleanerEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
    }

    @Asynchronous
    public void process(@Observes @Scheduled CleanerEvent cleanerEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processImpl();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private boolean isStartProcess() {
        int interval = this.appConfiguration.getCleanServiceInterval();
        if (interval < 0) {
            this.log.info("Cleaner Timer is disabled.");
            this.log.warn("Cleaner Timer Interval (cleanServiceInterval in oxauth configuration) is negative which turns OFF internal clean up by the server. Please set it to positive value if you wish internal clean up timer run.");
            return false;
        }
        long cleaningInterval = interval * 1000;
        long timeDiffrence = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDiffrence >= cleaningInterval;
    }

    public void processImpl() {
        try {
            if (!this.isStartProcess()) {
                this.log.trace("Starting conditions aren't reached");
                return;
            }
            int chunkSize = this.appConfiguration.getCleanServiceBatchChunkSize();
            if (chunkSize <= 0) {
                chunkSize = 1000;
            }
            Date now = new Date();
            for (String baseDn : this.createCleanServiceBaseDns()) {
                try {
                    if (this.entryManager.hasExpirationSupport(baseDn)) continue;
                    this.log.debug("Start clean up for baseDn: " + baseDn);
                    Stopwatch started = Stopwatch.createStarted();
                    int removed = this.cleanup(baseDn, now, chunkSize);
                    this.log.debug("Finished clean up for baseDn: {}, takes: {}ms, removed items: {}", new Object[]{baseDn, started.elapsed(TimeUnit.MILLISECONDS), removed});
                }
                catch (Exception e) {
                    this.log.error("Failed to process clean up for baseDn: " + baseDn, (Throwable)e);
                }
            }
            this.processCache(now);
            this.lastFinishedTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.log.error("Failed to process clean up.", (Throwable)e);
        }
    }

    public Set<String> createCleanServiceBaseDns() {
        String u2fBase = this.staticConfiguration.getBaseDn().getU2fBase();
        HashSet cleanServiceBaseDns = Sets.newHashSet((Iterable)this.appConfiguration.getCleanServiceBaseDns());
        cleanServiceBaseDns.add(this.staticConfiguration.getBaseDn().getClients());
        cleanServiceBaseDns.add(this.umaPctService.branchBaseDn());
        cleanServiceBaseDns.add(this.umaResourceService.getBaseDnForResource());
        cleanServiceBaseDns.add(String.format("ou=registration_requests,%s", u2fBase));
        cleanServiceBaseDns.add(String.format("ou=registered_devices,%s", u2fBase));
        cleanServiceBaseDns.add(this.staticConfiguration.getBaseDn().getPeople());
        cleanServiceBaseDns.add(this.staticConfiguration.getBaseDn().getMetric());
        cleanServiceBaseDns.add(this.staticConfiguration.getBaseDn().getTokens());
        cleanServiceBaseDns.add(this.staticConfiguration.getBaseDn().getAuthorizations());
        cleanServiceBaseDns.add(this.staticConfiguration.getBaseDn().getScopes());
        cleanServiceBaseDns.add(this.staticConfiguration.getBaseDn().getSessions());
        this.log.debug("Built-in base dns: " + cleanServiceBaseDns);
        return cleanServiceBaseDns;
    }

    public int cleanup(String baseDn, Date now, int batchSize) {
        try {
            Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"del", (Object)true), Filter.createLessOrEqualFilter((String)"exp", (Object)this.entryManager.encodeTime(baseDn, now))});
            int removedCount = this.entryManager.remove(baseDn, DeletableEntity.class, filter, batchSize);
            return removedCount;
        }
        catch (Exception e) {
            this.log.error("Failed to perform clean up.", (Throwable)e);
            return 0;
        }
    }

    private void processCache(Date now) {
        try {
            this.cacheProvider.cleanup(now);
        }
        catch (Exception e) {
            this.log.error("Failed to clean up cache.", (Throwable)e);
        }
    }
}

