/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.service.BaseAuthFilterService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.AuthenticationException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.util.StringHelper;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class AuthenticationFilterService
extends BaseAuthFilterService {
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;

    @PostConstruct
    public void init() {
        super.init(this.appConfiguration.getAuthenticationFilters(), Boolean.TRUE.equals(this.appConfiguration.getAuthenticationFiltersEnabled()), true);
    }

    @Override
    public String processAuthenticationFilter(BaseAuthFilterService.AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<?, ?> attributeValues) throws SearchException {
        if (attributeValues == null) {
            return null;
        }
        Map<String, String> normalizedAttributeValues = AuthenticationFilterService.normalizeAttributeMap(attributeValues);
        String resultDn = this.loadEntryDN(this.ldapEntryManager, authenticationFilterWithParameters, normalizedAttributeValues);
        if (StringUtils.isBlank((String)resultDn)) {
            return null;
        }
        if (!Boolean.TRUE.equals(authenticationFilterWithParameters.getAuthenticationFilter().getBind())) {
            return resultDn;
        }
        String bindPasswordAttribute = authenticationFilterWithParameters.getAuthenticationFilter().getBindPasswordAttribute();
        if (StringHelper.isEmpty((String)bindPasswordAttribute)) {
            this.log.error("Skipping authentication filter:\n '{}'\n. It should contains not empty bind-password-attribute attribute. ", (Object)authenticationFilterWithParameters.getAuthenticationFilter());
            return null;
        }
        bindPasswordAttribute = StringHelper.toLowerCase((String)bindPasswordAttribute);
        try {
            boolean authenticated = this.ldapEntryManager.authenticate(resultDn, normalizedAttributeValues.get(bindPasswordAttribute));
            if (authenticated) {
                return resultDn;
            }
        }
        catch (AuthenticationException ex) {
            this.log.error("Invalid password", (Throwable)ex);
        }
        return null;
    }
}

