/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.token;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationGrantType;
import org.gluu.oxauth.model.common.IdToken;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.util.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentJwt {
    private static final Logger log = LoggerFactory.getLogger(PersistentJwt.class);
    private String userId;
    private String clientId;
    private AuthorizationGrantType authorizationGrantType;
    private Date authenticationTime;
    private List<String> scopes;
    private List<AccessToken> accessTokens;
    private List<RefreshToken> refreshTokens;
    private AccessToken longLivedAccessToken;
    private IdToken idToken;

    public PersistentJwt() {
    }

    public PersistentJwt(String jwt) {
        try {
            this.load(jwt);
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AuthorizationGrantType getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    public void setAuthorizationGrantType(AuthorizationGrantType authorizationGrantType) {
        this.authorizationGrantType = authorizationGrantType;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public List<AccessToken> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<AccessToken> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public List<RefreshToken> getRefreshTokens() {
        return this.refreshTokens;
    }

    public void setRefreshTokens(List<RefreshToken> refreshTokens) {
        this.refreshTokens = refreshTokens;
    }

    public AccessToken getLongLivedAccessToken() {
        return this.longLivedAccessToken;
    }

    public void setLongLivedAccessToken(AccessToken longLivedAccessToken) {
        this.longLivedAccessToken = longLivedAccessToken;
    }

    public IdToken getIdToken() {
        return this.idToken;
    }

    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    public String toString() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (StringUtils.isNotBlank((String)this.userId)) {
                jsonObject.put("user_id", (Object)this.userId);
            }
            if (StringUtils.isNotBlank((String)this.clientId)) {
                jsonObject.put("client_id", (Object)this.clientId);
            }
            if (this.authorizationGrantType != null) {
                jsonObject.put("authorization_grant_type", (Object)this.authorizationGrantType);
            }
            if (this.authenticationTime != null) {
                jsonObject.put("authentication_time", this.authenticationTime.getTime());
            }
            if (this.scopes != null) {
                JSONArray scopesJsonArray = new JSONArray();
                for (String scope : this.scopes) {
                    scopesJsonArray.put((Object)scope);
                }
                jsonObject.put("scopes", (Object)scopesJsonArray);
            }
            if (this.accessTokens != null) {
                JSONArray accessTokensJsonArray = new JSONArray();
                for (AccessToken accessToken : this.accessTokens) {
                    JSONObject accessTokenJsonObject = new JSONObject();
                    if (accessToken.getCode() != null && !accessToken.getCode().isEmpty()) {
                        accessTokenJsonObject.put("code", (Object)accessToken.getCode());
                    }
                    if (accessToken.getCreationDate() != null) {
                        accessTokenJsonObject.put("creation_date", accessToken.getCreationDate().getTime());
                    }
                    if (accessToken.getExpirationDate() != null) {
                        accessTokenJsonObject.put("expiration_date", accessToken.getExpirationDate().getTime());
                    }
                    accessTokensJsonArray.put((Object)accessTokenJsonObject);
                }
                jsonObject.put("access_tokens", (Object)accessTokensJsonArray);
            }
            if (this.refreshTokens != null) {
                JSONArray refreshTokensJsonArray = new JSONArray();
                for (RefreshToken refreshToken : this.refreshTokens) {
                    JSONObject refreshTokenJsonObject = new JSONObject();
                    if (refreshToken.getCode() != null && !refreshToken.getCode().isEmpty()) {
                        refreshTokenJsonObject.put("code", (Object)refreshToken.getCode());
                    }
                    if (refreshToken.getCreationDate() != null) {
                        refreshTokenJsonObject.put("creation_date", refreshToken.getCreationDate().getTime());
                    }
                    if (refreshToken.getExpirationDate() == null) continue;
                    refreshTokenJsonObject.put("expiration_date", refreshToken.getExpirationDate().getTime());
                }
                jsonObject.put("refresh_tokens", (Object)refreshTokensJsonArray);
            }
            if (this.longLivedAccessToken != null) {
                JSONObject longLivedAccessTokenJsonObject = new JSONObject();
                if (this.longLivedAccessToken.getCode() != null && !this.longLivedAccessToken.getCode().isEmpty()) {
                    longLivedAccessTokenJsonObject.put("code", (Object)this.longLivedAccessToken.getCode());
                }
                if (this.longLivedAccessToken.getCreationDate() != null) {
                    longLivedAccessTokenJsonObject.put("creation_date", this.longLivedAccessToken.getCreationDate().getTime());
                }
                if (this.longLivedAccessToken.getExpirationDate() != null) {
                    longLivedAccessTokenJsonObject.put("expiration_date", this.longLivedAccessToken.getExpirationDate().getTime());
                }
                jsonObject.put("long_lived_access_token", (Object)longLivedAccessTokenJsonObject);
            }
            if (this.idToken != null) {
                JSONObject idTokenJsonObject = new JSONObject();
                if (this.idToken.getCode() != null && !this.idToken.getCode().isEmpty()) {
                    idTokenJsonObject.put("code", (Object)this.idToken.getCode());
                }
                if (this.idToken.getCreationDate() != null) {
                    idTokenJsonObject.put("creation_date", this.idToken.getCreationDate().getTime());
                }
                if (this.idToken.getExpirationDate() != null) {
                    idTokenJsonObject.put("expiration_date", this.idToken.getExpirationDate().getTime());
                }
                jsonObject.put("id_token", (Object)idTokenJsonObject);
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObject.toString();
    }

    private boolean load(String jwt) throws JSONException {
        JSONObject idTokenJsonObject;
        Date expirationDate;
        Date creationDate;
        JSONObject longLivedAccessTokenJsonObject;
        Date expirationDate2;
        Date creationDate2;
        String tokenCode;
        int i;
        boolean result = false;
        JSONObject jsonObject = new JSONObject(jwt);
        if (jsonObject.has("user_id")) {
            this.userId = jsonObject.getString("user_id");
        }
        if (jsonObject.has("client_id")) {
            this.clientId = jsonObject.getString("client_id");
        }
        if (jsonObject.has("authorization_grant_type")) {
            this.authorizationGrantType = AuthorizationGrantType.fromString(jsonObject.getString("authorization_grant_type"));
        }
        if (jsonObject.has("authentication_time")) {
            this.authenticationTime = new Date(jsonObject.getLong("authentication_time"));
        }
        if (jsonObject.has("scopes")) {
            JSONArray jsonArray = jsonObject.getJSONArray("scopes");
            this.scopes = Util.asList((JSONArray)jsonArray);
        }
        if (jsonObject.has("access_tokens")) {
            JSONArray accessTokensJsonArray = jsonObject.getJSONArray("access_tokens");
            this.accessTokens = new ArrayList<AccessToken>();
            for (i = 0; i < accessTokensJsonArray.length(); ++i) {
                JSONObject accessTokenJsonObject = accessTokensJsonArray.getJSONObject(i);
                if (!accessTokenJsonObject.has("code") || !accessTokenJsonObject.has("creation_date") || !accessTokenJsonObject.has("expiration_date")) continue;
                tokenCode = accessTokenJsonObject.getString("code");
                creationDate2 = new Date(accessTokenJsonObject.getLong("creation_date"));
                expirationDate2 = new Date(accessTokenJsonObject.getLong("expiration_date"));
                AccessToken accessToken = new AccessToken(tokenCode, creationDate2, expirationDate2);
                this.accessTokens.add(accessToken);
            }
        }
        if (jsonObject.has("refresh_tokens")) {
            JSONArray refreshTokensJsonArray = jsonObject.getJSONArray("refresh_tokens");
            this.refreshTokens = new ArrayList<RefreshToken>();
            for (i = 0; i < refreshTokensJsonArray.length(); ++i) {
                JSONObject refreshTokenJsonObject = refreshTokensJsonArray.getJSONObject(i);
                if (!refreshTokenJsonObject.has("code") || !refreshTokenJsonObject.has("creation_date") || !refreshTokenJsonObject.has("expiration_date")) continue;
                tokenCode = refreshTokenJsonObject.getString("code");
                creationDate2 = new Date(refreshTokenJsonObject.getLong("creation_date"));
                expirationDate2 = new Date(refreshTokenJsonObject.getLong("expiration_date"));
                RefreshToken refreshToken = new RefreshToken(tokenCode, creationDate2, expirationDate2);
                this.refreshTokens.add(refreshToken);
            }
        }
        if (jsonObject.has("long_lived_access_token") && (longLivedAccessTokenJsonObject = jsonObject.getJSONObject("long_lived_access_token")).has("code") && longLivedAccessTokenJsonObject.has("creation_date") && longLivedAccessTokenJsonObject.has("expiration_date")) {
            String tokenCode2 = longLivedAccessTokenJsonObject.getString("code");
            creationDate = new Date(longLivedAccessTokenJsonObject.getLong("creation_date"));
            expirationDate = new Date(longLivedAccessTokenJsonObject.getLong("expiration_date"));
            this.longLivedAccessToken = new AccessToken(tokenCode2, creationDate, expirationDate);
        }
        if (jsonObject.has("id_token") && (idTokenJsonObject = jsonObject.getJSONObject("id_token")).has("code") && idTokenJsonObject.has("creation_date") && idTokenJsonObject.has("expiration_date")) {
            String tokenCode3 = idTokenJsonObject.getString("code");
            creationDate = new Date(idTokenJsonObject.getLong("creation_date"));
            expirationDate = new Date(idTokenJsonObject.getLong("expiration_date"));
            this.idToken = new IdToken(tokenCode3, creationDate, expirationDate);
        }
        return result;
    }
}

