/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.ldap;

import org.apache.commons.lang.StringUtils;

public enum TokenType {
    ID_TOKEN("id_token"),
    ACCESS_TOKEN("access_token"),
    LONG_LIVED_ACCESS_TOKEN("access_token"),
    REFRESH_TOKEN("refresh_token"),
    AUTHORIZATION_CODE("authorization_code");

    private final String value;

    private TokenType(String name) {
        this.value = name;
    }

    public String getValue() {
        return this.value;
    }

    public static TokenType fromValue(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            for (TokenType t : TokenType.values()) {
                if (!t.getValue().endsWith(value)) continue;
                return t;
            }
        }
        return null;
    }
}

