/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.authorize;

import java.util.ArrayList;
import java.util.List;
import org.gluu.oxauth.model.authorize.ClaimValueType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClaimValue {
    private ClaimValueType claimValueType;
    private List<String> values;
    private String value;
    private Boolean essential;

    private ClaimValue() {
    }

    public static ClaimValue createNull() {
        ClaimValue claimValue = new ClaimValue();
        claimValue.claimValueType = ClaimValueType.NULL;
        return claimValue;
    }

    public static ClaimValue createEssential(boolean essentialValue) {
        ClaimValue claimValue = new ClaimValue();
        claimValue.setEssential(essentialValue);
        claimValue.claimValueType = essentialValue ? ClaimValueType.ESSENTIAL_TRUE : ClaimValueType.ESSENTIAL_FALSE;
        return claimValue;
    }

    public static ClaimValue createValueList(List<String> values) {
        ClaimValue claimValue = new ClaimValue();
        claimValue.claimValueType = ClaimValueType.VALUE_LIST;
        claimValue.values = new ArrayList<String>(values);
        return claimValue;
    }

    public static ClaimValue createSingleValue(String value) {
        ClaimValue claimValue = new ClaimValue();
        claimValue.claimValueType = ClaimValueType.SINGLE_VALUE;
        claimValue.value = value;
        return claimValue;
    }

    public Boolean getEssential() {
        return this.essential;
    }

    public void setEssential(Boolean essential) {
        this.essential = essential;
    }

    public ClaimValueType getClaimValueType() {
        return this.claimValueType;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.values != null && !this.values.isEmpty()) {
            return String.join((CharSequence)" ", this.values);
        }
        return this.value;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject obj = null;
        switch (this.claimValueType) {
            case NULL: {
                break;
            }
            case ESSENTIAL_TRUE: {
                obj = new JSONObject();
                obj.put("essential", true);
                break;
            }
            case ESSENTIAL_FALSE: {
                obj = new JSONObject();
                obj.put("essential", false);
                break;
            }
            case VALUE_LIST: {
                JSONArray arr = new JSONArray();
                for (String value : this.values) {
                    arr.put((Object)value);
                }
                obj = new JSONObject();
                obj.put("values", (Object)arr);
                break;
            }
            case SINGLE_VALUE: {
                obj = new JSONObject();
                obj.put("value", (Object)this.value);
            }
        }
        return obj;
    }
}

