/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.model.authorize;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.registration.Client;

public class AuthorizeParamsValidator {
    public static boolean validateParams(List<ResponseType> responseTypes, List<Prompt> prompts, String nonce, boolean fapiCompatibility) {
        if (fapiCompatibility && responseTypes.size() == 1 && responseTypes.contains(ResponseType.CODE)) {
            return false;
        }
        if ((responseTypes.contains(ResponseType.TOKEN) || responseTypes.contains(ResponseType.ID_TOKEN)) && StringUtils.isBlank((String)nonce)) {
            return false;
        }
        boolean validParams = !responseTypes.isEmpty();
        return validParams && AuthorizeParamsValidator.noNonePrompt(prompts);
    }

    public static boolean noNonePrompt(List<Prompt> prompts) {
        return !prompts.contains(Prompt.NONE) || prompts.size() <= 1;
    }

    public static boolean validateResponseTypes(List<ResponseType> responseTypes, Client client) {
        if (responseTypes == null || responseTypes.isEmpty() || client == null || client.getResponseTypes() == null) {
            return false;
        }
        List<ResponseType> clientSupportedResponseTypes = Arrays.asList(client.getResponseTypes());
        return clientSupportedResponseTypes.containsAll(responseTypes);
    }

    public static boolean validateGrantType(List<ResponseType> responseTypes, GrantType[] clientGrantTypesArray, Set<GrantType> grantTypesSupported) {
        GrantType requestedGrantType;
        List<GrantType> clientGrantTypes = Arrays.asList(clientGrantTypesArray);
        if (responseTypes == null || grantTypesSupported == null) {
            return false;
        }
        if (!(!responseTypes.contains(ResponseType.CODE) || clientGrantTypes.contains(requestedGrantType = GrantType.AUTHORIZATION_CODE) && grantTypesSupported.contains(requestedGrantType))) {
            return false;
        }
        return !responseTypes.contains(ResponseType.TOKEN) && !responseTypes.contains(ResponseType.ID_TOKEN) || clientGrantTypes.contains(requestedGrantType = GrantType.IMPLICIT) && grantTypesSupported.contains(requestedGrantType);
    }
}

