/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.jwk.ws.rs;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.gluu.oxauth.jwk.ws.rs.JwkRestWebService;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.jwk.JSONWebKey;
import org.slf4j.Logger;

@Path(value="/")
public class JwkRestWebServiceImpl
implements JwkRestWebService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;

    @Override
    public Response requestJwk(SecurityContext sec) {
        this.log.debug("Attempting to request JWK, Is Secure = {}", (Object)sec.isSecure());
        Response.ResponseBuilder builder = Response.ok();
        try {
            WebKeysConfiguration webKeysConfiguration = new WebKeysConfiguration();
            webKeysConfiguration.setKeys(this.filterKeys(this.webKeysConfiguration.getKeys()));
            builder.entity((Object)webKeysConfiguration.toString());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return builder.build();
    }

    private List<JSONWebKey> filterKeys(List<JSONWebKey> allKeys) {
        List jwksAlgorithmsSupported = this.appConfiguration.getJwksAlgorithmsSupported();
        if (allKeys == null || allKeys.size() == 0 || jwksAlgorithmsSupported == null || jwksAlgorithmsSupported.size() == 0) {
            return allKeys;
        }
        return allKeys.stream().filter(key -> jwksAlgorithmsSupported.contains(key.getAlg().getParamName())).collect(Collectors.toList());
    }
}

