/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.introspection.ws.rs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.claims.Audience;
import org.gluu.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.IntrospectionResponse;
import org.gluu.oxauth.model.common.TokenType;
import org.gluu.oxauth.model.config.WebKeysConfiguration;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JwtSigner;
import org.gluu.oxauth.model.uma.UmaScopeType;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.external.ExternalIntrospectionService;
import org.gluu.oxauth.service.external.context.ExternalIntrospectionContext;
import org.gluu.oxauth.service.token.TokenService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.Pair;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/introspection")
public class IntrospectionWebService {
    private static final Pair<AuthorizationGrant, Boolean> EMPTY = new Pair(null, (Object)false);
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private TokenService tokenService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalIntrospectionService externalIntrospectionService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;

    @GET
    @Produces(value={"application/json"})
    public Response introspectGet(@HeaderParam(value="Authorization") String p_authorization, @QueryParam(value="token") String p_token, @QueryParam(value="token_type_hint") String tokenTypeHint, @QueryParam(value="response_as_jwt") String responseAsJwt, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(p_authorization, p_token, tokenTypeHint, responseAsJwt, httpRequest, httpResponse);
    }

    @POST
    @Produces(value={"application/json"})
    public Response introspectPost(@HeaderParam(value="Authorization") String p_authorization, @FormParam(value="token") String p_token, @FormParam(value="token_type_hint") String tokenTypeHint, @FormParam(value="response_as_jwt") String responseAsJwt, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        return this.introspect(p_authorization, p_token, tokenTypeHint, responseAsJwt, httpRequest, httpResponse);
    }

    private Response introspect(String p_authorization, String p_token, String tokenTypeHint, String responseAsJwt, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            this.log.trace("Introspect token, authorization: {}, token to introsppect: {}, tokenTypeHint:", new Object[]{p_authorization, p_token, tokenTypeHint});
            if (StringUtils.isBlank((String)p_authorization) || StringUtils.isBlank((String)p_token)) {
                this.log.trace("Bad request: Authorization header or token is blank.");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "")).build();
            }
            Pair<AuthorizationGrant, Boolean> pair = this.getAuthorizationGrant(p_authorization, p_token);
            AuthorizationGrant authorizationGrant = (AuthorizationGrant)pair.getFirst();
            if (authorizationGrant == null) {
                this.log.error("Authorization grant is null.");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Authorization grant is null.")).build();
            }
            AbstractToken authorizationAccessToken = authorizationGrant.getAccessToken(this.tokenService.getToken(p_authorization));
            if (!(authorizationAccessToken != null && authorizationAccessToken.isValid() || ((Boolean)pair.getSecond()).booleanValue())) {
                this.log.error("Access token is not valid. Valid: " + (authorizationAccessToken != null && authorizationAccessToken.isValid()) + ", basicClientAuthentication: " + pair.getSecond());
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Access token is not valid")).build();
            }
            if (ServerUtil.isTrue(this.appConfiguration.getIntrospectionAccessTokenMustHaveUmaProtectionScope()) && !authorizationGrant.getScopesAsString().contains(UmaScopeType.PROTECTION.getValue())) {
                String reason = "access_token used to access introspection endpoint does not have uma_protection scope, however in oxauth configuration `checkUmaProtectionScopePresenceDuringIntrospection` is true";
                this.log.trace("access_token used to access introspection endpoint does not have uma_protection scope, however in oxauth configuration `checkUmaProtectionScopePresenceDuringIntrospection` is true");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "access_token used to access introspection endpoint does not have uma_protection scope, however in oxauth configuration `checkUmaProtectionScopePresenceDuringIntrospection` is true")).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            IntrospectionResponse response = new IntrospectionResponse(false);
            AuthorizationGrant grantOfIntrospectionToken = this.authorizationGrantList.getAuthorizationGrantByAccessToken(p_token);
            AbstractToken tokenToIntrospect = null;
            if (grantOfIntrospectionToken != null) {
                tokenToIntrospect = grantOfIntrospectionToken.getAccessToken(p_token);
                response.setActive(tokenToIntrospect.isValid());
                response.setExpiresAt(ServerUtil.dateToSeconds(tokenToIntrospect.getExpirationDate()));
                response.setIssuedAt(ServerUtil.dateToSeconds(tokenToIntrospect.getCreationDate()));
                response.setAcrValues(grantOfIntrospectionToken.getAcrValues());
                response.setScope((Collection)(grantOfIntrospectionToken.getScopes() != null ? grantOfIntrospectionToken.getScopes() : Lists.newArrayList()));
                response.setClientId(grantOfIntrospectionToken.getClientId());
                response.setSub(grantOfIntrospectionToken.getSub());
                response.setUsername(grantOfIntrospectionToken.getUserId());
                response.setIssuer(this.appConfiguration.getIssuer());
                response.setAudience(grantOfIntrospectionToken.getClientId());
                if (tokenToIntrospect instanceof AccessToken) {
                    AccessToken accessToken = (AccessToken)tokenToIntrospect;
                    response.setTokenType(accessToken.getTokenType() != null ? accessToken.getTokenType().getName() : TokenType.BEARER.getName());
                }
            } else {
                this.log.debug("Failed to find grant for access_token: " + p_token + ". Return 200 with active=false.");
            }
            JSONObject responseAsJsonObject = IntrospectionWebService.createResponseAsJsonObject(response, tokenToIntrospect);
            ExternalIntrospectionContext context = new ExternalIntrospectionContext(authorizationGrant, httpRequest, httpResponse, this.appConfiguration, this.attributeService);
            context.setGrantOfIntrospectionToken(grantOfIntrospectionToken);
            if (this.externalIntrospectionService.executeExternalModifyResponse(responseAsJsonObject, context)) {
                this.log.trace("Successfully run extenal introspection scripts.");
            } else {
                responseAsJsonObject = IntrospectionWebService.createResponseAsJsonObject(response, tokenToIntrospect);
                this.log.trace("Canceled changes made by external introspection script since method returned `false`.");
            }
            if (response.getScope() != null && !this.appConfiguration.getIntrospectionResponseScopesBackwardCompatibility().booleanValue()) {
                String scopes = StringUtils.join((Object[])response.getScope().toArray(), (String)" ");
                responseAsJsonObject.put("scope", (Object)scopes);
            }
            if (Boolean.TRUE.toString().equalsIgnoreCase(responseAsJwt)) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)this.createResponseAsJwt(responseAsJsonObject, authorizationGrant)).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseAsJsonObject.toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    private String createResponseAsJwt(JSONObject response, AuthorizationGrant grant) throws Exception {
        JwtSigner jwtSigner = JwtSigner.newJwtSigner(this.appConfiguration, this.webKeysConfiguration, grant.getClient());
        Jwt jwt = jwtSigner.newJwt();
        Audience.setAudience((JwtClaims)jwt.getClaims(), (Client)grant.getClient());
        Iterator keysIter = response.keys();
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            Object value = response.opt(key);
            if (value == null) continue;
            try {
                jwt.getClaims().setClaimObject(key, value, false);
            }
            catch (Exception e) {
                this.log.error("Failed to put claims into jwt. Key: " + key + ", response: " + response.toString(), (Throwable)e);
            }
        }
        return jwtSigner.sign().toString();
    }

    private static JSONObject createResponseAsJsonObject(IntrospectionResponse response, AbstractToken tokenToIntrospect) throws JSONException, IOException {
        JSONObject result = new JSONObject(ServerUtil.asJson(response));
        if (tokenToIntrospect != null && StringUtils.isNotBlank((String)tokenToIntrospect.getX5ts256())) {
            JSONObject cnf = new JSONObject();
            cnf.put("x5t#S256", (Object)tokenToIntrospect.getX5ts256());
            result.put("cnf", (Object)cnf);
        }
        return result;
    }

    private Pair<AuthorizationGrant, Boolean> getAuthorizationGrant(String authorization, String accessToken) throws UnsupportedEncodingException {
        String encodedCredentials;
        String token;
        int delim;
        AuthorizationGrant grant = this.tokenService.getBearerAuthorizationGrant(authorization);
        if (grant != null) {
            String authorizationAccessToken = this.tokenService.getBearerToken(authorization);
            AbstractToken accessTokenObject = grant.getAccessToken(authorizationAccessToken);
            if (accessTokenObject != null && accessTokenObject.isValid()) {
                return new Pair((Object)grant, (Object)false);
            }
            this.log.error("Access token is not valid: " + authorizationAccessToken);
            return EMPTY;
        }
        grant = this.tokenService.getBasicAuthorizationGrant(authorization);
        if (grant != null) {
            return new Pair((Object)grant, (Object)false);
        }
        if (this.tokenService.isBasicAuthToken(authorization) && (delim = (token = new String(Base64.decodeBase64((String)(encodedCredentials = this.tokenService.getBasicToken(authorization))), "UTF-8")).indexOf(":")) != -1) {
            String password;
            String clientId = URLDecoder.decode(token.substring(0, delim), "UTF-8");
            if (this.clientService.authenticate(clientId, password = URLDecoder.decode(token.substring(delim + 1), "UTF-8"))) {
                grant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
                if (grant != null && !grant.getClientId().equals(clientId)) {
                    this.log.trace("Failed to match grant object clientId and client id provided during authentication.");
                    return EMPTY;
                }
                return new Pair((Object)grant, (Object)true);
            }
            this.log.trace("Failed to perform basic authentication for client: " + clientId);
        }
        return EMPTY;
    }
}

