/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.idgen.ws.rs;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.IdType;
import org.gluu.oxauth.model.config.BaseDnConfiguration;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.DummyEntry;
import org.gluu.search.filter.Filter;
import org.gluu.util.INumGenerator;
import org.slf4j.Logger;

@Stateless
@Named(value="inumGenerator")
public class InumGenerator {
    public static final String SEPARATOR = "!";
    private static final int MAX = 100;
    private final Pattern baseRdnPattern = Pattern.compile(".+o=([\\w\\!\\@\\.]+)$");
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public String generateId(String p_idType, String p_idPrefix) {
        IdType idType = IdType.fromString((String)p_idType);
        if (idType != null) {
            return this.generateId(idType, p_idPrefix);
        }
        this.log.error("Unable to identify id type: {}", (Object)p_idType);
        return "";
    }

    public String generateId(IdType p_idType, String p_idPrefix) {
        String inum;
        int counter = 0;
        try {
            while (true) {
                StringBuilder sb = new StringBuilder();
                sb.append(p_idPrefix).append(SEPARATOR).append(p_idType.getInum()).append(SEPARATOR);
                if (IdType.CLIENTS == p_idType || IdType.PEOPLE == p_idType) {
                    sb.append(INumGenerator.generate((int)4));
                } else {
                    sb.append(INumGenerator.generate((int)2));
                }
                inum = sb.toString();
                if (StringUtils.isBlank((String)inum)) {
                    this.log.error("Unable to generate inum: {}", (Object)inum);
                } else if (this.contains(inum, p_idType)) {
                    if (counter > 100) {
                        this.log.error("Infinite loop problem while generating new inum");
                        return "";
                    }
                    ++counter;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            inum = e.getMessage();
        }
        this.log.trace("Generated inum: {}", (Object)inum);
        return inum;
    }

    public boolean contains(String inum, IdType type) {
        Filter filter;
        String baseDn = this.baseDn(type);
        List entries = this.ldapEntryManager.findEntries(baseDn, DummyEntry.class, filter = Filter.createEqualityFilter((String)"inum", (Object)inum));
        return entries != null && !entries.isEmpty();
    }

    public String baseDn(IdType p_type) {
        BaseDnConfiguration baseDn = this.staticConfiguration.getBaseDn();
        switch (p_type) {
            case CLIENTS: {
                return baseDn.getClients();
            }
            case CONFIGURATION: {
                return baseDn.getConfiguration();
            }
            case ATTRIBUTE: {
                return baseDn.getAttributes();
            }
            case PEOPLE: {
                return baseDn.getPeople();
            }
        }
        Matcher m = this.baseRdnPattern.matcher(baseDn.getClients());
        if (m.matches()) {
            return m.group(1);
        }
        this.log.error("Use fallback DN: o=gluu, for ID generator, please check oxAuth configuration, clientDn must be valid DN");
        return "o=gluu";
    }
}

