/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.exception;

import java.net.URI;
import javax.enterprise.inject.Vetoed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Vetoed
public class UncaughtException
extends Throwable
implements ExceptionMapper<Throwable> {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_PAGE = "/error_service.htm";
    private Logger log = LoggerFactory.getLogger(UncaughtException.class);
    @Context
    private HttpServletRequest httpRequest;
    @Context
    private UriInfo uriInfo;

    public Response toResponse(Throwable exception) {
        try {
            Response response;
            if (exception instanceof WebApplicationException && (response = ((WebApplicationException)exception).getResponse()) != null && response.getStatus() > 0) {
                return response;
            }
            this.log.error("Jersey error.", exception);
            return Response.temporaryRedirect((URI)new URI(this.getRedirectURI())).build();
        }
        catch (Exception e) {
            this.log.error("Jersey error.", (Throwable)e);
            return Response.status((int)500).entity((Object)"Something bad happened. Please try again later!").type("text/plain").build();
        }
    }

    private String getRedirectURI() throws Exception {
        String contextPath;
        String baseUri = this.uriInfo.getBaseUri().toString();
        int startIndex = baseUri.indexOf(contextPath = this.httpRequest.getContextPath());
        if (startIndex == -1) {
            throw new Exception("Can't build redirect URI");
        }
        return baseUri.substring(0, startIndex + contextPath.length()) + ERROR_PAGE;
    }
}

