/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ciba;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.client.BaseRequest;
import org.gluu.oxauth.client.ciba.ping.PingCallbackClient;
import org.gluu.oxauth.client.ciba.ping.PingCallbackRequest;
import org.gluu.oxauth.client.ciba.ping.PingCallbackResponse;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBAPingCallbackService {
    private static final Logger log = LoggerFactory.getLogger(CIBAPingCallbackService.class);
    @Inject
    private AppConfiguration appConfiguration;

    public void pingCallback(String authReqId, String clientNotificationEndpoint, String clientNotificationToken) {
        PingCallbackRequest pingCallbackRequest = new PingCallbackRequest();
        pingCallbackRequest.setClientNotificationToken(clientNotificationToken);
        pingCallbackRequest.setAuthReqId(authReqId);
        PingCallbackClient pingCallbackClient = new PingCallbackClient(clientNotificationEndpoint, this.appConfiguration.getFapiCompatibility().booleanValue());
        pingCallbackClient.setRequest((BaseRequest)pingCallbackRequest);
        PingCallbackResponse pingCallbackResponse = pingCallbackClient.exec();
        log.debug("CIBA: ping callback result status " + pingCallbackResponse.getStatus());
    }
}

