/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.bcauthorize.ws.rs;

import java.util.UUID;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.util.RedirectUri;
import org.slf4j.Logger;

@RequestScoped
@Named(value="cibaAuthorizeAction")
public class CIBAAuthorizeAction {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;

    public String getApiKey() {
        return this.appConfiguration.getCibaEndUserNotificationConfig().getApiKey();
    }

    public String getAuthDomain() {
        return this.appConfiguration.getCibaEndUserNotificationConfig().getAuthDomain();
    }

    public String getDatabaseURL() {
        return this.appConfiguration.getCibaEndUserNotificationConfig().getDatabaseURL();
    }

    public String getProjectId() {
        return this.appConfiguration.getCibaEndUserNotificationConfig().getProjectId();
    }

    public String getStorageBucket() {
        return this.appConfiguration.getCibaEndUserNotificationConfig().getStorageBucket();
    }

    public String getMessagingSenderId() {
        return this.appConfiguration.getCibaEndUserNotificationConfig().getMessagingSenderId();
    }

    public String getAppId() {
        return this.appConfiguration.getCibaEndUserNotificationConfig().getAppId();
    }

    public String getPublicVapidKey() {
        return this.appConfiguration.getCibaEndUserNotificationConfig().getPublicVapidKey();
    }

    public String getAuthRequest() {
        String authorizationEndpoint = this.appConfiguration.getAuthorizationEndpoint();
        String clientId = this.appConfiguration.getBackchannelClientId();
        String redirectUri = this.appConfiguration.getBackchannelRedirectUri();
        String responseType = "token id_token";
        String scope = "openid";
        String state = UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        RedirectUri authRequest = new RedirectUri(authorizationEndpoint);
        authRequest.addResponseParameter("client_id", clientId);
        authRequest.addResponseParameter("redirect_uri", redirectUri);
        authRequest.addResponseParameter("response_type", responseType);
        authRequest.addResponseParameter("scope", scope);
        authRequest.addResponseParameter("state", state);
        authRequest.addResponseParameter("nonce", nonce);
        return authRequest.toString();
    }

    public String getBackchannelDeviceRegistrationEndpoint() {
        return this.appConfiguration.getBackchannelDeviceRegistrationEndpoint();
    }
}

