/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.bcauthorize.ws.rs;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import org.gluu.oxauth.bcauthorize.ws.rs.BackchannelAuthorizeRestWebService;
import org.gluu.oxauth.ciba.CIBAAuthorizeParamsValidatorService;
import org.gluu.oxauth.ciba.CIBAEndUserNotificationService;
import org.gluu.oxauth.client.JwkClient;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.authorize.JwtAuthorizationRequest;
import org.gluu.oxauth.model.authorize.ScopeChecker;
import org.gluu.oxauth.model.ciba.BackchannelAuthenticationErrorResponseType;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.CibaRequestCacheControl;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.AlgorithmFamily;
import org.gluu.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.RSAPublicKey;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.error.DefaultErrorResponse;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.exception.InvalidClaimException;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.jws.ECDSASigner;
import org.gluu.oxauth.model.jws.RSASigner;
import org.gluu.oxauth.model.jwt.Jwt;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.SessionClient;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.ciba.CibaRequestService;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.StringHelper;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class BackchannelAuthorizeRestWebServiceImpl
implements BackchannelAuthorizeRestWebService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private UserService userService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CIBAAuthorizeParamsValidatorService cibaAuthorizeParamsValidatorService;
    @Inject
    private CIBAEndUserNotificationService cibaEndUserNotificationService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;

    @Override
    public Response requestBackchannelAuthorizationPost(String clientId, String scope, String clientNotificationToken, String acrValues, String loginHintToken, String idTokenHint, String loginHint, String bindingMessage, String userCodeParam, Integer requestedExpiry, String request, String requestUri, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        scope = ServerUtil.urlDecode(scope);
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.BACKCHANNEL_AUTHENTICATION);
        oAuth2AuditLog.setClientId(clientId);
        oAuth2AuditLog.setScope(scope);
        this.log.debug("Attempting to request backchannel authorization: clientId = {}, scope = {}, clientNotificationToken = {}, acrValues = {}, loginHintToken = {}, idTokenHint = {}, loginHint = {}, bindingMessage = {}, userCodeParam = {}, requestedExpiry = {}, request= {}", new Object[]{clientId, scope, clientNotificationToken, acrValues, loginHintToken, idTokenHint, loginHint, bindingMessage, userCodeParam, requestedExpiry, request});
        this.log.debug("Attempting to request backchannel authorization: isSecure = {}", (Object)securityContext.isSecure());
        Response.ResponseBuilder builder = Response.ok();
        SessionClient sessionClient = this.identity.getSessionClient();
        Client client = null;
        if (sessionClient != null) {
            client = sessionClient.getClient();
        }
        if (client == null) {
            builder = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_CLIENT));
            return builder.build();
        }
        ArrayList<String> scopes = new ArrayList<String>();
        if (StringHelper.isNotEmpty((String)scope)) {
            Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(client, scope);
            scopes.addAll(grantedScopes);
        }
        JwtAuthorizationRequest jwtRequest = null;
        if (StringUtils.isNotBlank((String)request) || StringUtils.isNotBlank((String)requestUri)) {
            jwtRequest = JwtAuthorizationRequest.createJwtRequest(request, requestUri, client, null, this.cryptoProvider, this.appConfiguration);
            if (jwtRequest == null) {
                this.log.error("The JWT couldn't be processed");
                builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
                throw new WebApplicationException(builder.build());
            }
            this.authorizeRestWebServiceValidator.validateCibaRequestObject(jwtRequest, client.getClientId());
            if (!jwtRequest.getScopes().isEmpty()) {
                scopes.addAll(this.scopeChecker.checkScopesPolicy(client, jwtRequest.getScopes()));
            }
            if (StringUtils.isNotBlank((String)jwtRequest.getClientNotificationToken())) {
                clientNotificationToken = jwtRequest.getClientNotificationToken();
            }
            if (StringUtils.isNotBlank((String)jwtRequest.getAcrValues())) {
                acrValues = jwtRequest.getAcrValues();
            }
            if (StringUtils.isNotBlank((String)jwtRequest.getLoginHintToken())) {
                loginHintToken = jwtRequest.getLoginHintToken();
            }
            if (StringUtils.isNotBlank((String)jwtRequest.getIdTokenHint())) {
                idTokenHint = jwtRequest.getIdTokenHint();
            }
            if (StringUtils.isNotBlank((String)jwtRequest.getLoginHint())) {
                loginHint = jwtRequest.getLoginHint();
            }
            if (StringUtils.isNotBlank((String)jwtRequest.getBindingMessage())) {
                bindingMessage = jwtRequest.getBindingMessage();
            }
            if (StringUtils.isNotBlank((String)jwtRequest.getUserCode())) {
                userCodeParam = jwtRequest.getUserCode();
            }
            if (jwtRequest.getRequestedExpiry() != null) {
                requestedExpiry = jwtRequest.getRequestedExpiry();
            } else if (jwtRequest.getExp() != null) {
                requestedExpiry = Math.toIntExact((long)jwtRequest.getExp().intValue() - System.currentTimeMillis() / 1000L);
            }
        }
        if (this.appConfiguration.getFapiCompatibility().booleanValue() && jwtRequest == null) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
            return builder.build();
        }
        User user = null;
        try {
            if (Strings.isNotBlank((String)loginHint)) {
                user = this.userService.getUniqueUserByAttributes(this.appConfiguration.getBackchannelLoginHintClaims(), loginHint);
            } else if (Strings.isNotBlank((String)idTokenHint)) {
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
                if (authorizationGrant == null) {
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
                    return builder.build();
                }
                user = authorizationGrant.getUser();
            }
            if (Strings.isNotBlank((String)loginHintToken)) {
                RSAPublicKey publicKey;
                Jwt jwt = Jwt.parse((String)loginHintToken);
                SignatureAlgorithm algorithm = jwt.getHeader().getSignatureAlgorithm();
                String keyId = jwt.getHeader().getKeyId();
                if (algorithm == null || Strings.isBlank((String)keyId)) {
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
                    return builder.build();
                }
                boolean validSignature = false;
                if (algorithm.getFamily() == AlgorithmFamily.RSA) {
                    publicKey = JwkClient.getRSAPublicKey((String)client.getJwksUri(), (String)keyId);
                    RSASigner rsaSigner = new RSASigner(algorithm, publicKey);
                    validSignature = rsaSigner.validate(jwt);
                } else if (algorithm.getFamily() == AlgorithmFamily.EC) {
                    publicKey = JwkClient.getECDSAPublicKey((String)client.getJwksUri(), (String)keyId);
                    ECDSASigner ecdsaSigner = new ECDSASigner(algorithm, (ECDSAPublicKey)publicKey);
                    validSignature = ecdsaSigner.validate(jwt);
                }
                if (!validSignature) {
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
                    return builder.build();
                }
                JSONObject subject = jwt.getClaims().getClaimAsJSON("subject");
                if (subject == null || !subject.has("subject_type") || !subject.has(subject.getString("subject_type"))) {
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
                    return builder.build();
                }
                String subjectTypeKey = subject.getString("subject_type");
                String subjectTypeValue = subject.getString(subjectTypeKey);
                user = this.userService.getUniqueUserByAttributes(this.appConfiguration.getBackchannelLoginHintClaims(), subjectTypeValue);
            }
        }
        catch (InvalidJwtException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        if (user == null) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
            return builder.build();
        }
        try {
            String userCode = (String)user.getAttribute("oxAuthBackchannelUserCode", true, false);
            DefaultErrorResponse cibaAuthorizeParamsValidation = this.cibaAuthorizeParamsValidatorService.validateParams(scopes, clientNotificationToken, client.getBackchannelTokenDeliveryMode(), loginHintToken, idTokenHint, loginHint, bindingMessage, client.getBackchannelUserCodeParameter(), userCodeParam, userCode, requestedExpiry);
            if (cibaAuthorizeParamsValidation != null) {
                builder = Response.status((int)cibaAuthorizeParamsValidation.getStatus());
                builder.entity((Object)this.errorResponseFactory.errorAsJson(cibaAuthorizeParamsValidation.getType(), cibaAuthorizeParamsValidation.getReason()));
                return builder.build();
            }
            String deviceRegistrationToken = (String)user.getAttribute("oxAuthBackchannelDeviceRegistrationToken", true, false);
            if (deviceRegistrationToken == null) {
                builder = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode());
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNAUTHORIZED_END_USER_DEVICE));
                return builder.build();
            }
            int expiresIn = requestedExpiry != null ? requestedExpiry.intValue() : this.appConfiguration.getBackchannelAuthenticationResponseExpiresIn();
            Integer interval = client.getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH ? null : Integer.valueOf(this.appConfiguration.getBackchannelAuthenticationResponseInterval());
            long currentTime = new Date().getTime();
            CibaRequestCacheControl cibaRequestCacheControl = new CibaRequestCacheControl(user, client, expiresIn, scopes, clientNotificationToken, bindingMessage, currentTime, acrValues);
            this.cibaRequestService.save(cibaRequestCacheControl, expiresIn);
            String authReqId = cibaRequestCacheControl.getAuthReqId();
            this.cibaEndUserNotificationService.notifyEndUser(cibaRequestCacheControl.getScopesAsString(), cibaRequestCacheControl.getAcrValues(), authReqId, deviceRegistrationToken);
            builder.entity((Object)this.getJSONObject(authReqId, expiresIn, interval).toString(4).replace("\\/", "/"));
            builder.type(MediaType.APPLICATION_JSON_TYPE);
            builder.cacheControl(ServerUtil.cacheControl(true, false));
        }
        catch (JSONException e) {
            builder = Response.status((int)400);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidClaimException e) {
            builder = Response.status((int)400);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private JSONObject getJSONObject(String authReqId, int expiresIn, Integer interval) throws JSONException {
        JSONObject responseJsonObject = new JSONObject();
        responseJsonObject.put("auth_req_id", (Object)authReqId);
        responseJsonObject.put("expires_in", expiresIn);
        if (interval != null) {
            responseJsonObject.put("interval", (Object)interval);
        }
        return responseJsonObject;
    }
}

