/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.authorize.ws.rs;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.jsf2.message.FacesMessages;
import org.gluu.oxauth.i18n.LanguageBean;
import org.gluu.oxauth.model.common.DeviceAuthorizationCacheControl;
import org.gluu.oxauth.model.common.DeviceAuthorizationStatus;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.DeviceAuthorizationService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.util.RedirectUri;
import org.slf4j.Logger;

@Named
@RequestScoped
public class DeviceAuthorizationAction
implements Serializable {
    @Inject
    private Logger log;
    @Inject
    private FacesMessages facesMessages;
    @Inject
    private LanguageBean languageBean;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    private String code;
    private String sessionId;
    private String state;
    private String sessionState;
    private String error;
    private String errorDescription;
    private String userCode;
    private String userCodePart1;
    private String userCodePart2;
    private String titleMsg;
    private String descriptionMsg;
    private Long lastAttempt = System.currentTimeMillis();
    private byte attempts;

    public void pageLoaded() {
        this.log.info("Processing device authorization page request, userCode: {}, code: {}, sessionId: {}, state: {}, sessionState: {}, error: {}, errorDescription: {}", new Object[]{this.userCode, this.code, this.sessionId, this.state, this.sessionState, this.error, this.errorDescription});
        if (StringUtils.isNotBlank((String)this.error)) {
            this.titleMsg = this.error;
            this.descriptionMsg = this.errorDescription;
        }
        if (this.isDeviceAuthnCompleted()) {
            this.titleMsg = this.languageBean.getMessage("device.authorization.access.granted.title");
            this.descriptionMsg = this.languageBean.getMessage("device.authorization.authorization.completed.msg");
        }
        this.initializeSession();
    }

    public void initializeSession() {
        SessionId sessionId = this.sessionIdService.getSessionId();
        HashMap<String, String> sessionAttributes = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.userCode)) {
            sessionAttributes.put("user_code", this.userCode);
        }
        if (sessionId == null) {
            SessionId deviceAuthzSession = this.sessionIdService.generateUnauthenticatedSessionId(null, new Date(), SessionIdState.UNAUTHENTICATED, sessionAttributes, false);
            this.sessionIdService.persistSessionId(deviceAuthzSession);
            this.cookieService.createSessionIdCookie(deviceAuthzSession, false);
            this.log.debug("Created session for device authorization grant page, sessionId: {}", (Object)deviceAuthzSession.getId());
        } else {
            if (StringUtils.isNotBlank((String)sessionId.getSessionAttributes().get("last_attempt")) && StringUtils.isNotBlank((String)sessionId.getSessionAttributes().get("attemps"))) {
                this.lastAttempt = Long.parseLong(sessionId.getSessionAttributes().get("last_attempt"));
                this.attempts = Byte.parseByte(sessionId.getSessionAttributes().get("attemps"));
            }
            sessionAttributes.put("last_attempt", String.valueOf(this.lastAttempt));
            sessionAttributes.put("attemps", String.valueOf(this.attempts));
            sessionId.setSessionAttributes(sessionAttributes);
            this.sessionIdService.updateSessionId(sessionId);
        }
    }

    public void processUserCodeVerification() {
        SessionId session = this.sessionIdService.getSessionId();
        if (session == null) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, this.languageBean.getMessage("error.errorEncountered"));
            return;
        }
        if (!this.preventBruteForcing(session)) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, this.languageBean.getMessage("device.authorization.brute.forcing.msg"));
            return;
        }
        String userCode = StringUtils.isBlank((String)this.userCodePart1) && StringUtils.isBlank((String)this.userCodePart2) ? session.getSessionAttributes().get("user_code") : this.userCodePart1 + '-' + this.userCodePart2;
        if (!this.validateFormat(userCode = userCode.toUpperCase())) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, this.languageBean.getMessage("device.authorization.invalid.user.code"));
            return;
        }
        DeviceAuthorizationCacheControl cacheData = this.deviceAuthorizationService.getDeviceAuthzByUserCode(userCode);
        this.log.debug("Verifying device authorization cache data: {}", (Object)cacheData);
        String message = null;
        if (cacheData != null) {
            if (cacheData.getStatus() == DeviceAuthorizationStatus.PENDING) {
                session.getSessionAttributes().put("user_code", userCode);
                session.getSessionAttributes().remove("last_attempt");
                session.getSessionAttributes().remove("attemps");
                this.sessionIdService.updateSessionId(session);
                this.redirectToAuthorization(cacheData);
            } else {
                message = cacheData.getStatus() == DeviceAuthorizationStatus.DENIED ? this.languageBean.getMessage("device.authorization.access.denied.msg") : this.languageBean.getMessage("device.authorization.expired.code.msg");
            }
        } else {
            message = this.languageBean.getMessage("device.authorization.invalid.user.code");
        }
        if (message != null) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, message);
        }
    }

    private boolean preventBruteForcing(SessionId session) {
        this.lastAttempt = Long.valueOf(session.getSessionAttributes().getOrDefault("last_attempt", "0"));
        this.attempts = Byte.parseByte(session.getSessionAttributes().getOrDefault("attemps", "0"));
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastAttempt > 500L && this.attempts < 5) {
            this.lastAttempt = currentTime;
            this.attempts = (byte)(this.attempts + 1);
            session.getSessionAttributes().put("last_attempt", String.valueOf(this.lastAttempt));
            session.getSessionAttributes().put("attemps", String.valueOf(this.attempts));
            this.sessionIdService.updateSessionId(session);
            return true;
        }
        this.log.trace("User has done too many failed user code verification requests, sessionId: {}", (Object)this.sessionIdService.getSessionId());
        return false;
    }

    private boolean validateFormat(String userCode) {
        String regex = "[BCDFGHJKLMNPQRSTVWXZ]{4}-[BCDFGHJKLMNPQRSTVWXZ]{4}";
        return userCode.matches(regex);
    }

    private void redirectToAuthorization(DeviceAuthorizationCacheControl cacheData) {
        try {
            this.log.info("Redirecting to authorization code flow to process device authorization, data: {}", (Object)cacheData);
            String authorizationEndpoint = this.appConfiguration.getAuthorizationEndpoint();
            String clientId = cacheData.getClient().getClientId();
            String responseType = this.appConfiguration.getDeviceAuthzResponseTypeToProcessAuthz();
            String scope = Util.listAsString(cacheData.getScopes());
            String state = UUID.randomUUID().toString();
            String nonce = UUID.randomUUID().toString();
            RedirectUri authRequest = new RedirectUri(authorizationEndpoint);
            authRequest.addResponseParameter("client_id", clientId);
            authRequest.addResponseParameter("response_type", responseType);
            authRequest.addResponseParameter("scope", scope);
            authRequest.addResponseParameter("state", state);
            authRequest.addResponseParameter("nonce", nonce);
            FacesContext.getCurrentInstance().getExternalContext().redirect(authRequest.toString());
        }
        catch (IOException e) {
            this.log.error("Problems trying to redirect to authorization page from device authorization action", (Throwable)e);
            String message = this.languageBean.getMessage("error.errorEncountered");
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, message);
        }
        catch (Exception e) {
            this.log.error("Exception processing redirection", (Throwable)e);
            String message = this.languageBean.getMessage("error.errorEncountered");
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, message);
        }
    }

    public boolean isNewRequest() {
        return StringUtils.isBlank((String)this.code) && StringUtils.isBlank((String)this.sessionId) && StringUtils.isBlank((String)this.state) && StringUtils.isBlank((String)this.error) && StringUtils.isBlank((String)this.errorDescription);
    }

    public boolean isErrorResponse() {
        return StringUtils.isNotBlank((String)this.error) && StringUtils.isNotBlank((String)this.error);
    }

    public boolean isCompleteVerificationMode() {
        return this.isNewRequest() && StringUtils.isNotBlank((String)this.userCode);
    }

    public boolean isDeviceAuthnCompleted() {
        return StringUtils.isNotBlank((String)this.code) && StringUtils.isNotBlank((String)this.state) && StringUtils.isBlank((String)this.error);
    }

    public String getUserCodePart1() {
        return this.userCodePart1;
    }

    public void setUserCodePart1(String userCodePart1) {
        this.userCodePart1 = userCodePart1;
    }

    public String getUserCodePart2() {
        return this.userCodePart2;
    }

    public void setUserCodePart2(String userCodePart2) {
        this.userCodePart2 = userCodePart2;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getTitleMsg() {
        return this.titleMsg;
    }

    public void setTitleMsg(String titleMsg) {
        this.titleMsg = titleMsg;
    }

    public String getDescriptionMsg() {
        return this.descriptionMsg;
    }

    public void setDescriptionMsg(String descriptionMsg) {
        this.descriptionMsg = descriptionMsg;
    }
}

