/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.auth;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.gluu.model.security.Identity;
import org.gluu.oxauth.auth.Authenticator;
import org.gluu.oxauth.auth.MTLSService;
import org.gluu.oxauth.model.ciba.BackchannelAuthenticationErrorResponseType;
import org.gluu.oxauth.model.common.AbstractToken;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.SessionIdState;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.exception.InvalidJwtException;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.ClientAssertion;
import org.gluu.oxauth.model.token.ClientAssertionType;
import org.gluu.oxauth.model.token.HttpAuthTokenType;
import org.gluu.oxauth.model.token.TokenErrorResponseType;
import org.gluu.oxauth.service.ClientFilterService;
import org.gluu.oxauth.service.ClientService;
import org.gluu.oxauth.service.CookieService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.token.TokenService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@WebFilter(asyncSupported=true, urlPatterns={"/restv1/authorize", "/restv1/token", "/restv1/userinfo", "/restv1/revoke", "/restv1/revoke_session", "/restv1/bc-authorize", "/restv1/device_authorization"}, displayName="oxAuth")
public class AuthenticationFilter
implements Filter {
    private static final String REALM = "oxAuth";
    @Inject
    private Logger log;
    @Inject
    private Authenticator authenticator;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CookieService cookieService;
    @Inject
    private ClientService clientService;
    @Inject
    private ClientFilterService clientFilterService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Identity identity;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private MTLSService mtlsService;
    @Inject
    private TokenService tokenService;
    private String realm;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        try {
            String requestUrl = httpRequest.getRequestURL().toString();
            this.log.trace("Get request to: '{}'", (Object)requestUrl);
            boolean tokenEndpoint = ServerUtil.isSameRequestPath(requestUrl, this.appConfiguration.getTokenEndpoint());
            boolean tokenRevocationEndpoint = ServerUtil.isSameRequestPath(requestUrl, this.appConfiguration.getTokenRevocationEndpoint());
            boolean backchannelAuthenticationEnpoint = ServerUtil.isSameRequestPath(requestUrl, this.appConfiguration.getBackchannelAuthenticationEndpoint());
            boolean deviceAuthorizationEndpoint = ServerUtil.isSameRequestPath(requestUrl, this.appConfiguration.getDeviceAuthzEndpoint());
            boolean umaTokenEndpoint = requestUrl.endsWith("/uma/token");
            boolean revokeSessionEndpoint = requestUrl.endsWith("/revoke_session");
            String authorizationHeader = httpRequest.getHeader("Authorization");
            if (this.processMTLS(httpRequest, httpResponse, filterChain)) {
                return;
            }
            if ((tokenRevocationEndpoint || deviceAuthorizationEndpoint) && this.clientService.isPublic(httpRequest.getParameter("client_id"))) {
                this.log.trace("Skipped authentication for {} for public client.", (Object)(tokenRevocationEndpoint ? "Token Revocation" : "Device Authorization"));
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            if (tokenEndpoint || umaTokenEndpoint || revokeSessionEndpoint || tokenRevocationEndpoint || deviceAuthorizationEndpoint) {
                this.log.debug("Starting endpoint authentication {}", (Object)requestUrl);
                String accessToken = this.tokenService.getToken(authorizationHeader, HttpAuthTokenType.Bearer, HttpAuthTokenType.AccessToken);
                if (StringUtils.isNotBlank((String)accessToken)) {
                    this.processAuthByAccessToken(accessToken, httpRequest, httpResponse, filterChain);
                    return;
                }
                if (httpRequest.getParameter("client_assertion") != null && httpRequest.getParameter("client_assertion_type") != null) {
                    this.log.debug("Starting JWT token endpoint authentication");
                    this.processJwtAuth(httpRequest, httpResponse, filterChain);
                } else if (this.tokenService.isBasicAuthToken(authorizationHeader)) {
                    this.log.debug("Starting Basic Auth token endpoint authentication");
                    this.processBasicAuth(httpRequest, httpResponse, filterChain);
                } else {
                    this.log.debug("Starting POST Auth token endpoint authentication");
                    this.processPostAuth(this.clientFilterService, httpRequest, httpResponse, filterChain, tokenEndpoint);
                }
            } else if (backchannelAuthenticationEnpoint) {
                if (httpRequest.getParameter("client_assertion") != null && httpRequest.getParameter("client_assertion_type") != null) {
                    this.log.debug("Starting JWT token endpoint authentication");
                    this.processJwtAuth(httpRequest, httpResponse, filterChain);
                } else if (this.tokenService.isBasicAuthToken(authorizationHeader)) {
                    this.processBasicAuth(httpRequest, httpResponse, filterChain);
                } else {
                    String entity = this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST);
                    httpResponse.setStatus(400);
                    httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
                    httpResponse.setContentType(ContentType.APPLICATION_JSON.toString());
                    httpResponse.setHeader("Content-Length", String.valueOf(entity.length()));
                    PrintWriter out = httpResponse.getWriter();
                    out.print(entity);
                    out.flush();
                }
            } else if (authorizationHeader != null && !this.tokenService.isNegotiateAuthToken(authorizationHeader)) {
                if (this.tokenService.isBearerAuthToken(authorizationHeader)) {
                    this.processBearerAuth(httpRequest, httpResponse, filterChain);
                } else if (this.tokenService.isBasicAuthToken(authorizationHeader)) {
                    this.processBasicAuth(httpRequest, httpResponse, filterChain);
                } else {
                    httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
                    httpResponse.sendError(401, "Not authorized");
                }
            } else {
                String sessionId = this.cookieService.getSessionIdFromCookie(httpRequest);
                List prompts = Prompt.fromString((String)httpRequest.getParameter("prompt"), (String)" ");
                if (StringUtils.isBlank((String)sessionId) && this.appConfiguration.getSessionIdRequestParameterEnabled().booleanValue()) {
                    sessionId = httpRequest.getParameter("session_id");
                }
                SessionId sessionIdObject = null;
                if (StringUtils.isNotBlank((String)sessionId)) {
                    sessionIdObject = this.sessionIdService.getSessionId(sessionId);
                }
                if (sessionIdObject != null && SessionIdState.AUTHENTICATED == sessionIdObject.getState() && !prompts.contains(Prompt.LOGIN)) {
                    this.processSessionAuth(sessionId, httpRequest, httpResponse, filterChain);
                } else {
                    filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            }
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse() != null) {
                this.sendResponse(httpResponse, ex);
                return;
            }
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private boolean processMTLS(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws Exception {
        Client client;
        if (this.cryptoProvider == null) {
            this.log.debug("Unable to create cryptoProvider.");
            return false;
        }
        String clientId = httpRequest.getParameter("client_id");
        if (StringUtils.isNotBlank((String)clientId) && (client = this.clientService.getClient(clientId)) != null && (client.getAuthenticationMethod() == AuthenticationMethod.TLS_CLIENT_AUTH || client.getAuthenticationMethod() == AuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH)) {
            return this.mtlsService.processMTLS(httpRequest, httpResponse, filterChain, client);
        }
        return false;
    }

    private void processAuthByAccessToken(String accessToken, HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) {
        try {
            this.log.trace("Authenticating client by access token {} ...", (Object)accessToken);
            if (StringUtils.isBlank((String)accessToken)) {
                this.sendError(httpResponse);
                return;
            }
            AuthorizationGrant grant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
            if (grant == null) {
                this.sendError(httpResponse);
                return;
            }
            AbstractToken accessTokenObj = grant.getAccessToken(accessToken);
            if (accessTokenObj == null || !accessTokenObj.isValid()) {
                this.sendError(httpResponse);
                return;
            }
            Client client = grant.getClient();
            this.authenticator.configureSessionClient(client);
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        catch (Exception ex) {
            this.log.error("Failed to authenticate client by access_token", (Throwable)ex);
            this.sendError(httpResponse);
            return;
        }
    }

    private void processSessionAuth(String p_sessionId, HttpServletRequest p_httpRequest, HttpServletResponse p_httpResponse, FilterChain p_filterChain) {
        boolean requireAuth = !this.authenticator.authenticateBySessionId(p_sessionId);
        this.log.trace("Process Session Auth, sessionId = {}, requireAuth = {}", (Object)p_sessionId, (Object)requireAuth);
        if (!requireAuth) {
            try {
                p_filterChain.doFilter((ServletRequest)p_httpRequest, (ServletResponse)p_httpResponse);
            }
            catch (Exception ex) {
                this.log.error("Failed to process session authentication", (Throwable)ex);
                requireAuth = true;
            }
        }
        if (requireAuth) {
            this.sendError(p_httpResponse);
        }
    }

    private void processBasicAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        boolean requireAuth = true;
        try {
            String header = servletRequest.getHeader("Authorization");
            if (this.tokenService.isBasicAuthToken(header)) {
                String base64Token = this.tokenService.getBasicToken(header);
                String token = new String(Base64.decodeBase64((String)base64Token), StandardCharsets.UTF_8);
                String username = "";
                String password = "";
                int delim = token.indexOf(":");
                if (delim != -1) {
                    username = URLDecoder.decode(token.substring(0, delim), "UTF-8");
                    password = URLDecoder.decode(token.substring(delim + 1), "UTF-8");
                }
                boolean bl = requireAuth = !StringHelper.equals((String)username, (String)this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn();
                if (!(!requireAuth || username.equals(this.identity.getCredentials().getUsername()) && this.identity.isLoggedIn())) {
                    this.identity.getCredentials().setUsername(username);
                    this.identity.getCredentials().setPassword(password);
                    if (servletRequest.getRequestURI().endsWith("/token") || servletRequest.getRequestURI().endsWith("/revoke") || servletRequest.getRequestURI().endsWith("/revoke_session") || servletRequest.getRequestURI().endsWith("/userinfo") || servletRequest.getRequestURI().endsWith("/bc-authorize") || servletRequest.getRequestURI().endsWith("/device_authorization")) {
                        Client client = this.clientService.getClient(username);
                        if (client == null || AuthenticationMethod.CLIENT_SECRET_BASIC != client.getAuthenticationMethod()) {
                            throw new Exception("The Token Authentication Method is not valid.");
                        }
                        requireAuth = !this.authenticator.authenticateClient(servletRequest);
                    } else {
                        boolean bl2 = requireAuth = !this.authenticator.authenticateUser(servletRequest);
                    }
                }
            }
            if (!requireAuth) {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                return;
            }
        }
        catch (Exception ex) {
            this.log.info("Basic authentication failed", (Throwable)ex);
        }
        if (requireAuth && !this.identity.isLoggedIn()) {
            this.sendError(servletResponse);
        }
    }

    private void processBearerAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        try {
            String header = servletRequest.getHeader("Authorization");
            if (this.tokenService.isBearerAuthToken(header)) {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
        }
        catch (Exception ex) {
            this.log.info("Bearer authorization failed: {}", (Throwable)ex);
        }
    }

    private void processPostAuth(ClientFilterService clientFilterService, HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain, boolean tokenEndpoint) {
        try {
            String clientId = "";
            String clientSecret = "";
            boolean isExistUserPassword = false;
            if (StringHelper.isNotEmpty((String)servletRequest.getParameter("client_id")) && StringHelper.isNotEmpty((String)servletRequest.getParameter("client_secret"))) {
                clientId = servletRequest.getParameter("client_id");
                clientSecret = servletRequest.getParameter("client_secret");
                isExistUserPassword = true;
            }
            this.log.trace("isExistUserPassword: {}", (Object)isExistUserPassword);
            boolean requireAuth = !StringHelper.equals((String)clientId, (String)this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn();
            this.log.debug("requireAuth: '{}'", (Object)requireAuth);
            if (requireAuth) {
                Client client;
                if (isExistUserPassword) {
                    Client client2 = this.clientService.getClient(clientId);
                    if (client2 != null && AuthenticationMethod.CLIENT_SECRET_POST == client2.getAuthenticationMethod()) {
                        if (!clientId.equals(this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn()) {
                            this.identity.logout();
                            this.identity.getCredentials().setUsername(clientId);
                            this.identity.getCredentials().setPassword(clientSecret);
                            requireAuth = !this.authenticator.authenticateClient(servletRequest);
                        } else {
                            this.authenticator.configureSessionClient(client2);
                        }
                    }
                } else if (Boolean.TRUE.equals(this.appConfiguration.getClientAuthenticationFiltersEnabled())) {
                    String clientDn = clientFilterService.processAuthenticationFilters(servletRequest.getParameterMap());
                    if (clientDn != null) {
                        Client client3 = this.clientService.getClientByDn(clientDn);
                        this.identity.logout();
                        this.identity.getCredentials().setUsername(client3.getClientId());
                        this.identity.getCredentials().setPassword(null);
                        requireAuth = !this.authenticator.authenticateClient(servletRequest, true);
                    }
                } else if (tokenEndpoint && (client = this.clientService.getClient(servletRequest.getParameter("client_id"))) != null && client.getAuthenticationMethod() == AuthenticationMethod.NONE) {
                    this.identity.logout();
                    this.identity.getCredentials().setUsername(client.getClientId());
                    this.identity.getCredentials().setPassword(null);
                    boolean bl = requireAuth = !this.authenticator.authenticateClient(servletRequest, true);
                }
            }
            if (!requireAuth) {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                return;
            }
            if (!this.identity.isLoggedIn()) {
                this.sendError(servletResponse);
            }
        }
        catch (Exception ex) {
            this.log.error("Post authentication failed: {}", (Throwable)ex);
        }
    }

    private void processJwtAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) {
        boolean authorized = false;
        try {
            if (servletRequest.getParameter("client_assertion") != null && servletRequest.getParameter("client_assertion_type") != null) {
                String clientId = servletRequest.getParameter("client_id");
                ClientAssertionType clientAssertionType = ClientAssertionType.fromString((String)servletRequest.getParameter("client_assertion_type"));
                String encodedAssertion = servletRequest.getParameter("client_assertion");
                if (clientAssertionType == ClientAssertionType.JWT_BEARER) {
                    ClientAssertion clientAssertion = new ClientAssertion(this.appConfiguration, this.cryptoProvider, clientId, clientAssertionType, encodedAssertion);
                    String username = clientAssertion.getSubjectIdentifier();
                    String password = clientAssertion.getClientSecret();
                    if (!username.equals(this.identity.getCredentials().getUsername()) || !this.identity.isLoggedIn()) {
                        this.identity.getCredentials().setUsername(username);
                        this.identity.getCredentials().setPassword(password);
                        this.authenticator.authenticateClient(servletRequest, true);
                        authorized = true;
                    }
                }
            }
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (IOException | ServletException | InvalidJwtException ex) {
            this.log.info("JWT authentication failed: {}", ex);
        }
        if (!authorized) {
            this.sendError(servletResponse);
        }
    }

    private void sendError(HttpServletResponse servletResponse) {
        try (PrintWriter out = servletResponse.getWriter();){
            servletResponse.setStatus(401);
            servletResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            servletResponse.setContentType("application/json;charset=UTF-8");
            out.write(this.errorResponseFactory.errorAsJson((IErrorType)TokenErrorResponseType.INVALID_CLIENT, "Unable to authenticate client."));
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void sendResponse(HttpServletResponse servletResponse, WebApplicationException e) {
        try (PrintWriter out = servletResponse.getWriter();){
            servletResponse.setStatus(e.getResponse().getStatus());
            servletResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            servletResponse.setContentType("application/json;charset=UTF-8");
            out.write(e.getResponse().getEntity().toString());
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        return REALM;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void destroy() {
    }
}

